/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.org.apache.commons.io.comparator.PathFileComparator;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class ReproducibleDirectoryWalker
implements DirectoryWalker {
    private final FileSystem fileSystem;

    public ReproducibleDirectoryWalker(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected File[] getChildren(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            Arrays.sort(children, PathFileComparator.PATH_COMPARATOR);
        }
        return children;
    }

    @Override
    public void walkDir(File file, RelativePath path, FileVisitor visitor, Spec<? super FileTreeElement> spec, AtomicBoolean stopFlag, boolean postfix) {
        int i;
        File[] children = this.getChildren(file);
        if (children == null) {
            if (file.isDirectory() && !file.canRead()) {
                throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
            }
            throw new GradleException(String.format("Could not list contents of '%s'.", file));
        }
        ArrayList<DefaultFileVisitDetails> dirs = new ArrayList<DefaultFileVisitDetails>();
        for (i = 0; !stopFlag.get() && i < children.length; ++i) {
            File child = children[i];
            boolean isFile = child.isFile();
            RelativePath childPath = path.append(isFile, child.getName());
            DefaultFileVisitDetails details = new DefaultFileVisitDetails(child, childPath, stopFlag, this.fileSystem, this.fileSystem);
            if (!DirectoryFileTree.isAllowed(details, spec)) continue;
            if (isFile) {
                visitor.visitFile(details);
                continue;
            }
            dirs.add(details);
        }
        for (i = 0; !stopFlag.get() && i < dirs.size(); ++i) {
            FileVisitDetails dir = (FileVisitDetails)dirs.get(i);
            if (postfix) {
                this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag, postfix);
                visitor.visitDir(dir);
                continue;
            }
            visitor.visitDir(dir);
            this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag, postfix);
        }
    }
}

