/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfAwareClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaInfAwareClasspathResourceHasher.class);
    private final ResourceHasher delegate;
    private final ResourceEntryFilter attributeResourceFilter;

    public MetaInfAwareClasspathResourceHasher(ResourceHasher delegate, ResourceEntryFilter attributeResourceFilter) {
        this.delegate = delegate;
        this.attributeResourceFilter = attributeResourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.attributeResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshotContext snapshotContext) throws IOException {
        String relativePath = String.join((CharSequence)"/", snapshotContext.getRelativePathSegments().get());
        if (MetaInfAwareClasspathResourceHasher.isManifestFile(relativePath)) {
            return this.tryHashWithFallback(snapshotContext);
        }
        return this.delegate.hash(snapshotContext);
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (MetaInfAwareClasspathResourceHasher.isManifestFile(zipEntry.getName())) {
            return this.tryHashWithFallback(zipEntryContext);
        }
        return this.delegate.hash(zipEntryContext);
    }

    @Nullable
    private HashCode tryHashWithFallback(RegularFileSnapshotContext snapshotContext) throws IOException {
        HashCode hashCode;
        FileInputStream manifestFileInputStream = new FileInputStream(snapshotContext.getSnapshot().getAbsolutePath());
        try {
            hashCode = this.hashManifest(manifestFileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    manifestFileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.debug("Could not load fingerprint for " + snapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)e);
                return this.delegate.hash(snapshotContext);
            }
        }
        manifestFileInputStream.close();
        return hashCode;
    }

    @Nullable
    private HashCode tryHashWithFallback(ZipEntryContext zipEntryContext) throws IOException {
        try {
            return zipEntryContext.getEntry().withInputStream(this::hashManifest);
        }
        catch (IOException e) {
            LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)e);
            return this.delegate.hash(zipEntryContext);
        }
    }

    private static boolean isManifestFile(String name) {
        return name.equals("META-INF/MANIFEST.MF");
    }

    private HashCode hashManifest(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Hasher hasher = Hashing.newHasher();
        Attributes mainAttributes = manifest.getMainAttributes();
        this.hashManifestAttributes(mainAttributes, "main", hasher);
        Map<String, Attributes> entries = manifest.getEntries();
        TreeSet<String> names = new TreeSet<String>(manifest.getEntries().keySet());
        for (String name : names) {
            this.hashManifestAttributes(entries.get(name), name, hasher);
        }
        return hasher.hash();
    }

    private void hashManifestAttributes(Attributes attributes, String name, Hasher hasher) {
        Map<String, String> entries = attributes.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString().toLowerCase(Locale.ROOT), entry -> (String)entry.getValue()));
        List normalizedEntries = entries.entrySet().stream().filter(entry -> !this.attributeResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        if (!normalizedEntries.isEmpty()) {
            hasher.putString(name);
            for (Map.Entry entry2 : normalizedEntries) {
                hasher.putString((CharSequence)entry2.getKey());
                hasher.putString((CharSequence)entry2.getValue());
            }
        }
    }
}

