/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class UnzipTransform
implements TransformAction<TransformParameters.None> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getZippedFile();

    @Override
    public void transform(TransformOutputs outputs) {
        File zippedFile = this.getZippedFile().get().getAsFile();
        String unzippedDirName = FilenameUtils.removeExtension((String)zippedFile.getName());
        File unzipDir = outputs.dir(unzippedDirName);
        try {
            UnzipTransform.unzipTo(zippedFile, unzipDir);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static void unzipTo(File headersZip, File unzipDir) throws IOException {
        try (ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(headersZip)));){
            ZipEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outFile = new File(unzipDir, GUtil.safeZipEntryName(entry.getName()));
                Files.createParentDirs((File)outFile);
                try (FileOutputStream outputStream = new FileOutputStream(outFile);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        }
    }
}

