/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExternalResourceArtifactResolver
implements ExternalResourceArtifactResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceArtifactResolver.class);
    private final ExternalResourceRepository repository;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final List<ResourcePattern> ivyPatterns;
    private final List<ResourcePattern> artifactPatterns;
    private final FileStore<ModuleComponentArtifactIdentifier> fileStore;
    private final CacheAwareExternalResourceAccessor resourceAccessor;

    public DefaultExternalResourceArtifactResolver(ExternalResourceRepository repository, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns, FileStore<ModuleComponentArtifactIdentifier> fileStore, CacheAwareExternalResourceAccessor resourceAccessor) {
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.ivyPatterns = ivyPatterns;
        this.artifactPatterns = artifactPatterns;
        this.fileStore = fileStore;
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    public LocallyAvailableExternalResource resolveArtifact(ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        if (artifact instanceof ModuleDescriptorArtifactMetadata) {
            return this.downloadStaticResource(this.ivyPatterns, artifact, result2);
        }
        return this.downloadStaticResource(this.artifactPatterns, artifact, result2);
    }

    @Override
    public boolean artifactExists(ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        return this.staticResourceExists(this.artifactPatterns, artifact, result2);
    }

    private boolean staticResourceExists(List<ResourcePattern> patternList, ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        for (ResourcePattern resourcePattern : patternList) {
            if (this.isIncomplete(resourcePattern, artifact)) continue;
            ExternalResourceName location = resourcePattern.getLocation(artifact);
            result2.attempted(location);
            LOGGER.debug("Loading {}", (Object)location);
            try {
                if (this.repository.resource(location, true).getMetaData() == null) continue;
                return true;
            }
            catch (Exception e) {
                throw ResourceExceptions.getFailed(location.getUri(), e);
            }
        }
        return false;
    }

    private LocallyAvailableExternalResource downloadStaticResource(List<ResourcePattern> patternList, ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        if (artifact instanceof UrlBackedArtifactMetadata) {
            UrlBackedArtifactMetadata urlArtifact = (UrlBackedArtifactMetadata)artifact;
            return this.downloadByUrl(patternList, urlArtifact, result2);
        }
        return this.downloadByCoords(patternList, artifact, result2);
    }

    private LocallyAvailableExternalResource downloadByUrl(List<ResourcePattern> patternList, UrlBackedArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        for (ResourcePattern resourcePattern : patternList) {
            if (this.isIncomplete(resourcePattern, artifact)) continue;
            ExternalResourceName moduleDir = resourcePattern.toModuleVersionPath(this.normalizeComponentId(artifact));
            ExternalResourceName location = moduleDir.resolve(artifact.getRelativeUrl());
            result2.attempted(location);
            LOGGER.debug("Loading {}", (Object)location);
            LocallyAvailableResourceCandidates localCandidates = this.locallyAvailableResourceFinder.findCandidates(artifact);
            try {
                LocallyAvailableExternalResource resource = this.resourceAccessor.getResource(location, artifact.getId().getFileName(), this.getFileStore(artifact), localCandidates);
                if (resource == null) continue;
                return resource;
            }
            catch (Exception e) {
                throw ResourceExceptions.getFailed(location.getUri(), e);
            }
        }
        return null;
    }

    private ModuleComponentIdentifier normalizeComponentId(UrlBackedArtifactMetadata artifact) {
        ModuleComponentIdentifier rawId = artifact.getComponentId();
        if (rawId instanceof MavenUniqueSnapshotComponentIdentifier) {
            return ((MavenUniqueSnapshotComponentIdentifier)rawId).getSnapshotComponent();
        }
        return rawId;
    }

    private LocallyAvailableExternalResource downloadByCoords(List<ResourcePattern> patternList, ModuleComponentArtifactMetadata artifact, ResourceAwareResolveResult result2) {
        for (ResourcePattern resourcePattern : patternList) {
            if (this.isIncomplete(resourcePattern, artifact)) continue;
            ExternalResourceName location = resourcePattern.getLocation(artifact);
            result2.attempted(location);
            LOGGER.debug("Loading {}", (Object)location);
            LocallyAvailableResourceCandidates localCandidates = this.locallyAvailableResourceFinder.findCandidates(artifact);
            try {
                LocallyAvailableExternalResource resource = this.resourceAccessor.getResource(location, null, this.getFileStore(artifact), localCandidates);
                if (resource == null) continue;
                return resource;
            }
            catch (Exception e) {
                throw ResourceExceptions.getFailed(location.getUri(), e);
            }
        }
        return null;
    }

    private CacheAwareExternalResourceAccessor.ResourceFileStore getFileStore(final ModuleComponentArtifactMetadata artifact) {
        return new CacheAwareExternalResourceAccessor.DefaultResourceFileStore<ModuleComponentArtifactIdentifier>(this.fileStore){

            @Override
            protected ModuleComponentArtifactIdentifier computeKey() {
                return artifact.getId();
            }
        };
    }

    private boolean isIncomplete(ResourcePattern resourcePattern, ModuleComponentArtifactMetadata artifact) {
        return !resourcePattern.isComplete(artifact);
    }
}

