/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.util.Path;

public class DefaultProjectPublicationRegistry
implements ProjectPublicationRegistry {
    private final SetMultimap<Path, ProjectPublicationRegistry.Reference<?>> publicationsByProject = LinkedHashMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ProjectPublication> Collection<T> getPublications(Class<T> type, Path projectIdentityPath) {
        SetMultimap<Path, ProjectPublicationRegistry.Reference<?>> setMultimap = this.publicationsByProject;
        synchronized (setMultimap) {
            Set projectPublications = this.publicationsByProject.get((Object)projectIdentityPath);
            if (projectPublications.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ProjectPublication> result2 = new ArrayList<ProjectPublication>(projectPublications.size());
            for (ProjectPublicationRegistry.Reference reference : projectPublications) {
                if (!type.isInstance(reference.get())) continue;
                result2.add((ProjectPublication)type.cast(reference.get()));
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ProjectPublication> Collection<ProjectPublicationRegistry.Reference<T>> getPublications(Class<T> type) {
        SetMultimap<Path, ProjectPublicationRegistry.Reference<?>> setMultimap = this.publicationsByProject;
        synchronized (setMultimap) {
            Collection allPublications = this.publicationsByProject.values();
            if (allPublications.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ProjectPublicationRegistry.Reference<T>> result2 = new ArrayList<ProjectPublicationRegistry.Reference<T>>(allPublications.size());
            for (ProjectPublicationRegistry.Reference reference : allPublications) {
                if (!type.isInstance(reference.get())) continue;
                result2.add((ProjectPublicationRegistry.Reference)Cast.uncheckedCast(reference));
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublication(ProjectInternal project, ProjectPublication publication) {
        SetMultimap<Path, ProjectPublicationRegistry.Reference<?>> setMultimap = this.publicationsByProject;
        synchronized (setMultimap) {
            this.publicationsByProject.put((Object)project.getIdentityPath(), (Object)new ReferenceImpl(publication, project));
        }
    }

    private static class ReferenceImpl
    implements ProjectPublicationRegistry.Reference<ProjectPublication> {
        private final ProjectPublication publication;
        private final ProjectInternal project;

        ReferenceImpl(ProjectPublication publication, ProjectInternal project) {
            this.publication = publication;
            this.project = project;
        }

        @Override
        public ProjectPublication get() {
            return this.publication;
        }

        @Override
        public ProjectInternal getProducingProject() {
            return this.project;
        }
    }
}

