/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DynamicAddDependencyMethods;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.catalog.DependencyBundleValueSource;
import org.gradle.api.internal.provider.DefaultValueSourceProviderFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultDependencyConstraintHandler
implements DependencyConstraintHandler,
MethodMixIn {
    private static final DependencyConstraint DUMMY_CONSTRAINT = new DependencyConstraintInternal(){

        private InvalidUserCodeException shouldNotBeCalled() {
            return new InvalidUserCodeException("You shouldn't use a dependency constraint created via a Provider directly");
        }

        @Override
        public void setForce(boolean force) {
            throw this.shouldNotBeCalled();
        }

        @Override
        public boolean isForce() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public void version(Action<? super MutableVersionConstraint> configureAction) {
            throw this.shouldNotBeCalled();
        }

        @Override
        public String getReason() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public void because(@Nullable String reason) {
            throw this.shouldNotBeCalled();
        }

        @Override
        public AttributeContainer getAttributes() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public DependencyConstraint attributes(Action<? super AttributeContainer> configureAction) {
            throw this.shouldNotBeCalled();
        }

        @Override
        public VersionConstraint getVersionConstraint() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public String getGroup() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public String getName() {
            throw this.shouldNotBeCalled();
        }

        @Override
        @Nullable
        public String getVersion() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
            throw this.shouldNotBeCalled();
        }

        @Override
        public ModuleIdentifier getModule() {
            throw this.shouldNotBeCalled();
        }

        @Override
        public DependencyConstraint copy() {
            throw this.shouldNotBeCalled();
        }
    };
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactory dependencyFactory;
    private final DynamicAddDependencyMethods dynamicMethods;
    private final ObjectFactory objects;
    private final PlatformSupport platformSupport;
    private final Category platform;
    private final Category enforcedPlatform;

    public DefaultDependencyConstraintHandler(ConfigurationContainer configurationContainer, DependencyFactory dependencyFactory, ObjectFactory objects, PlatformSupport platformSupport) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.dynamicMethods = new DynamicAddDependencyMethods(configurationContainer, new DependencyConstraintAdder());
        this.objects = objects;
        this.platformSupport = platformSupport;
        this.platform = this.toCategory("platform");
        this.enforcedPlatform = this.toCategory("enforced-platform");
    }

    @Override
    public DependencyConstraint add(String configurationName, Object dependencyNotation) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, null);
    }

    @Override
    public DependencyConstraint add(String configurationName, Object dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, configureAction);
    }

    @Override
    public DependencyConstraint create(Object dependencyNotation) {
        return this.doCreate(dependencyNotation, null);
    }

    @Override
    public DependencyConstraint create(Object dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        return this.doCreate(dependencyNotation, configureAction);
    }

    @Override
    public DependencyConstraint enforcedPlatform(Object notation) {
        DependencyConstraintInternal platformDependency = (DependencyConstraintInternal)this.create(notation);
        platformDependency.setForce(true);
        this.platformSupport.addPlatformAttribute(platformDependency, this.enforcedPlatform);
        return platformDependency;
    }

    @Override
    public DependencyConstraint enforcedPlatform(Object notation, Action<? super DependencyConstraint> configureAction) {
        DependencyConstraint dep = this.enforcedPlatform(notation);
        configureAction.execute(dep);
        return dep;
    }

    private DependencyConstraint doCreate(Object dependencyNotation, @Nullable Action<? super DependencyConstraint> configureAction) {
        DependencyConstraint dependencyConstraint = this.dependencyFactory.createDependencyConstraint(dependencyNotation);
        if (configureAction != null) {
            configureAction.execute(dependencyConstraint);
        }
        return dependencyConstraint;
    }

    private DependencyConstraint doAdd(Configuration configuration2, Object dependencyNotation, @Nullable Action<? super DependencyConstraint> configureAction) {
        if (dependencyNotation instanceof ProviderConvertible) {
            return this.doAddProvider(configuration2, ((ProviderConvertible)dependencyNotation).asProvider(), configureAction);
        }
        if (dependencyNotation instanceof Provider) {
            return this.doAddProvider(configuration2, (Provider)dependencyNotation, configureAction);
        }
        DependencyConstraint dependency = this.doCreate(dependencyNotation, configureAction);
        configuration2.getDependencyConstraints().add(dependency);
        return dependency;
    }

    private DependencyConstraint doAddProvider(Configuration configuration2, Provider<?> dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        Class valueSourceType;
        if (dependencyNotation instanceof DefaultValueSourceProviderFactory.ValueSourceProvider && (valueSourceType = ((DefaultValueSourceProviderFactory.ValueSourceProvider)dependencyNotation).getValueSourceType()).isAssignableFrom(DependencyBundleValueSource.class)) {
            return this.doAddListProvider(configuration2, dependencyNotation, configureAction);
        }
        Provider<DependencyConstraint> lazyConstraint = dependencyNotation.map(this.mapDependencyConstraintProvider(configureAction));
        configuration2.getDependencyConstraints().addLater(lazyConstraint);
        return DUMMY_CONSTRAINT;
    }

    private DependencyConstraint doAddListProvider(Configuration configuration2, Provider<?> dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        ListProperty<DependencyConstraint> constraints = this.objects.listProperty(DependencyConstraint.class);
        constraints.set(dependencyNotation.map(notation -> {
            List deps = (List)Cast.uncheckedCast(notation);
            return deps.stream().map(d -> this.create(d, configureAction)).collect(Collectors.toList());
        }));
        configuration2.getDependencyConstraints().addAllLater(constraints);
        return DUMMY_CONSTRAINT;
    }

    private <T> Transformer<DependencyConstraint, T> mapDependencyConstraintProvider(Action<? super DependencyConstraint> configurationAction) {
        return lazyNotation -> this.create(lazyNotation, configurationAction);
    }

    @Override
    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    private Category toCategory(String category) {
        return this.objects.named(Category.class, category);
    }

    private class DependencyConstraintAdder
    implements DynamicAddDependencyMethods.DependencyAdder<DependencyConstraint> {
        private DependencyConstraintAdder() {
        }

        @Override
        public DependencyConstraint add(Configuration configuration2, Object dependencyNotation, Closure configureClosure) {
            if (dependencyNotation instanceof ProviderConvertible) {
                return DefaultDependencyConstraintHandler.this.doAddProvider(configuration2, ((ProviderConvertible)dependencyNotation).asProvider(), ConfigureUtil.configureUsing(configureClosure));
            }
            if (dependencyNotation instanceof Provider) {
                return DefaultDependencyConstraintHandler.this.doAddProvider(configuration2, (Provider)dependencyNotation, ConfigureUtil.configureUsing(configureClosure));
            }
            DependencyConstraint dependencyConstraint = ConfigureUtil.configure(configureClosure, DefaultDependencyConstraintHandler.this.dependencyFactory.createDependencyConstraint(dependencyNotation));
            configuration2.getDependencyConstraints().add(dependencyConstraint);
            return dependencyConstraint;
        }
    }
}

