/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.AbstractListener;
import net.rubygrapefruit.platform.prompts.AbstractPrompter;
import net.rubygrapefruit.platform.prompts.PasswordView;
import net.rubygrapefruit.platform.prompts.SelectView;
import net.rubygrapefruit.platform.prompts.SelectionListener;
import net.rubygrapefruit.platform.prompts.TextEntryListener;
import net.rubygrapefruit.platform.prompts.TextView;
import net.rubygrapefruit.platform.prompts.YesNoListener;
import net.rubygrapefruit.platform.prompts.YesNoView;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InteractivePrompter
extends AbstractPrompter {
    private final Terminals terminals;

    InteractivePrompter(Terminals terminals) {
        this.terminals = terminals;
    }

    @Override
    boolean isInteractive() {
        return true;
    }

    @Override
    Integer select(String prompt, List<String> options, int defaultOption) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        SelectView view = new SelectView(output, prompt, options, defaultOption);
        SelectionListener listener2 = new SelectionListener(view, options);
        view.render();
        this.handleInput(listener2);
        view.close(listener2.getSelected());
        return listener2.getSelected();
    }

    @Override
    String enterText(String prompt, String defaultValue) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        TextView view = new TextView(output, prompt, defaultValue);
        TextEntryListener listener2 = new TextEntryListener(view, defaultValue);
        view.render();
        this.handleInput(listener2);
        view.close(listener2.getEntered());
        return listener2.getEntered();
    }

    @Override
    String enterPassword(String prompt) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        PasswordView view = new PasswordView(output, prompt);
        TextEntryListener listener2 = new TextEntryListener(view, null);
        view.render();
        this.handleInput(listener2);
        view.close(listener2.getEntered());
        return listener2.getEntered();
    }

    @Override
    Boolean askYesNo(String prompt, boolean defaultValue) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        YesNoView view = new YesNoView(output, prompt, defaultValue);
        YesNoListener listener2 = new YesNoListener(defaultValue);
        view.render();
        this.handleInput(listener2);
        view.close(listener2.getSelected());
        return listener2.getSelected();
    }

    private void handleInput(AbstractListener listener2) {
        TerminalInput input = this.terminals.getTerminalInput();
        input.rawMode();
        try {
            while (!listener2.isFinished()) {
                input.read(listener2);
            }
        }
        finally {
            input.reset();
        }
    }
}

