/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftable.ReftableDatabase;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public abstract class ReftableBatchRefUpdate
extends BatchRefUpdate {
    private final Lock lock;
    private final ReftableDatabase refDb;
    private final Repository repository;

    protected ReftableBatchRefUpdate(RefDatabase refdb, ReftableDatabase reftableDb, Lock lock, Repository repository) {
        super(refdb);
        this.refDb = reftableDb;
        this.lock = lock;
        this.repository = repository;
    }

    @Override
    public void execute(RevWalk rw, ProgressMonitor pm, List<String> options) {
        List<ReceiveCommand> pending = this.getPending();
        if (pending.isEmpty()) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        try {
            if (!this.checkObjectExistence(rw, pending)) {
                return;
            }
            pending = this.getPending();
            if (!this.checkNonFastForwards(rw, pending)) {
                return;
            }
            pending = this.getPending();
            this.lock.lock();
            try {
                if (!this.checkExpected(pending)) {
                    return;
                }
                pending = this.getPending();
                if (!this.checkConflicting(pending)) {
                    return;
                }
                pending = this.getPending();
                if (!this.blockUntilTimestamps(MAX_WAIT)) {
                    return;
                }
                List<Ref> newRefs = ReftableBatchRefUpdate.toNewRefs(rw, pending);
                this.applyUpdates(newRefs, pending);
                for (ReceiveCommand cmd : pending) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.setResult(ReceiveCommand.Result.OK);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            pending.get(0).setResult(ReceiveCommand.Result.LOCK_FAILURE, "io error");
            ReceiveCommand.abort(pending);
        }
    }

    protected abstract void applyUpdates(List<Ref> var1, List<ReceiveCommand> var2) throws IOException;

    private List<ReceiveCommand> getPending() {
        return ReceiveCommand.filter(this.getCommands(), ReceiveCommand.Result.NOT_ATTEMPTED);
    }

    private boolean checkObjectExistence(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        for (ReceiveCommand cmd : pending) {
            try {
                if (cmd.getNewId().equals(ObjectId.zeroId())) continue;
                rw.parseAny(cmd.getNewId());
            }
            catch (MissingObjectException e) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
                if (!this.isAtomic()) continue;
                ReceiveCommand.abort(pending);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand cmd : pending) {
            cmd.updateType(rw);
            if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
            if (!this.isAtomic()) continue;
            ReceiveCommand.abort(pending);
            return false;
        }
        return true;
    }

    private boolean checkConflicting(List<ReceiveCommand> pending) throws IOException {
        TreeSet<String> added = new TreeSet<String>();
        Set<String> deleted2 = pending.stream().filter(cmd -> cmd.getType() == ReceiveCommand.Type.DELETE).map(c -> c.getRefName()).collect(Collectors.toSet());
        boolean ok = true;
        for (ReceiveCommand cmd2 : pending) {
            if (cmd2.getType() == ReceiveCommand.Type.DELETE) continue;
            String name = cmd2.getRefName();
            if (this.refDb.isNameConflicting(name, added, deleted2)) {
                if (this.isAtomic()) {
                    cmd2.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().transactionAborted);
                } else {
                    cmd2.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                }
                ok = false;
            }
            added.add(name);
        }
        if (this.isAtomic()) {
            if (!ok) {
                pending.stream().filter(cmd -> cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED).forEach(cmd -> cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE));
            }
            return ok;
        }
        for (ReceiveCommand cmd2 : pending) {
            if (cmd2.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            return true;
        }
        return false;
    }

    private boolean checkExpected(List<ReceiveCommand> pending) throws IOException {
        for (ReceiveCommand cmd : pending) {
            if (ReftableBatchRefUpdate.matchOld(cmd, this.refDb.exactRef(cmd.getRefName()))) continue;
            cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            if (!this.isAtomic()) continue;
            ReceiveCommand.abort(pending);
            return false;
        }
        return true;
    }

    private static boolean matchOld(ReceiveCommand cmd, @Nullable Ref ref) {
        if (ref == null) {
            return AnyObjectId.isEqual(ObjectId.zeroId(), cmd.getOldId()) && cmd.getOldSymref() == null;
        }
        if (ref.isSymbolic()) {
            return ref.getTarget().getName().equals(cmd.getOldSymref());
        }
        ObjectId id = ref.getObjectId();
        if (id == null) {
            id = ObjectId.zeroId();
        }
        return cmd.getOldId().equals(id);
    }

    protected void write(ReftableWriter writer, List<Ref> newRefs, List<ReceiveCommand> pending) throws IOException {
        long updateIndex = this.refDb.nextUpdateIndex();
        writer.setMinUpdateIndex(updateIndex).setMaxUpdateIndex(updateIndex).begin().sortAndWriteRefs(newRefs);
        if (!this.isRefLogDisabled()) {
            this.writeLog(writer, updateIndex, pending);
        }
    }

    private void writeLog(ReftableWriter writer, long updateIndex, List<ReceiveCommand> pending) throws IOException {
        HashMap<String, ReceiveCommand> cmds = new HashMap<String, ReceiveCommand>();
        ArrayList<String> byName = new ArrayList<String>(pending.size());
        for (ReceiveCommand cmd : pending) {
            cmds.put(cmd.getRefName(), cmd);
            byName.add(cmd.getRefName());
        }
        Collections.sort(byName);
        PersonIdent ident = this.getRefLogIdent();
        if (ident == null) {
            ident = new PersonIdent(this.repository);
        }
        for (String name : byName) {
            String strResult;
            ReceiveCommand cmd = (ReceiveCommand)cmds.get(name);
            if (this.isRefLogDisabled(cmd)) continue;
            String msg = this.getRefLogMessage(cmd);
            if (this.isRefLogIncludingResult(cmd) && (strResult = this.toResultString(cmd)) != null) {
                msg = msg.isEmpty() ? strResult : String.valueOf(msg) + ": " + strResult;
            }
            writer.writeLog(name, updateIndex, ident, cmd.getOldId(), cmd.getNewId(), msg);
        }
    }

    private String toResultString(ReceiveCommand cmd) {
        switch (cmd.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static List<Ref> toNewRefs(RevWalk rw, List<ReceiveCommand> pending) throws IOException {
        ArrayList<Ref> refs = new ArrayList<Ref>(pending.size());
        for (ReceiveCommand cmd : pending) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            String name = cmd.getRefName();
            ObjectId newId = cmd.getNewId();
            String newSymref = cmd.getNewSymref();
            if (AnyObjectId.isEqual(ObjectId.zeroId(), newId) && newSymref == null) {
                refs.add(new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null));
                continue;
            }
            if (newSymref != null) {
                refs.add(new SymbolicRef(name, new ObjectIdRef.Unpeeled(Ref.Storage.NEW, newSymref, null)));
                continue;
            }
            RevObject obj = rw.parseAny(newId);
            RevObject peel = null;
            if (obj instanceof RevTag) {
                peel = rw.peel(obj);
            }
            if (peel != null) {
                refs.add(new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, name, newId, peel.copy()));
                continue;
            }
            refs.add(new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, newId));
        }
        return refs;
    }
}

