/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTaskBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncHistoryAction;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import git4idea.GitVcs;
import git4idea.log.GitShowExternalLogActionKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/SettingsSyncHistoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.settingsSync"})
public final class SettingsSyncHistoryAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
        Project project2 = project;
        Path settingsSyncStorage = SettingsSyncMain.Companion.getInstance().getControls$intellij_settingsSync().getSettingsSyncStorage();
        VirtualFile virtualFile = VfsUtil.findFile((Path)settingsSyncStorage, (boolean)true);
        if (virtualFile == null) {
            Messages.showErrorDialog((String)SettingsSyncBundle.INSTANCE.message("history.error.message", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("history.dialog.title", new Object[0]));
            return;
        }
        String toolWindowId = "SettingsSync";
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow2 = toolWindowManager.getToolWindow(toolWindowId);
        if (toolWindow2 == null) {
            RegisterToolWindowTaskBuilder b$iv;
            ToolWindowManager this_$iv = toolWindowManager;
            boolean $i$f$registerToolWindow = false;
            RegisterToolWindowTaskBuilder $this$registerToolWindow = b$iv = new RegisterToolWindowTaskBuilder(toolWindowId);
            boolean bl = false;
            $this$registerToolWindow.stripeTitle = actionPerformed.toolWindow.1.1.INSTANCE;
            toolWindow2 = this_$iv.registerToolWindow(b$iv.build());
        }
        ToolWindow toolWindow3 = toolWindow2;
        GitVcs gitVcs = GitVcs.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitVcs, (String)"GitVcs.getInstance(project)");
        GitShowExternalLogActionKt.showExternalGitLogInToolwindow((Project)project2, (ToolWindow)toolWindow3, (GitVcs)gitVcs, (List)CollectionsKt.listOf((Object)virtualFile), (String)SettingsSyncBundle.INSTANCE.message("history.tab.name", new Object[0]), (String)"");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(e.getProject() != null && SettingsSyncMainKt.isSettingsSyncEnabledByKey());
    }
}

