/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.CommonPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

class GradlePathRelativizer
extends CommonPathRelativizer {
    private static final String IDENTIFIER = "$GRADLE_REPOSITORY$";
    private static final String GRADLE_USER_HOME = "GRADLE_USER_HOME";

    GradlePathRelativizer() {
        super(GradlePathRelativizer.initializeGradleRepositoryPath(), IDENTIFIER);
    }

    @Nullable
    private static String initializeGradleRepositoryPath() {
        String gradleUserHome;
        String gradleUserHomePath = System.getenv(GRADLE_USER_HOME);
        String string = gradleUserHome = gradleUserHomePath == null ? SystemProperties.getUserHome() + File.separator + ".gradle" : gradleUserHomePath;
        if (FileUtil.exists((String)gradleUserHome)) {
            return PathRelativizerService.normalizePath(gradleUserHome);
        }
        return null;
    }
}

