/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

final class ChunkBuildOutputConsumerImpl
implements ModuleLevelBuilder.OutputConsumer {
    private final CompileContext myContext;
    private final Map<BuildTarget<?>, BuildOutputConsumerImpl> myTarget2Consumer = new HashMap();
    private final Map<String, CompiledClass> myClasses = new HashMap<String, CompiledClass>();
    private final Map<BuildTarget<?>, Collection<CompiledClass>> myTargetToClassesMap = new HashMap();
    private final Object2ObjectMap<File, String> myOutputToBuilderNameMap = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.FILE_HASH_STRATEGY));
    private volatile String myCurrentBuilderName;

    ChunkBuildOutputConsumerImpl(CompileContext context) {
        this.myContext = context;
    }

    public void setCurrentBuilderName(String builderName) {
        this.myCurrentBuilderName = builderName;
    }

    @Override
    public Collection<CompiledClass> getTargetCompiledClasses(@NotNull BuildTarget<?> target) {
        Collection<CompiledClass> classes;
        if (target == null) {
            ChunkBuildOutputConsumerImpl.$$$reportNull$$$0(0);
        }
        if ((classes = this.myTargetToClassesMap.get(target)) != null) {
            return Collections.unmodifiableCollection(classes);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, CompiledClass> getCompiledClasses() {
        Map<String, CompiledClass> map = Collections.unmodifiableMap(this.myClasses);
        if (map == null) {
            ChunkBuildOutputConsumerImpl.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    @Nullable
    public BinaryContent lookupClassBytes(String className) {
        CompiledClass object = this.myClasses.get(className);
        return object != null ? object.getContent() : null;
    }

    @Override
    public void registerCompiledClass(@Nullable BuildTarget<?> target, CompiledClass compiled) throws IOException {
        if (compiled.getClassName() != null) {
            this.myClasses.put(compiled.getClassName(), compiled);
            if (target != null) {
                Collection<CompiledClass> classes = this.myTargetToClassesMap.get(target);
                if (classes == null) {
                    classes = new ArrayList<CompiledClass>();
                    this.myTargetToClassesMap.put(target, classes);
                }
                classes.add(compiled);
            }
        }
        if (target != null) {
            this.registerOutputFile(target, compiled.getOutputFile(), compiled.getSourceFilesPaths());
        }
    }

    @Override
    public void registerOutputFile(@NotNull BuildTarget<?> target, File outputFile, Collection<String> sourcePaths) throws IOException {
        BuildOutputConsumerImpl consumer;
        String previousBuilder;
        String currentBuilder;
        if (target == null) {
            ChunkBuildOutputConsumerImpl.$$$reportNull$$$0(2);
        }
        if ((currentBuilder = this.myCurrentBuilderName) != null && (previousBuilder = (String)this.myOutputToBuilderNameMap.put((Object)outputFile, (Object)currentBuilder)) != null && !previousBuilder.equals(currentBuilder)) {
            String source = sourcePaths.isEmpty() ? null : sourcePaths.iterator().next();
            this.myContext.processMessage(new CompilerMessage(currentBuilder, BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.conflicting.outputs.error", outputFile.getAbsolutePath(), previousBuilder), source));
        }
        if ((consumer = this.myTarget2Consumer.get(target)) == null) {
            consumer = new BuildOutputConsumerImpl(target, this.myContext);
            this.myTarget2Consumer.put(target, consumer);
        }
        consumer.registerOutputFile(outputFile, sourcePaths);
    }

    public void fireFileGeneratedEvents() {
        for (BuildOutputConsumerImpl consumer : this.myTarget2Consumer.values()) {
            consumer.fireFileGeneratedEvent();
        }
    }

    public int getNumberOfProcessedSources() {
        int total = 0;
        for (BuildOutputConsumerImpl consumer : this.myTarget2Consumer.values()) {
            total += consumer.getNumberOfProcessedSources();
        }
        return total;
    }

    public void clear() {
        this.myTarget2Consumer.clear();
        this.myClasses.clear();
        this.myTargetToClassesMap.clear();
        this.myOutputToBuilderNameMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/ChunkBuildOutputConsumerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/ChunkBuildOutputConsumerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCompiledClasses";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerOutputFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

