/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;

public final class ModulePackageRepr
extends Proto {
    private static final DataExternalizer<Integer> INT_EXTERNALIZER = new DataExternalizer<Integer>(){

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtil.readINT((DataInput)in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/ModulePackageRepr$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final Set<Integer> myModuleNames = new HashSet<Integer>();

    ModulePackageRepr(DependencyContext context, int name, Collection<String> modules) {
        super(0, context.get(null), name, Collections.emptySet());
        for (String module : modules) {
            this.myModuleNames.add(context.get(module));
        }
    }

    private ModulePackageRepr(DependencyContext context, DataInput in) {
        super(context, in);
        RW.read(INT_EXTERNALIZER, this.myModuleNames, in);
    }

    public Set<Integer> getModuleNames() {
        return Collections.unmodifiableSet(this.myModuleNames);
    }

    public boolean isQualified() {
        return !this.myModuleNames.isEmpty();
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        RW.save(this.myModuleNames, INT_EXTERNALIZER, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name == ((ModulePackageRepr)o).name;
    }

    public int hashCode() {
        return 31 * this.name;
    }

    @Override
    public Diff difference(Proto past) {
        final Difference.Specifier targetModulesDiff = Difference.make(((ModulePackageRepr)past).myModuleNames, this.myModuleNames);
        return new Diff(super.difference(past)){

            @Override
            public Difference.Specifier<Integer, Difference> targetModules() {
                return targetModulesDiff;
            }

            @Override
            public boolean no() {
                return super.no() && this.targetModules().unchanged();
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        StringBuilder sb = new StringBuilder();
        sb.append("Module package: ").append(context.getValue(this.name));
        Set<Integer> moduleNames = this.myModuleNames;
        if (!moduleNames.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (Integer moduleName : moduleNames) {
                names.add(context.getValue(moduleName));
            }
            names.sort(String::compareToIgnoreCase);
            sb.append(" to");
            for (String s : names) {
                sb.append(" ").append(s);
            }
        }
        stream.println(sb);
    }

    public static DataExternalizer<ModulePackageRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ModulePackageRepr>(){

            public void save(@NotNull DataOutput out, ModulePackageRepr value) {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                value.save(out);
            }

            public ModulePackageRepr read(@NotNull DataInput in) {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new ModulePackageRepr(context, in);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/ModulePackageRepr$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static abstract class Diff
    extends DifferenceImpl {
        public abstract Difference.Specifier<Integer, Difference> targetModules();

        Diff(@NotNull Difference delegate) {
            if (delegate == null) {
                Diff.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jps/builders/java/dependencyView/ModulePackageRepr$Diff", "<init>"));
        }
    }
}

