/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.vfilefinder.FileIndexesKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016J0\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u00172\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001aH\u0004R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinFileIndexBase;", "T", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "classOfIndex", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "KEY", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "getKEY", "()Lcom/intellij/util/indexing/ID;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "dependsOnFileContent", "", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getName", "indexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "f", "Lkotlin/Function1;", "kotlin.core"})
public abstract class KotlinFileIndexBase<T>
extends ScalarIndexExtension<FqName> {
    @NotNull
    private final ID<FqName, Void> KEY;
    @NotNull
    private final Logger LOG;

    @NotNull
    public final ID<FqName, Void> getKEY() {
        return this.KEY;
    }

    @NotNull
    protected final Logger getLOG() {
        return this.LOG;
    }

    @NotNull
    public ID<FqName, Void> getName() {
        return this.KEY;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public KeyDescriptor<FqName> getKeyDescriptor() {
        return FileIndexesKt.access$getFQNAME_KEY_DESCRIPTOR$p();
    }

    @NotNull
    protected final DataIndexer<FqName, Void, FileContent> indexer(@NotNull Function1<? super FileContent, FqName> f2) {
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        return new DataIndexer(this, f2){
            final /* synthetic */ KotlinFileIndexBase this$0;
            final /* synthetic */ Function1 $f;

            @NotNull
            public final Map<FqName, Void> map(@NotNull FileContent it) {
                Map map2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    FqName fqName2 = (FqName)this.$f.invoke((Object)it);
                    map2 = fqName2 != null ? Collections.singletonMap(fqName2, null) : MapsKt.emptyMap();
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    this.this$0.getLOG().warn("Error while indexing file " + it.getFileName() + ": " + e.getMessage());
                    map2 = MapsKt.emptyMap();
                }
                return map2;
            }
            {
                this.this$0 = kotlinFileIndexBase;
                this.$f = function1;
            }
        };
    }

    public KotlinFileIndexBase(@NotNull Class<T> classOfIndex) {
        Intrinsics.checkNotNullParameter(classOfIndex, (String)"classOfIndex");
        ID iD = ID.create((String)classOfIndex.getCanonicalName());
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"ID.create(classOfIndex.canonicalName)");
        this.KEY = iD;
        Logger logger = Logger.getInstance(classOfIndex);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(classOfIndex)");
        this.LOG = logger;
    }
}

