/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "kotlin.base.fe10.analysis"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $this$fuzzyReturnType) {
        FuzzyType fuzzyType;
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyReturnType, (String)"$this$fuzzyReturnType");
        KotlinType kotlinType = $this$fuzzyReturnType.getReturnType();
        if (kotlinType != null) {
            List list2 = $this$fuzzyReturnType.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType, list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $this$fuzzyExtensionReceiverType) {
        FuzzyType fuzzyType;
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyExtensionReceiverType, (String)"$this$fuzzyExtensionReceiverType");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$fuzzyExtensionReceiverType.getExtensionReceiverParameter();
        if (receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null) {
            List list2 = $this$fuzzyExtensionReceiverType.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType((KotlinType)receiverParameterDescriptor, list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $this$makeNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNotNullable, (String)"$this$makeNotNullable");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable((KotlinType)$this$makeNotNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNotNullable.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $this$makeNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNullable, (String)"$this$makeNullable");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable((KotlinType)$this$makeNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNullable.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $this$nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$nullability, (String)"$this$nullability");
        return TypeUtilsKt.nullability((KotlinType)$this$nullability.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $this$isAlmostEverything) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlmostEverything, (String)"$this$isAlmostEverything");
        if ($this$isAlmostEverything.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $this$isAlmostEverything.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if (!$this$isAlmostEverything.getFreeParameters().contains(typeParameter)) {
            return false;
        }
        List list2 = typeParameter.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"typeParameter.upperBounds");
        KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull((List)list2);
        return kotlinType != null ? TypeUtilsKt.isAnyOrNullableAny((KotlinType)kotlinType) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $this$presentationType) {
        Intrinsics.checkNotNullParameter((Object)$this$presentationType, (String)"$this$presentationType");
        if ($this$presentationType.getFreeParameters().isEmpty()) {
            return $this$presentationType.getType();
        }
        HashMap map2 = new HashMap();
        Iterable iterable = $this$presentationType.getType().getArguments();
        List list2 = $this$presentationType.getType().getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"type.constructor.parameters");
        for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            TypeParameterDescriptor equalToFreeParameter;
            Object v3;
            TypeParameterDescriptor typeParameter;
            block4: {
                void argument2;
                TypeProjection typeProjection = (TypeProjection)pair.component1();
                typeParameter = (TypeParameterDescriptor)pair.component2();
                if (argument2.getProjectionKind() != Variance.INVARIANT) continue;
                Iterable $this$firstOrNull$iv = $this$presentationType.getFreeParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl = false;
                    SimpleType simpleType = it.getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"it.defaultType");
                    if (!StrictEqualityTypeChecker.INSTANCE.strictEqualTypes((UnwrappedType)simpleType, argument2.getType().unwrap())) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((TypeParameterDescriptor)v3 == null) {
                continue;
            }
            Map map3 = map2;
            TypeConstructor typeConstructor = equalToFreeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"equalToFreeParameter.typeConstructor");
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
            SimpleType simpleType = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"typeParameter.defaultType");
            map3.put(typeConstructor, TypeUtilsKt.createProjection((KotlinType)((KotlinType)simpleType), (Variance)Variance.INVARIANT, null));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create((Map)map2);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(map)");
        TypeSubstitutor substitutor3 = typeSubstitutor2;
        KotlinType kotlinType = substitutor3.substitute($this$presentationType.getType(), Variance.INVARIANT);
        Intrinsics.checkNotNull((Object)kotlinType);
        return kotlinType;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $this$toFuzzyType, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$toFuzzyType, (String)"$this$toFuzzyType");
        Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
        return new FuzzyType($this$toFuzzyType, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $this$hasConflictWith, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasConflictWith, (String)"$this$hasConflictWith");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
            Iterable $this$any$iv = freeParameters;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection substituted2;
                    TypeProjection substituted1;
                    SimpleType type2;
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)parameter.getDefaultType(), (String)"parameter.defaultType");
                    boolean bl3 = $this$hasConflictWith.get((KotlinType)type2) == null ? false : (other.get((KotlinType)type2) == null ? false : !StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(substituted1.getType().unwrap(), substituted2.getType().unwrap()) || substituted1.getProjectionKind() != substituted2.getProjectionKind());
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $this$combineIfNoConflicts, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$combineIfNoConflicts, (String)"$this$combineIfNoConflicts");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
        TypeSubstitution typeSubstitution = $this$combineIfNoConflicts.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"this.substitution");
        TypeSubstitution typeSubstitution2 = other.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution2, (String)"other.substitution");
        if (FuzzyTypeUtils.hasConflictWith(typeSubstitution, typeSubstitution2, freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor((TypeSubstitution)$this$combineIfNoConflicts.getSubstitution(), (TypeSubstitution)other.getSubstitution());
    }
}

