/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pullUp;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.memberPullUp.PullUpData;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.memberPullUp.PullUpHelperFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.MemberInfoUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.EmptyPullUpHelper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.JavaToKotlinPostconversionPullUpHelper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpData;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpHelper;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pullUp/KotlinPullUpHelperFactory;", "Lcom/intellij/refactoring/memberPullUp/PullUpHelperFactory;", "()V", "createPullUpHelper", "Lcom/intellij/refactoring/memberPullUp/PullUpHelper;", "data", "Lcom/intellij/refactoring/memberPullUp/PullUpData;", "toKotlinPullUpData", "Lorg/jetbrains/kotlin/idea/refactoring/pullUp/KotlinPullUpData;", "kotlin.idea"})
public final class KotlinPullUpHelperFactory
implements PullUpHelperFactory {
    /*
     * WARNING - void declaration
     */
    private final KotlinPullUpData toKotlinPullUpData(PullUpData $this$toKotlinPullUpData) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        PsiClass psiClass2 = $this$toKotlinPullUpData.getSourceClass();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"sourceClass");
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)psiClass2));
        if (!(psiElement2 instanceof KtClassOrObject)) {
            psiElement2 = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement2;
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject sourceClass = ktClassOrObject;
        PsiClass psiClass3 = $this$toKotlinPullUpData.getTargetClass();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"targetClass");
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)psiClass3));
        if (!(psiElement3 instanceof PsiNamedElement)) {
            psiElement3 = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement3;
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement targetClass = psiNamedElement;
        Set set2 = $this$toKotlinPullUpData.getMembersToMove();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"membersToMove");
        Iterable iterable = set2;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KtNamedDeclaration ktNamedDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiMember it = (PsiMember)element$iv$iv;
            boolean bl2 = false;
            PsiMember psiMember = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiMember, (String)"it");
            if (MemberInfoUtilsKt.toKtDeclarationWrapperAware(psiMember) == null) continue;
            KtNamedDeclaration it$iv$iv = ktNamedDeclaration;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List membersToMove = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KtNamedDeclaration it = (KtNamedDeclaration)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
                it = (KtNamedDeclaration)b;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        return new KotlinPullUpData(sourceClass, targetClass, membersToMove);
    }

    @NotNull
    public PullUpHelper<?> createPullUpHelper(@NotNull PullUpData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!data.getSourceClass().isInheritor(data.getTargetClass(), true)) {
            return EmptyPullUpHelper.INSTANCE;
        }
        KotlinPullUpData kotlinPullUpData = this.toKotlinPullUpData(data);
        if (kotlinPullUpData != null) {
            KotlinPullUpData kotlinPullUpData2;
            KotlinPullUpData it = kotlinPullUpData2 = kotlinPullUpData;
            boolean bl = false;
            return new KotlinPullUpHelper(data, it);
        }
        PsiClass psiClass2 = data.getTargetClass();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"data.targetClass");
        if (Intrinsics.areEqual((Object)psiClass2.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
            PsiClass psiClass3 = data.getSourceClass();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"data.sourceClass");
            if (Intrinsics.areEqual((Object)psiClass3.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
                return new JavaToKotlinPostconversionPullUpHelper(data);
            }
        }
        return EmptyPullUpHelper.INSTANCE;
    }
}

