/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.macros;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryRoot;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.macros.KotlinBundledUsageDetector;
import org.jetbrains.kotlin.idea.macros.KotlinBundledUsageDetectorKt;
import org.jetbrains.kotlin.idea.macros.KotlinBundledUsageDetectorListener;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledUsageDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isKotlinBundledFound", "Ljava/util/concurrent/atomic/AtomicBoolean;", "detected", "", "Companion", "ModelChangeListener", "MyStartupActivity", "kotlin.idea"})
public final class KotlinBundledUsageDetector {
    private final AtomicBoolean isKotlinBundledFound;
    private final Project project;
    @JvmField
    @NotNull
    public static final Topic<KotlinBundledUsageDetectorListener> TOPIC;
    @NotNull
    public static final Companion Companion;

    private final void detected() {
        if (this.isKotlinBundledFound.compareAndSet(false, true)) {
            ((KotlinBundledUsageDetectorListener)this.project.getMessageBus().syncPublisher(TOPIC)).kotlinBundledDetected();
        }
    }

    public KotlinBundledUsageDetector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.isKotlinBundledFound = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        TOPIC = new Topic(KotlinBundledUsageDetectorListener.class, Topic.BroadcastDirection.NONE);
    }

    @JvmStatic
    public static final boolean isKotlinBundledPotentiallyUsedInLibraries(@NotNull Project project2) {
        return Companion.isKotlinBundledPotentiallyUsedInLibraries(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledUsageDetector$ModelChangeListener;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changed", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "kotlin.idea"})
    public static final class ModelChangeListener
    implements WorkspaceModelChangeListener {
        private final Project project;

        /*
         * WARNING - void declaration
         */
        public void changed(@NotNull VersionedStorageChange event) {
            boolean isDistUsedInLibraries2;
            KotlinBundledUsageDetector detectorService;
            block4: {
                boolean bl;
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                detectorService = KotlinBundledUsageDetectorKt.access$getDetectorInstance$p(this.project);
                if (detectorService.isKotlinBundledFound.get()) {
                    return;
                }
                Collection collection = event.getChanges(LibraryEntity.class);
                if (collection.isEmpty()) {
                    boolean bl2 = false;
                    return;
                }
                List changes = (List)collection;
                Sequence bl2 = SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)changes), (Function1)changed.isDistUsedInLibraries.1.INSTANCE), (Function1)changed.isDistUsedInLibraries.2.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    LibraryRoot it = (LibraryRoot)element$iv;
                    boolean bl3 = false;
                    String string = it.getUrl().getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url.url");
                    if (!KotlinBundledUsageDetectorKt.access$isStartsWithDistPrefix$p(string)) continue;
                    bl = true;
                    break block4;
                }
                bl = isDistUsedInLibraries2 = false;
            }
            if (isDistUsedInLibraries2) {
                detectorService.detected();
            }
        }

        public ModelChangeListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledUsageDetector$MyStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
    public static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        /*
         * WARNING - void declaration
         */
        public void runActivity(@NotNull Project project2) {
            void isUsed;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            KotlinRuntimeLibraryUtilKt.forEachAllUsedLibraries(project2, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>((Ref.BooleanRef)isUsed){
                final /* synthetic */ Ref.BooleanRef $isUsed;

                public final boolean invoke(@NotNull Library library2) {
                    boolean bl;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                        String[] stringArray = library2.getUrls(OrderRootType.CLASSES);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"library.getUrls(OrderRootType.CLASSES)");
                        String[] $this$any$iv = stringArray;
                        boolean $i$f$any = false;
                        int n = $this$any$iv.length;
                        for (int i = 0; i < n; ++i) {
                            String element$iv;
                            String receiver2 = element$iv = $this$any$iv[i];
                            boolean bl2 = false;
                            if (!KotlinBundledUsageDetectorKt.access$isStartsWithDistPrefix$p(receiver2)) continue;
                            bl = true;
                            break block2;
                        }
                        bl = false;
                    }
                    if (bl) {
                        this.$isUsed.element = true;
                        return false;
                    }
                    return true;
                }
                {
                    this.$isUsed = booleanRef;
                    super(1);
                }
            }));
            if (isUsed.element) {
                KotlinBundledUsageDetectorKt.access$getDetectorInstance$p(project2).detected();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/macros/KotlinBundledUsageDetector$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/kotlin/idea/macros/KotlinBundledUsageDetectorListener;", "kotlin.jvm.PlatformType", "isKotlinBundledPotentiallyUsedInLibraries", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
    public static final class Companion {
        @JvmStatic
        public final boolean isKotlinBundledPotentiallyUsedInLibraries(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return KotlinBundledUsageDetectorKt.access$getDetectorInstance$p(project2).isKotlinBundledFound.get();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

