/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\u001aH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider;", "", "()V", "findUrlsForClass", "", "", "aClass", "Lcom/intellij/psi/PsiClass;", "pkgFqName", "classFqName", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtClass;", "findUrlsForContainingClassOf", "ktElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findUrlsForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findUrlsForLightElement", "classUrls", "lightElement", "Lcom/intellij/psi/PsiElement;", "findUrlsForLightProperty", "lightProperty", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "getContainingLightClassForKtDeclaration", "declaration", "getExternalJavaDocUrl", "element", "getLightElementSignatures", "kotlin.idea"})
public final class KotlinExternalDocUrlsProvider {
    @NotNull
    public static final KotlinExternalDocUrlsProvider INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getExternalJavaDocUrl(@Nullable PsiElement element3) {
        List list2;
        List<String> urls;
        PsiElement psiElement2 = element3;
        List<String> list3 = urls = psiElement2 instanceof KtEnumEntry ? this.findUrlsForEnumEntry((KtEnumEntry)element3) : (psiElement2 instanceof KtClass ? this.findUrlsForClass((KtClass)element3) : (psiElement2 instanceof KtFunction ? this.findUrlsForLightElement((KtDeclaration)element3, (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element3)) : (psiElement2 instanceof KtProperty ? this.findUrlsForLightProperty((KtDeclaration)element3, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element3)) : (psiElement2 instanceof KtParameter ? this.findUrlsForLightProperty((KtDeclaration)element3, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)element3)) : (psiElement2 instanceof KtLightClass ? this.findUrlsForClass((PsiClass)element3) : (psiElement2 instanceof KtLightMember ? this.findUrlsForLightElement(this.findUrlsForClass((PsiClass)((KtLightMember)element3).getContainingClass()), element3) : null))))));
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = FileUtil.toSystemIndependentName((String)it);
                collection.add(string2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final List<String> findUrlsForClass(KtClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getFqName()) == null || (object = object.asString()) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"aClass?.fqName?.asString() ?: return emptyList()");
        Object classFqName = object;
        KtFile ktFile = aClass.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"aClass.containingKtFile");
        return this.findUrlsForClass((String)classFqName, ktFile);
    }

    private final List<String> findUrlsForClass(PsiClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"aClass?.qualifiedName ?: return emptyList()");
        Object classFqName = object;
        String string = PsiUtil.getPackageName((PsiClass)aClass);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PsiUtil.getPackageName(a\u2026ss) ?: return emptyList()");
        String pkgFqName = string;
        PsiFile psiFile2 = aClass.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getOriginalFile()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile2 = psiFile2;
        Project project2 = aClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"aClass.project");
        return this.findUrlsForClass(pkgFqName, (String)classFqName, project2, (VirtualFile)virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForEnumEntry(KtEnumEntry enumEntry) {
        void $this$mapNotNullTo$iv$iv;
        Object object = enumEntry;
        if (object == null || (object = object.getParent()) == null || (object = UastContextKt.toUElement((PsiElement)object)) == null || (object = (UClass)UastUtils.getParentOfType$default((UElement)object, UClass.class, (boolean)false, (int)2, null)) == null || (object = object.getJavaPsi()) == null || (object = object.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enumEntry\n            ?.\u2026    ?: return emptyList()");
        Object classFqName = object;
        KtFile ktFile = enumEntry.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"enumEntry.containingKtFile");
        Iterable $this$mapNotNull$iv = this.findUrlsForClass((String)classFqName, ktFile);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String classUrl = (String)element$iv$iv;
            boolean bl2 = false;
            if (enumEntry.getName() != null) {
                String string3;
                String it = string3;
                boolean bl3 = false;
                string2 = classUrl + "#" + it;
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> findUrlsForContainingClassOf(KtDeclaration ktElement) {
        PsiClass psiClass2 = this.getContainingLightClassForKtDeclaration(ktElement);
        if (psiClass2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass containingClass2 = psiClass2;
        String string = containingClass2.getQualifiedName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingClass.qualifie\u2026ame ?: return emptyList()");
        String classFqName = string;
        KtFile ktFile = ktElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktElement.containingKtFile");
        return this.findUrlsForClass(classFqName, ktFile);
    }

    private final List<String> findUrlsForClass(String classFqName, KtFile containingKtFile) {
        PsiFile psiFile2 = containingKtFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"containingKtFile.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        String string = containingKtFile.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingKtFile.packageFqName.asString()");
        String pkgName = string;
        Project project2 = containingKtFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"containingKtFile.project");
        return this.findUrlsForClass(pkgName, classFqName, project2, virtualFile3);
    }

    private final List<String> findUrlsForClass(String pkgFqName, String classFqName, Project project2, VirtualFile virtualFile2) {
        List urls;
        List list2;
        String relPath;
        String string;
        CharSequence charSequence = pkgFqName;
        if (charSequence.length() == 0) {
            string = "[root]/" + classFqName;
        } else {
            String string2 = StringsKt.replace$default((String)pkgFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
            charSequence = classFqName;
            int n = pkgFqName.length() + 1;
            String string3 = ((String)charSequence).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            string = relPath = string2 + "/" + string3;
        }
        if ((list2 = (urls = JavaDocumentationProvider.findUrlForVirtualFile((Project)project2, (VirtualFile)virtualFile2, (String)(relPath + ".html")))) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<String> findUrlsForLightProperty(KtDeclaration ktElement, LightClassUtil.PropertyAccessorsPsiMethods lightProperty) {
        List<String> classUrls = this.findUrlsForContainingClassOf(ktElement);
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])new List[]{this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getBackingField()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getSetter()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getGetter())}));
    }

    private final List<String> findUrlsForLightElement(KtDeclaration ktElement, PsiElement lightElement) {
        return this.findUrlsForLightElement(this.findUrlsForContainingClassOf(ktElement), lightElement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForLightElement(List<String> classUrls, PsiElement lightElement) {
        void $this$flatMapTo$iv$iv;
        if (lightElement == null) {
            return CollectionsKt.emptyList();
        }
        List<String> elementSignatures = this.getLightElementSignatures(lightElement);
        Iterable $this$flatMap$iv = classUrls;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String classUrl = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = elementSignatures;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void signature;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string2 = classUrl + "#" + (String)signature;
                collection.add(string2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getLightElementSignatures(PsiElement element3) {
        PsiElement psiElement2 = element3;
        return psiElement2 instanceof PsiField ? CollectionsKt.listOf((Object)((PsiField)element3).getName()) : (psiElement2 instanceof PsiMethod ? CollectionsKt.listOf((Object[])new String[]{((PsiMethod)element3).getName() + "(", ((PsiMethod)element3).getName() + "-"}) : CollectionsKt.emptyList());
    }

    private final PsiClass getContainingLightClassForKtDeclaration(KtDeclaration declaration2) {
        PsiClass psiClass2;
        if (declaration2 instanceof KtFunction && ((KtFunction)declaration2).isLocal()) {
            psiClass2 = null;
        } else {
            PsiElement $this$toUElementOfType$iv = (PsiElement)declaration2;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod != null && (uMethod = uMethod.getUastParent()) != null && (uMethod = uMethod.getJavaPsi()) != null) {
                UMethod $this$castSafelyTo$iv = uMethod;
                boolean $i$f$castSafelyTo = false;
                UMethod uMethod2 = $this$castSafelyTo$iv;
                if (!(uMethod2 instanceof PsiClass)) {
                    uMethod2 = null;
                }
                psiClass2 = (PsiClass)uMethod2;
            } else {
                psiClass2 = null;
            }
        }
        return psiClass2;
    }

    private KotlinExternalDocUrlsProvider() {
    }

    static {
        KotlinExternalDocUrlsProvider kotlinExternalDocUrlsProvider;
        INSTANCE = kotlinExternalDocUrlsProvider = new KotlinExternalDocUrlsProvider();
    }
}

