/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.ChangeContextFix;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineBlockingCallInspectionUtils;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.FlowOnIoContextFix;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.WrapInWithContextFix;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "()V", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getQuickFixesFor", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "elementContext", "Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;", "(Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodNonBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "kotlin.idea"})
public final class CoroutineBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings2 = this.getLanguageVersionSettings((PsiElement)file2);
        return languageVersionSettings2.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMethodNonBlocking(@NotNull MethodContext context2) {
        UElement uMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        UElement uElement = uMethod = UastContextKt.toUElement((PsiElement)((PsiElement)context2.getElement()));
        UElement uElement2 = uElement;
        if (uElement == null) return false;
        PsiElement psiElement2 = uElement2.getSourcePsi();
        uElement2 = psiElement2;
        if (psiElement2 == null) return false;
        UElement sourcePsi = uElement2;
        if (!(sourcePsi instanceof KtNamedFunction)) return false;
        KtModifierList ktModifierList = ((KtNamedFunction)sourcePsi).getModifierList();
        if (ktModifierList == null) return false;
        if (!PsiUtilsKt.hasSuspendModifier((KtModifierList)ktModifierList)) return false;
        return true;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesFor(@NotNull ElementContext elementContext) {
        LocalQuickFix[] localQuickFixArray;
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        PsiElement element3 = elementContext.getElement();
        if (!(element3 instanceof KtCallExpression)) {
            return new LocalQuickFix[0];
        }
        PsiElement $this$parentOfType$iv = element3;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtCallExpression.class, (boolean)true);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ktCallExpression != null ? ResolutionUtils.resolveToCall((KtElement)ktCallExpression, BodyResolveMode.PARTIAL) : null;
        PsiFile psiFile2 = ((KtCallExpression)element3).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
        if (!this.isApplicable(psiFile2) || !CoroutineBlockingCallInspectionUtils.INSTANCE.isKotlinxOnClasspath((KtElement)element3)) {
            localQuickFixArray = new LocalQuickFix[]{};
        } else if (resolvedCall2 != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isCalledInsideNonIoContext(resolvedCall2) && CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction((KtElement)element3)) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = new ChangeContextFix();
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = new WrapInWithContextFix();
        } else if (resolvedCall2 != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isInsideFlowChain(resolvedCall2)) {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
            localQuickFixArray3[0] = new FlowOnIoContextFix();
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[1] = new WrapInWithContextFix();
        } else if (CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction((KtElement)element3)) {
            LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray4;
            localQuickFixArray4[0] = new WrapInWithContextFix();
        } else {
            localQuickFixArray = new LocalQuickFix[]{};
        }
        return localQuickFixArray;
    }

    private final LanguageVersionSettings getLanguageVersionSettings(PsiElement psiElement2) {
        Module module2 = ProjectStructureUtilKt.getModule(psiElement2);
        if (module2 == null || (module2 = PlatformKt.getLanguageVersionSettings(module2)) == null) {
            Project project2 = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
            module2 = PlatformKt.getLanguageVersionSettings$default(project2, null, null, null, 7, null);
        }
        return module2;
    }
}

