/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.LiftReturnOrAssignmentInspection;
import org.jetbrains.kotlin.idea.inspections.LiftReturnOrAssignmentInspection$WhenMappings;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "skipLongExpressions", "", "(Z)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "LiftAssignmentOutFix", "LiftReturnOutFix", "kotlin.idea"})
public final class LiftReturnOrAssignmentInspection
extends AbstractKotlinInspection {
    private final boolean skipLongExpressions;
    private static final int LINES_LIMIT = 15;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ LiftReturnOrAssignmentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                List<Companion.LiftState> list2 = LiftReturnOrAssignmentInspection.Companion.getState(expression2, LiftReturnOrAssignmentInspection.access$getSkipLongExpressions$p(this.this$0));
                if (list2 == null) {
                    return;
                }
                List<Companion.LiftState> states = list2;
                if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)expression2, (BindingContext)ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA))) {
                    return;
                }
                Iterable $this$forEach$iv = states;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LocalQuickFix localQuickFix;
                    Companion.LiftState state = (Companion.LiftState)element$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = state.getKeyword();
                    boolean bl2 = state.isSerious();
                    switch (LiftReturnOrAssignmentInspection$WhenMappings.$EnumSwitchMapping$0[state.getLiftType().ordinal()]) {
                        case 1: {
                            String string = state.getKeyword().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"state.keyword.text");
                            localQuickFix = new LiftReturnOutFix(string);
                            break;
                        }
                        case 2: {
                            String string = state.getKeyword().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"state.keyword.text");
                            localQuickFix = new LiftAssignmentOutFix(string);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    this.registerProblem(expression2, psiElement2, bl2, localQuickFix, state.getHighlightElement(), state.getHighlightType());
                }
            }

            private final void registerProblem(KtExpression expression2, PsiElement keyword, boolean isSerious, LocalQuickFix fix3, PsiElement highlightElement, ProblemHighlightType highlightType) {
                String subject = fix3 instanceof LiftReturnOutFix ? KotlinBundle.message("text.Return", new Object[0]) : KotlinBundle.message("text.Assignment", new Object[0]);
                PsiElement psiElement2 = (PsiElement)expression2;
                Object[] objectArray = new Object[2];
                objectArray[0] = subject;
                String string = keyword.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keyword.text");
                objectArray[1] = string;
                TextRange textRange = highlightElement.getTextRange();
                this.this$0.registerProblemWithoutOfflineInformation(this.$holder, psiElement2, KotlinBundle.message("0.1.be.lifted.out.of.2", objectArray), this.$isOnTheFly, highlightType, textRange != null ? textRange.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expression2))) : null, fix3);
            }

            static /* synthetic */ void registerProblem$default(buildVisitor.1 var0, KtExpression ktExpression, PsiElement psiElement2, boolean bl, LocalQuickFix localQuickFix, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    psiElement3 = psiElement2;
                }
                if ((n & 0x20) != 0) {
                    problemHighlightType2 = bl ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                }
                var0.registerProblem(ktExpression, psiElement2, bl, localQuickFix, psiElement3, problemHighlightType2);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }
        };
    }

    @JvmOverloads
    public LiftReturnOrAssignmentInspection(boolean skipLongExpressions) {
        this.skipLongExpressions = skipLongExpressions;
    }

    public /* synthetic */ LiftReturnOrAssignmentInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @JvmOverloads
    public LiftReturnOrAssignmentInspection() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getSkipLongExpressions$p(LiftReturnOrAssignmentInspection $this) {
        return $this.skipLongExpressions;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftReturnOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class LiftReturnOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return KotlinBundle.message("lift.return.out.fix.text.0", this.keyword);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                KtExpression replaced2 = BranchedFoldingUtils.INSTANCE.foldToReturn((KtExpression)psiElement2);
                Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)replaced2);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block1;
                editor2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)replaced2)));
            }
        }

        public LiftReturnOutFix(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftAssignmentOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class LiftAssignmentOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return KotlinBundle.message("lift.assignment.out.fix.text.0", this.keyword);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            BranchedFoldingUtils.INSTANCE.tryFoldToAssignment((KtExpression)psiElement2);
        }

        public LiftAssignmentOutFix(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion;", "", "()V", "LINES_LIMIT", "", "getState", "", "Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftState;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "skipLongExpressions", "", "getStateForWhenOrTry", "keyword", "Lcom/intellij/psi/PsiElement;", "LiftState", "LiftType", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final List<LiftState> getState(@NotNull KtExpression expression2, boolean skipLongExpressions) {
            List<LiftState> list2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtWhenExpression) {
                PsiElement psiElement2 = ((KtWhenExpression)expression2).getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"expression.whenKeyword");
                list2 = this.getStateForWhenOrTry(expression2, psiElement2, skipLongExpressions);
            } else if (ktExpression instanceof KtIfExpression) {
                PsiElement psiElement3 = ((KtIfExpression)expression2).getIfKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"expression.ifKeyword");
                list2 = this.getStateForWhenOrTry(expression2, psiElement3, skipLongExpressions);
            } else if (ktExpression instanceof KtTryExpression) {
                PsiElement psiElement4 = ((KtTryExpression)expression2).getTryKeyword();
                if (psiElement4 != null) {
                    PsiElement psiElement5;
                    PsiElement it = psiElement5 = psiElement4;
                    boolean bl = false;
                    PsiElement psiElement6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"it");
                    list2 = Companion.getStateForWhenOrTry(expression2, psiElement6, skipLongExpressions);
                } else {
                    list2 = null;
                }
            } else {
                list2 = null;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LiftState> getStateForWhenOrTry(KtExpression expression2, PsiElement keyword, boolean skipLongExpressions) {
            int assignmentNumber;
            List<KtReturnExpression> foldableReturns;
            if (skipLongExpressions && PsiLinesUtilsKt.getLineCount((PsiElement)expression2) > 15) {
                return null;
            }
            if (IfThenUtilsKt.isElseIf(expression2)) {
                return null;
            }
            List<KtReturnExpression> list2 = foldableReturns = BranchedFoldingUtils.INSTANCE.getFoldableReturns$kotlin_idea(expression2);
            if (list2 != null) {
                Collection collection = list2;
                if (!collection.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    void $this$anyDescendantOfType$iv;
                    PsiElement psiElement2 = (PsiElement)expression2;
                    Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(foldableReturns){
                        final /* synthetic */ List $foldableReturns;

                        public final boolean invoke(@NotNull KtReturnExpression it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !this.$foldableReturns.contains(it);
                        }
                        {
                            this.$foldableReturns = list2;
                            super(1);
                        }
                    };
                    boolean $i$f$anyDescendantOfType = false;
                    Iterable $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                    boolean $i$f$findDescendantOfType = false;
                    void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                    boolean $i$f$findDescendantOfType2 = false;
                    Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(@NotNull PsiElement element3) {
                            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                            if (element3 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                this.$result.element = element3;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element3;
                            boolean bl = false;
                            super.visitElement(element3);
                        }
                    });
                    boolean hasOtherReturns2 = (PsiElement)result$iv$iv$iv.element != null;
                    boolean isSerious = !hasOtherReturns2 && foldableReturns.size() > 1;
                    Iterable $this$map$iv = foldableReturns;
                    boolean $i$f$map = false;
                    $this$findDescendantOfType$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtReturnExpression ktReturnExpression = (KtReturnExpression)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        LiftState liftState = new LiftState(keyword, isSerious, LiftType.LIFT_RETURN_OUT, (PsiElement)it, ProblemHighlightType.INFORMATION);
                        collection2.add(liftState);
                    }
                    return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new LiftState(keyword, isSerious, LiftType.LIFT_RETURN_OUT, null, null, 24, null));
                }
            }
            if ((assignmentNumber = BranchedFoldingUtils.INSTANCE.getFoldableAssignmentNumber$kotlin_idea(expression2)) > 0) {
                boolean isSerious = assignmentNumber > 1;
                return CollectionsKt.listOf((Object)new LiftState(keyword, isSerious, LiftType.LIFT_ASSIGNMENT_OUT, null, null, 24, null));
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftType;", "", "(Ljava/lang/String;I)V", "LIFT_RETURN_OUT", "LIFT_ASSIGNMENT_OUT", "kotlin.idea"})
        public static final class LiftType
        extends Enum<LiftType> {
            public static final /* enum */ LiftType LIFT_RETURN_OUT;
            public static final /* enum */ LiftType LIFT_ASSIGNMENT_OUT;
            private static final /* synthetic */ LiftType[] $VALUES;

            static {
                LiftType[] liftTypeArray = new LiftType[2];
                LiftType[] liftTypeArray2 = liftTypeArray;
                liftTypeArray[0] = LIFT_RETURN_OUT = new LiftType();
                liftTypeArray[1] = LIFT_ASSIGNMENT_OUT = new LiftType();
                $VALUES = liftTypeArray;
            }

            public static LiftType[] values() {
                return (LiftType[])$VALUES.clone();
            }

            public static LiftType valueOf(String string) {
                return Enum.valueOf(LiftType.class, string);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftState;", "", "keyword", "Lcom/intellij/psi/PsiElement;", "isSerious", "", "liftType", "Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftType;", "highlightElement", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lcom/intellij/psi/PsiElement;ZLorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftType;Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/ProblemHighlightType;)V", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "()Z", "getKeyword", "getLiftType", "()Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion$LiftType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        public static final class LiftState {
            @NotNull
            private final PsiElement keyword;
            private final boolean isSerious;
            @NotNull
            private final LiftType liftType;
            @NotNull
            private final PsiElement highlightElement;
            @NotNull
            private final ProblemHighlightType highlightType;

            @NotNull
            public final PsiElement getKeyword() {
                return this.keyword;
            }

            public final boolean isSerious() {
                return this.isSerious;
            }

            @NotNull
            public final LiftType getLiftType() {
                return this.liftType;
            }

            @NotNull
            public final PsiElement getHighlightElement() {
                return this.highlightElement;
            }

            @NotNull
            public final ProblemHighlightType getHighlightType() {
                return this.highlightType;
            }

            public LiftState(@NotNull PsiElement keyword, boolean isSerious, @NotNull LiftType liftType, @NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType) {
                Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
                Intrinsics.checkNotNullParameter((Object)((Object)liftType), (String)"liftType");
                Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                this.keyword = keyword;
                this.isSerious = isSerious;
                this.liftType = liftType;
                this.highlightElement = highlightElement;
                this.highlightType = highlightType;
            }

            public /* synthetic */ LiftState(PsiElement psiElement2, boolean bl, LiftType liftType, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    psiElement3 = psiElement2;
                }
                if ((n & 0x10) != 0) {
                    problemHighlightType2 = bl ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                }
                this(psiElement2, bl, liftType, psiElement3, problemHighlightType2);
            }

            @NotNull
            public final PsiElement component1() {
                return this.keyword;
            }

            public final boolean component2() {
                return this.isSerious;
            }

            @NotNull
            public final LiftType component3() {
                return this.liftType;
            }

            @NotNull
            public final PsiElement component4() {
                return this.highlightElement;
            }

            @NotNull
            public final ProblemHighlightType component5() {
                return this.highlightType;
            }

            @NotNull
            public final LiftState copy(@NotNull PsiElement keyword, boolean isSerious, @NotNull LiftType liftType, @NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType) {
                Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
                Intrinsics.checkNotNullParameter((Object)((Object)liftType), (String)"liftType");
                Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                return new LiftState(keyword, isSerious, liftType, highlightElement, highlightType);
            }

            public static /* synthetic */ LiftState copy$default(LiftState liftState, PsiElement psiElement2, boolean bl, LiftType liftType, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, Object object) {
                if ((n & 1) != 0) {
                    psiElement2 = liftState.keyword;
                }
                if ((n & 2) != 0) {
                    bl = liftState.isSerious;
                }
                if ((n & 4) != 0) {
                    liftType = liftState.liftType;
                }
                if ((n & 8) != 0) {
                    psiElement3 = liftState.highlightElement;
                }
                if ((n & 0x10) != 0) {
                    problemHighlightType2 = liftState.highlightType;
                }
                return liftState.copy(psiElement2, bl, liftType, psiElement3, problemHighlightType2);
            }

            @NotNull
            public String toString() {
                return "LiftState(keyword=" + this.keyword + ", isSerious=" + this.isSerious + ", liftType=" + this.liftType + ", highlightElement=" + this.highlightElement + ", highlightType=" + this.highlightType + ")";
            }

            public int hashCode() {
                PsiElement psiElement2 = this.keyword;
                int n = (psiElement2 != null ? psiElement2.hashCode() : 0) * 31;
                int n2 = this.isSerious ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                LiftType liftType = this.liftType;
                PsiElement psiElement3 = this.highlightElement;
                ProblemHighlightType problemHighlightType2 = this.highlightType;
                return (((n + n2) * 31 + (liftType != null ? ((Object)((Object)liftType)).hashCode() : 0)) * 31 + (psiElement3 != null ? psiElement3.hashCode() : 0)) * 31 + (problemHighlightType2 != null ? problemHighlightType2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LiftState)) break block3;
                        LiftState liftState = (LiftState)object;
                        if (!Intrinsics.areEqual((Object)this.keyword, (Object)liftState.keyword) || this.isSerious != liftState.isSerious || !Intrinsics.areEqual((Object)((Object)this.liftType), (Object)((Object)liftState.liftType)) || !Intrinsics.areEqual((Object)this.highlightElement, (Object)liftState.highlightElement) || !Intrinsics.areEqual((Object)this.highlightType, (Object)liftState.highlightType)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

