/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.UtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Imported;
import org.jetbrains.kotlin.idea.util.FileUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/LoadConfigurationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ensureValidActionVisibility", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getKotlinScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getNotificationVisibility", "", "update", "kotlin.gradle.gradle-java"})
public final class LoadConfigurationAction
extends AnAction {
    public LoadConfigurationAction() {
        super(KotlinIdeaGradleBundle.message("action.text.load.script.configurations", new Object[0]), KotlinIdeaGradleBundle.message("action.description.load.script.configurations", new Object[0]), KotlinIcons.LOAD_SCRIPT_CONFIGURATION);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Imported imported;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        VirtualFile virtualFile2 = this.getKotlinScriptFile(editor3);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(project3);
        if (gradleBuildRootsManager == null) {
            imported = null;
        } else {
            GradleScriptInfo gradleScriptInfo = gradleBuildRootsManager.getScriptInfo(file2);
            imported = gradleScriptInfo == null ? null : gradleScriptInfo.getBuildRoot();
        }
        if (imported == null) {
            return;
        }
        Imported root = imported;
        GradleImportHelperKt.runPartialGradleImport(project3, root);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        e.getPresentation().setVisible(this.getNotificationVisibility(editor3));
    }

    private final boolean getNotificationVisibility(Editor editor2) {
        boolean bl;
        if (!GradleImportHelperKt.getScriptConfigurationsNeedToBeUpdatedBalloon()) {
            return false;
        }
        if (DiffUtil.isDiffEditor((Editor)editor2)) {
            return false;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        if (ScriptDefinitionProvider.Companion.getServiceIfCreated(project3) == null) {
            return false;
        }
        VirtualFile virtualFile2 = this.getKotlinScriptFile(editor2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        if (GradleImportHelperKt.autoReloadScriptConfigurations(project3, file2)) {
            return false;
        }
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(project3);
        return gradleBuildRootsManager == null ? false : (bl = gradleBuildRootsManager.isConfigurationOutOfDate(file2));
    }

    private final VirtualFile getKotlinScriptFile(Editor editor2) {
        Object object;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) {
            object = null;
        } else {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            object = !(it instanceof LightVirtualFileBase) && it.isValid() && FileUtilsKt.isKotlinFileType(it) && UtilsKt.isGradleKotlinScript(it) ? virtualFile3 : null;
        }
        return object;
    }
}

