/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesRecorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinSimilarityFeaturesExtractor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "myContext", "myUsageSimilarityFeaturesRecorder", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesRecorder;", "getFeatures", "Lcom/intellij/usages/similarity/bag/Bag;", "theFirstReferenceInQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitBinaryExpression", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitReferenceExpression", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "kotlin.idea"})
public final class KotlinSimilarityFeaturesExtractor
extends KtTreeVisitorVoid {
    private final UsageSimilarityFeaturesRecorder myUsageSimilarityFeaturesRecorder;
    private final PsiElement myContext;

    @NotNull
    public final Bag getFeatures() {
        this.myContext.accept((PsiElementVisitor)this);
        Bag bag = this.myUsageSimilarityFeaturesRecorder.getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)bag, (String)"myUsageSimilarityFeaturesRecorder.features");
        return bag;
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "literal: string");
        super.visitStringTemplateExpression(expression2);
    }

    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)property2, "VAR: ");
        super.visitProperty(property2);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, expression2.getOperationToken().toString());
        super.visitBinaryExpression(expression2);
    }

    public void visitIsExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "instanceof");
        super.visitIsExpression(expression2);
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)lambdaExpression2, "lambda");
        super.visitLambdaExpression(lambdaExpression2);
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, expression2.getOperationToken().toString());
        super.visitUnaryExpression(expression2);
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Object feature = "VAR:";
        if (!this.theFirstReferenceInQualifiedExpression(expression2) && expression2 instanceof KtNameReferenceExpression) {
            feature = "{CALL: " + ((KtNameReferenceExpression)expression2).getReferencedName() + "}";
        }
        this.myUsageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, (String)feature);
        super.visitReferenceExpression(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean theFirstReferenceInQualifiedExpression(KtReferenceExpression expression2) {
        if (!(expression2.getParent() instanceof KtQualifiedExpression)) return false;
        PsiElement psiElement2 = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"expression.parent");
        if (!Intrinsics.areEqual((Object)psiElement2.getFirstChild(), (Object)expression2)) return false;
        return true;
    }

    public KotlinSimilarityFeaturesExtractor(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.myUsageSimilarityFeaturesRecorder = new UsageSimilarityFeaturesRecorder(context2);
        this.myContext = context2;
    }
}

