/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFilterer;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererAdapter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.OpcodeReportingMethodVisitor;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a:\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u001a.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0014\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0010*\u00020\u000fH\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u00a8\u0006\u0017"}, d2={"calculateSmartStepTargetsToShow", "", "Lcom/intellij/debugger/actions/SmartStepTarget;", "targets", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "lines", "Lkotlin/ranges/ClosedRange;", "", "filterSmartStepTargets", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "location", "Lcom/sun/jdi/Location;", "findSmartStepTargets", "topmostElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/util/Range;", "filterAlreadyExecuted", "getLines", "getTopmostElement", "Lcom/intellij/debugger/SourcePosition;", "toClosedRange", "Lkotlin/ranges/IntRange;", "kotlin.jvm-debugger.core"})
public final class KotlinSmartStepIntoHandlerKt {
    private static final List<SmartStepTarget> findSmartStepTargets(KtElement topmostElement, Range<Integer> lines) {
        OrderedSet targets = new OrderedSet();
        SmartStepTargetVisitor visitor2 = new SmartStepTargetVisitor(topmostElement, lines, (OrderedSet<SmartStepTarget>)targets);
        topmostElement.accept((KtVisitor)visitor2, null);
        return (List)targets;
    }

    private static final List<SmartStepTarget> calculateSmartStepTargetsToShow(List<? extends SmartStepTarget> targets, DebugProcessImpl debugProcess, ClosedRange<Integer> lines) {
        List lambdaTargets = new ArrayList();
        List methodTargets = new ArrayList();
        for (SmartStepTarget smartStepTarget : targets) {
            if (smartStepTarget instanceof KotlinMethodSmartStepTarget) {
                methodTargets.add(smartStepTarget);
                continue;
            }
            lambdaTargets.add(smartStepTarget);
        }
        return CollectionsKt.plus((Collection)lambdaTargets, (Iterable)KotlinSmartStepIntoHandlerKt.filterAlreadyExecuted(methodTargets, debugProcess, lines));
    }

    private static final List<KotlinMethodSmartStepTarget> filterAlreadyExecuted(List<KotlinMethodSmartStepTarget> $this$filterAlreadyExecuted, DebugProcessImpl debugProcess, ClosedRange<Integer> lines) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)debugProcess) || $this$filterAlreadyExecuted.size() <= 1) {
            return $this$filterAlreadyExecuted;
        }
        SuspendManager suspendManager = debugProcess.getSuspendManager();
        Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"debugProcess.suspendManager");
        SuspendContextImpl suspendContextImpl = suspendManager.getPausedContext();
        Object frameProxy = suspendContextImpl != null ? suspendContextImpl.getFrameProxy() : null;
        Object object = frameProxy;
        if (object == null || (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) == null) {
            return $this$filterAlreadyExecuted;
        }
        Object location2 = object;
        return KotlinSmartStepIntoHandlerKt.filterSmartStepTargets((Location)location2, lines, $this$filterAlreadyExecuted, debugProcess);
    }

    private static final KtElement getTopmostElement(SourcePosition $this$getTopmostElement) {
        PsiElement psiElement2 = $this$getTopmostElement.getElementAt();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element3 = psiElement2;
        TextRange textRange = element3.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        PsiElement psiElement3 = CodeInsightUtils.getTopmostElementAtOffset(element3, textRange.getStartOffset());
        if (!(psiElement3 instanceof KtElement)) {
            psiElement3 = null;
        }
        return (KtElement)psiElement3;
    }

    private static final Range<Integer> getLines(KtElement $this$getLines) {
        TextRange textRange;
        KtFile ktFile = $this$getLines.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingKtFile");
        KtFile file2 = ktFile;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026ment(file) ?: return null");
        Document document2 = document;
        TextRange textRange2 = textRange = $this$getLines.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
        return new Range((Comparable)Integer.valueOf(document2.getLineNumber(textRange2.getStartOffset())), (Comparable)Integer.valueOf(document2.getLineNumber(textRange.getEndOffset())));
    }

    private static final List<KotlinMethodSmartStepTarget> filterSmartStepTargets(Location location2, ClosedRange<Integer> lines, List<KotlinMethodSmartStepTarget> targets, DebugProcessImpl debugProcess) {
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return targets;
        }
        Method method2 = method;
        KotlinSmartStepTargetFilterer targetFilterer = new KotlinSmartStepTargetFilterer(targets, debugProcess);
        CompoundPositionManager compoundPositionManager = debugProcess.getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"debugProcess.positionManager");
        KotlinSmartStepTargetFiltererAdapter targetFiltererAdapter = new KotlinSmartStepTargetFiltererAdapter(lines, location2, (PositionManager)compoundPositionManager, targetFilterer);
        List visitedOpcodes = new ArrayList();
        MethodBytecodeUtil.visit((Method)method2, (long)Long.MAX_VALUE, (MethodVisitor)new OpcodeReportingMethodVisitor(visitedOpcodes, targetFiltererAdapter, targetFiltererAdapter){
            final /* synthetic */ List $visitedOpcodes;
            final /* synthetic */ KotlinSmartStepTargetFiltererAdapter $targetFiltererAdapter;

            protected void reportOpcode(int opcode) {
                ProgressManager.checkCanceled();
                this.$visitedOpcodes.add(opcode);
                this.$targetFiltererAdapter.reportOpcode(opcode);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                this.$targetFiltererAdapter.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
            }
            {
                this.$visitedOpcodes = $captured_local_variable$0;
                this.$targetFiltererAdapter = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }, (boolean)true);
        Collection collection = targetFilterer.getUnvisitedTargets();
        if (!collection.isEmpty()) {
            return targets;
        }
        targetFilterer.reset();
        MethodBytecodeUtil.visit((Method)method2, (long)location2.codeIndex(), (MethodVisitor)new OpcodeReportingMethodVisitor(visitedOpcodes, targetFiltererAdapter, targetFiltererAdapter){
            private int visitedOpcodeCnt;
            private boolean stopVisiting;
            final /* synthetic */ List $visitedOpcodes;
            final /* synthetic */ KotlinSmartStepTargetFiltererAdapter $targetFiltererAdapter;

            protected void reportOpcode(int opcode) {
                block3: {
                    block2: {
                        ProgressManager.checkCanceled();
                        if (this.stopVisiting) break block2;
                        int n = this.visitedOpcodeCnt;
                        this.visitedOpcodeCnt = n + 1;
                        if (opcode == ((Number)this.$visitedOpcodes.get(n)).intValue()) break block3;
                    }
                    this.stopVisiting = true;
                    return;
                }
                this.$targetFiltererAdapter.reportOpcode(opcode);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (this.stopVisiting) {
                    return;
                }
                this.$targetFiltererAdapter.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
            }
            {
                this.$visitedOpcodes = $captured_local_variable$0;
                this.$targetFiltererAdapter = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }, (boolean)true);
        return targetFilterer.getUnvisitedTargets();
    }

    private static final IntRange toClosedRange(Range<Integer> $this$toClosedRange) {
        int n = ((Number)((Object)$this$toClosedRange.getFrom())).intValue();
        Comparable comparable = $this$toClosedRange.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"to");
        return new IntRange(n, ((Number)((Object)comparable)).intValue());
    }

    public static final /* synthetic */ KtElement access$getTopmostElement(SourcePosition $this$access_u24getTopmostElement) {
        return KotlinSmartStepIntoHandlerKt.getTopmostElement($this$access_u24getTopmostElement);
    }

    public static final /* synthetic */ Range access$getLines(KtElement $this$access_u24getLines) {
        return KotlinSmartStepIntoHandlerKt.getLines($this$access_u24getLines);
    }

    public static final /* synthetic */ List access$findSmartStepTargets(KtElement topmostElement, Range lines) {
        return KotlinSmartStepIntoHandlerKt.findSmartStepTargets(topmostElement, (Range<Integer>)lines);
    }

    public static final /* synthetic */ List access$calculateSmartStepTargetsToShow(List targets, DebugProcessImpl debugProcess, ClosedRange lines) {
        return KotlinSmartStepIntoHandlerKt.calculateSmartStepTargetsToShow(targets, debugProcess, (ClosedRange<Integer>)lines);
    }

    public static final /* synthetic */ IntRange access$toClosedRange(Range $this$access_u24toClosedRange) {
        return KotlinSmartStepIntoHandlerKt.toClosedRange((Range<Integer>)$this$access_u24toClosedRange);
    }
}

