/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stackFrame;

import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.InlineStackFrameVariableHolder;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.AbstractInlineFunctionInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineFunctionInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackFrameInfo;
import org.jetbrains.kotlin.idea.debugger.stackFrame.InlineStackFrameProxyKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrameWithProvidedVariables;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002J,\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004*\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0004*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004*\u0004\u0018\u00010\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stackFrame/InlineStackTraceCalculator;", "", "()V", "calculateInlineStackTrace", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "createInlineStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/KotlinStackFrame;", "framesInfo", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/InlineStackFrameInfo;", "frameProxyLocation", "Lcom/sun/jdi/Location;", "fetchDepths", "", "fetchLocationsAndGetNewFrameProxyLocation", "allLocations", "originalLocation", "getInlineFunctionsInfo", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/AbstractInlineFunctionInfo;", "Lcom/sun/jdi/Method;", "getInlineStackFramesInfo", "location", "getVisibleVariables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "kotlin.jvm-debugger.core"})
public final class InlineStackTraceCalculator {
    @NotNull
    public static final InlineStackTraceCalculator INSTANCE;

    @NotNull
    public final List<XStackFrame> calculateInlineStackTrace(@NotNull StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        if (location2 == null) {
            return CollectionsKt.emptyList();
        }
        Location location3 = location2;
        Method method = SafeUtilKt.safeMethod(location3);
        if (method == null) {
            return CollectionsKt.emptyList();
        }
        Method method2 = method;
        List<InlineStackFrameInfo> framesInfo = this.getInlineStackFramesInfo(method2, location3);
        if (framesInfo.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<Location> allLocations = SafeUtilKt.safeAllLineLocations(method2);
        if (allLocations.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.fetchDepths(framesInfo);
        Location newFrameProxyLocation = this.fetchLocationsAndGetNewFrameProxyLocation(framesInfo, allLocations, location3);
        return this.createInlineStackFrames(framesInfo, frameProxy, newFrameProxyLocation);
    }

    private final List<KotlinStackFrame> createInlineStackFrames(List<InlineStackFrameInfo> framesInfo, StackFrameProxyImpl frameProxy, Location frameProxyLocation) {
        List stackFrames2 = new ArrayList();
        InlineStackFrameVariableHolder variableHolder = InlineStackFrameVariableHolder.Companion.fromStackFrame(frameProxy);
        for (InlineStackFrameInfo info2 : CollectionsKt.asReversed(framesInfo)) {
            stackFrames2.add(info2.toInlineStackFrame(frameProxy, this.getVisibleVariables(variableHolder)));
            InlineStackFrameVariableHolder inlineStackFrameVariableHolder = variableHolder;
            variableHolder = inlineStackFrameVariableHolder != null ? inlineStackFrameVariableHolder.getParentFrame() : null;
        }
        KotlinStackFrameWithProvidedVariables originalFrame = new KotlinStackFrameWithProvidedVariables(InlineStackFrameProxyKt.safeInlineStackFrameProxy(frameProxyLocation, 0, frameProxy), this.getVisibleVariables(variableHolder));
        stackFrames2.add(originalFrame);
        return stackFrames2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineStackFrameInfo> getInlineStackFramesInfo(Method $this$getInlineStackFramesInfo, Location location2) {
        void $this$mapTo$iv$iv;
        AbstractInlineFunctionInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getInlineFunctionsInfo($this$getInlineStackFramesInfo);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AbstractInlineFunctionInfo)element$iv$iv;
            boolean bl = false;
            if (!it.contains(location2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AbstractInlineFunctionInfo it = (AbstractInlineFunctionInfo)a;
                boolean bl = false;
                Comparable comparable = (Location)it.getBorders().getStart();
                it = (AbstractInlineFunctionInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                Location location2 = (Location)it.getBorders().getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)location2);
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AbstractInlineFunctionInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            InlineStackFrameInfo inlineStackFrameInfo = new InlineStackFrameInfo(it, location2, 0);
            collection.add(inlineStackFrameInfo);
        }
        return (List)destination$iv$iv;
    }

    private final List<AbstractInlineFunctionInfo> getInlineFunctionsInfo(Method $this$getInlineFunctionsInfo) {
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionsInfo);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<LocalVariable> localVariables = list2;
        List functionsInfo = new ArrayList();
        for (LocalVariable variable2 : localVariables) {
            ClosedRange<Location> borders;
            String variableName;
            if (DebuggerUtils.INSTANCE.getBorders(variable2) == null) {
                continue;
            }
            String string = variableName = variable2.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName");
            if (StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) {
                functionsInfo.add(new InlineFunctionInfo(variableName, borders));
                continue;
            }
            if (!StringsKt.startsWith$default((String)variableName, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            functionsInfo.add(new InlineLambdaInfo(variableName, borders));
        }
        return functionsInfo;
    }

    /*
     * Unable to fully structure code
     */
    private final void fetchDepths(List<InlineStackFrameInfo> framesInfo) {
        currentDepth = 0;
        depths = new LinkedHashMap<K, V>();
        for (InlineStackFrameInfo frame : framesInfo) {
            block4: {
                block3: {
                    info = frame.getInlineFunctionInfo();
                    if (!(info instanceof InlineLambdaInfo)) break block3;
                    v0 = ((InlineLambdaInfo)info).getDeclarationFunctionName();
                    if (v0 == null) ** GOTO lbl-1000
                    it = var8_8 = v0;
                    $i$a$-let-InlineStackTraceCalculator$fetchDepths$calculatedDepth$1 = false;
                    v0 = (Integer)depths.get(it);
                    if (v0 != null) {
                        v1 = v0.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = 0;
                    }
                    break block4;
                }
                v1 = currentDepth + 1;
            }
            calculatedDepth = v1;
            depths.put(info.getName(), calculatedDepth);
            frame.setDepth(calculatedDepth);
            currentDepth = calculatedDepth;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Location fetchLocationsAndGetNewFrameProxyLocation(List<InlineStackFrameInfo> framesInfo, List<? extends Location> allLocations, Location originalLocation) {
        int firstInlineCallLocationIndex;
        int index$iv;
        block7: {
            int n;
            if (framesInfo.isEmpty()) {
                return originalLocation;
            }
            AbstractInlineFunctionInfo firstInlineFunctionInfo = ((InlineStackFrameInfo)CollectionsKt.first(framesInfo)).getInlineFunctionInfo();
            List<? extends Location> $this$indexOfFirst$iv = allLocations;
            boolean $i$f$indexOfFirst = false;
            index$iv = 0;
            Iterator<? extends Location> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Location item$iv;
                Location it = item$iv = iterator.next();
                boolean bl = false;
                if (firstInlineFunctionInfo.contains(it)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = firstInlineCallLocationIndex = -1;
        }
        if (firstInlineCallLocationIndex == -1) {
            return originalLocation;
        }
        int frameIndex = 1;
        Location prevLocation = originalLocation;
        index$iv = firstInlineCallLocationIndex;
        int n = CollectionsKt.getLastIndex(allLocations);
        if (index$iv <= n) {
            while (frameIndex <= CollectionsKt.getLastIndex(framesInfo)) {
                void locationIndex;
                Location location2 = allLocations.get((int)locationIndex);
                InlineStackFrameInfo currentFrame = framesInfo.get(frameIndex);
                InlineStackFrameInfo previousFrame = framesInfo.get(frameIndex - 1);
                if (currentFrame.getInlineFunctionInfo().contains(location2)) {
                    previousFrame.setLocation(prevLocation);
                    ++frameIndex;
                }
                prevLocation = location2;
                if (locationIndex == n) break;
                ++locationIndex;
            }
        }
        ((InlineStackFrameInfo)CollectionsKt.last(framesInfo)).setLocation(originalLocation);
        int newFrameProxyLocationIndex = firstInlineCallLocationIndex > 0 ? firstInlineCallLocationIndex - 1 : 0;
        return allLocations.get(newFrameProxyLocationIndex);
    }

    private final List<LocalVariableProxyImpl> getVisibleVariables(InlineStackFrameVariableHolder $this$getVisibleVariables) {
        InlineStackFrameVariableHolder inlineStackFrameVariableHolder = $this$getVisibleVariables;
        List list2 = inlineStackFrameVariableHolder != null ? inlineStackFrameVariableHolder.getVisibleVariables() : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private InlineStackTraceCalculator() {
    }

    static {
        InlineStackTraceCalculator inlineStackTraceCalculator;
        INSTANCE = inlineStackTraceCalculator = new InlineStackTraceCalculator();
    }
}

