/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.filter;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u000f\u0010\r\u001a\u00020\u0004*\u0004\u0018\u00010\u000eH\u0082\u0010J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "()V", "hasInterfaceWithImplementation", "", "method", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "isNotSynthetic", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isSynthetic", "isCallableReferenceSyntheticClass", "Lcom/sun/jdi/ReferenceType;", "isDelegateToDefaultInterfaceImpl", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinSyntheticTypeComponentProvider
implements SyntheticTypeComponentProvider {
    @Deprecated
    private static final IntRange LOAD_INSTRUCTIONS_WITH_INDEX;
    @Deprecated
    private static final IntRange LOAD_INSTRUCTIONS;
    @Deprecated
    private static final IntRange RETURN_INSTRUCTIONS;
    @Deprecated
    private static final IntRange ICONST_INSTRUCTIONS;
    @NotNull
    private static final Companion Companion;

    public boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (!(typeComponent instanceof Method)) {
            return false;
        }
        ReferenceType containingType = typeComponent.declaringType();
        String typeName = containingType.name();
        if (!FqNameUnsafe.isValid((String)typeName)) {
            return false;
        }
        if (this.isCallableReferenceSyntheticClass(containingType)) {
            return true;
        }
        try {
            boolean bl;
            block16: {
                Location it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block15: {
                    if (this.isDelegateToDefaultInterfaceImpl((Method)typeComponent)) {
                        return true;
                    }
                    Location location2 = ((Method)typeComponent).location();
                    if (location2 == null || location2.lineNumber() != 1) {
                        return false;
                    }
                    List<Location> list2 = ((Method)typeComponent).allLineLocations();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"typeComponent.allLineLocations()");
                    $this$any$iv = list2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Location)element$iv;
                            boolean bl3 = false;
                            if (!(it.lineNumber() != 1)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return false;
                }
                ReferenceType referenceType = typeComponent.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"typeComponent.declaringType()");
                $this$any$iv = SafeUtilKt.safeAllLineLocations(referenceType);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Location)element$iv;
                        boolean bl4 = false;
                        if (!(it.lineNumber() != 1)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            return !bl;
        }
        catch (AbsentInformationException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public boolean isNotSynthetic(@Nullable TypeComponent typeComponent) {
        if (typeComponent instanceof Method) {
            String name2;
            String string = name2 = typeComponent.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (StringsKt.endsWith$default((String)string, (String)"$suspendImpl", (boolean)false, (int)2, null)) {
                Location location2 = ((Method)typeComponent).location();
                if (location2 != null) {
                    if (DebuggerUtilKt.isInKotlinSources(location2)) {
                        ReferenceType containingClass2 = typeComponent.declaringType();
                        List<String> list2 = ((Method)typeComponent).argumentTypeNames();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"typeComponent.argumentTypeNames()");
                        if (Intrinsics.areEqual((Object)((String)CollectionsKt.firstOrNull(list2)), (Object)containingClass2.name())) {
                            return true;
                        }
                    }
                }
            } else if (StringsKt.endsWith$default((String)name2, (String)"$default", (boolean)false, (int)2, null)) {
                String originalName = StringsKt.dropLast((String)name2, (int)"$default".length());
                List<Method> list3 = typeComponent.declaringType().methodsByName(originalName);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"typeComponent.declaringT\u2026thodsByName(originalName)");
                Collection collection = list3;
                return !collection.isEmpty();
            }
        }
        return super.isNotSynthetic(typeComponent);
    }

    private final boolean isCallableReferenceSyntheticClass(ReferenceType $this$isCallableReferenceSyntheticClass) {
        while (true) {
            ClassType superClass;
            if (!($this$isCallableReferenceSyntheticClass instanceof ClassType)) {
                return false;
            }
            if (((ClassType)$this$isCallableReferenceSyntheticClass).superclass() == null) {
                return false;
            }
            String superClassName = superClass.name();
            if (Intrinsics.areEqual((Object)superClassName, (Object)PropertyReference.class.getName()) || Intrinsics.areEqual((Object)superClassName, (Object)FunctionReference.class.getName())) {
                return true;
            }
            String string = superClassName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"superClassName");
            if (!StringsKt.startsWith$default((String)string, (String)"kotlin.jvm.internal.", (boolean)false, (int)2, null)) break;
            $this$isCallableReferenceSyntheticClass = superClass;
        }
        return false;
    }

    private final boolean isDelegateToDefaultInterfaceImpl(Method $this$isDelegateToDefaultInterfaceImpl) {
        if (SafeUtilKt.safeAllLineLocations($this$isDelegateToDefaultInterfaceImpl).size() != 1) {
            return false;
        }
        if (!$this$isDelegateToDefaultInterfaceImpl.virtualMachine().canGetBytecodes()) {
            return false;
        }
        if (!this.hasOnlyInvokeStatic($this$isDelegateToDefaultInterfaceImpl)) {
            return false;
        }
        return this.hasInterfaceWithImplementation($this$isDelegateToDefaultInterfaceImpl);
    }

    private final boolean hasOnlyInvokeStatic(Method m) {
        byte[] instructions = m.bytecodes();
        int i = 0;
        boolean isALoad0BeforeStaticCall = false;
        while (i < instructions.length) {
            byte nextInstr;
            byte instr = instructions[i];
            if (instr == (byte)42) {
                ++i;
                isALoad0BeforeStaticCall = true;
                continue;
            }
            if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr) || RangesKt.intRangeContains((ClosedRange)((ClosedRange)LOAD_INSTRUCTIONS), (byte)instr)) {
                ++i;
                if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr)) {
                    ++i;
                }
                if ((nextInstr = instructions[i]) != (byte)18) continue;
                i += 2;
                isALoad0BeforeStaticCall = false;
                continue;
            }
            if (instr == (byte)184) {
                if (!isALoad0BeforeStaticCall || (i += 3) != instructions.length - 1) continue;
                nextInstr = instructions[i];
                return RangesKt.intRangeContains((ClosedRange)((ClosedRange)RETURN_INSTRUCTIONS), (byte)nextInstr);
            }
            if (instr == (byte)192) {
                if (instructions[++i] != (byte)0) {
                    return false;
                }
                if (!RangesKt.intRangeContains((ClosedRange)((ClosedRange)ICONST_INSTRUCTIONS), (byte)instructions[++i])) {
                    return false;
                }
                ++i;
                continue;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInterfaceWithImplementation(Method method) {
        boolean bl;
        block6: {
            void $this$flatMapTo$iv$iv;
            ReferenceType referenceType = method.declaringType();
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            ClassType classType = (ClassType)referenceType;
            if (classType == null) {
                return false;
            }
            ClassType declaringType = classType;
            List<InterfaceType> interfaces = declaringType.allInterfaces();
            VirtualMachine vm = declaringType.virtualMachine();
            List<InterfaceType> list2 = interfaces;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"interfaces");
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                InterfaceType it = (InterfaceType)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = vm.classesByName(it.name() + "$DefaultImpls");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List traitImpls = (List)destination$iv$iv;
            Iterable $this$any$iv = traitImpls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ReferenceType it = (ReferenceType)element$iv;
                    boolean bl3 = false;
                    List<Method> list3 = it.methodsByName(method.name());
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"it.methodsByName(method.name())");
                    Collection collection = list3;
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Companion = new Companion(null);
        int n = 21;
        LOAD_INSTRUCTIONS_WITH_INDEX = new IntRange(n, (int)((byte)25));
        n = (byte)26;
        LOAD_INSTRUCTIONS = new IntRange(n, (int)((byte)45));
        n = (byte)172;
        RETURN_INSTRUCTIONS = new IntRange(n, (int)((byte)177));
        n = 2;
        ICONST_INSTRUCTIONS = new IntRange(n, 8);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/filter/KotlinSyntheticTypeComponentProvider$Companion;", "", "()V", "ICONST_INSTRUCTIONS", "Lkotlin/ranges/IntRange;", "LOAD_INSTRUCTIONS", "LOAD_INSTRUCTIONS_WITH_INDEX", "RETURN_INSTRUCTIONS", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

