/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J%\u0010\u0016\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0017*\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineScopeExtractor;", "", "()V", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "getContextMethod", "Lcom/sun/jdi/Method;", "getMethod", "jobKey", "Lcom/sun/jdi/Value;", "extractCoroutineScope", "Lcom/sun/jdi/ObjectReference;", "continuation", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "init", "", "findClass", "Lcom/sun/jdi/ReferenceType;", "kotlin.jvm.PlatformType", "name", "", "findMethod", "Lorg/jetbrains/annotations/Nullable;", "signature", "getCoroutineContext", "getCoroutineScopeByJobKey", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineScopeExtractor {
    private static DebugProcess debugProcess;
    private static Method getContextMethod;
    private static Method getMethod;
    private static Value jobKey;
    @NotNull
    public static final CoroutineScopeExtractor INSTANCE;

    @Nullable
    public final ObjectReference extractCoroutineScope(@NotNull ObjectReference continuation2, @NotNull EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)continuation2, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        try {
            if (Intrinsics.areEqual((Object)debugProcess, (Object)evaluationContext.getDebugProcess()) ^ true) {
                this.init(evaluationContext);
            }
            ObjectReference objectReference = this.getCoroutineContext(continuation2, evaluationContext);
            if (objectReference == null) {
                return null;
            }
            ObjectReference coroutineContext = objectReference;
            ObjectReference objectReference2 = this.getCoroutineScopeByJobKey(coroutineContext, evaluationContext);
            if (objectReference2 == null) {
                return null;
            }
            ObjectReference coroutineScope2 = objectReference2;
            ReferenceType referenceType = coroutineScope2.referenceType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"coroutineScope.referenceType()");
            if (CoroutineUtilsKt.isCoroutineScope(referenceType)) {
                return coroutineScope2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final void init(EvaluationContext evaluationContext) {
        ReferenceType jobType;
        debugProcess = evaluationContext.getDebugProcess();
        ReferenceType referenceType = jobType = this.findClass(evaluationContext, "kotlinx.coroutines.Job");
        Field jobKeyField = referenceType != null ? referenceType.fieldByName("Key") : null;
        jobKey = jobType != null && jobKeyField != null ? jobType.getValue(jobKeyField) : (Value)null;
        ReferenceType continuationType = this.findClass(evaluationContext, "kotlin.coroutines.Continuation");
        ReferenceType coroutineContextType = this.findClass(evaluationContext, "kotlin.coroutines.CoroutineContext");
        getContextMethod = this.findMethod(continuationType, "getContext", "()Lkotlin/coroutines/CoroutineContext;");
        getMethod = this.findMethod(coroutineContextType, "get", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;");
    }

    private final ObjectReference getCoroutineScopeByJobKey(ObjectReference $this$getCoroutineScopeByJobKey, EvaluationContext evaluationContext) {
        Value value2 = jobKey;
        if (value2 == null) {
            return null;
        }
        Value jobKey = value2;
        Method method = getMethod;
        if (method == null) {
            return null;
        }
        Method getMethod = method;
        Value coroutineScope2 = evaluationContext.getDebugProcess().invokeMethod(evaluationContext, $this$getCoroutineScopeByJobKey, getMethod, CollectionsKt.listOf((Object)jobKey));
        Value value3 = coroutineScope2;
        if (!(value3 instanceof ObjectReference)) {
            value3 = null;
        }
        return (ObjectReference)value3;
    }

    private final ObjectReference getCoroutineContext(ObjectReference $this$getCoroutineContext, EvaluationContext evaluationContext) {
        Method method = getContextMethod;
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        Value coroutineContext = evaluationContext.getDebugProcess().invokeMethod(evaluationContext, $this$getCoroutineContext, getContextMethod, CollectionsKt.emptyList());
        Value value2 = coroutineContext;
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        return (ObjectReference)value2;
    }

    private final ReferenceType findClass(EvaluationContext $this$findClass, String name2) {
        return $this$findClass.getDebugProcess().findClass($this$findClass, name2, null);
    }

    private final Method findMethod(ReferenceType $this$findMethod, String name2, String signature) {
        return $this$findMethod == null ? null : DebuggerUtils.findMethod((ReferenceType)$this$findMethod, (String)name2, (String)signature);
    }

    private CoroutineScopeExtractor() {
    }

    static {
        CoroutineScopeExtractor coroutineScopeExtractor;
        INSTANCE = coroutineScopeExtractor = new CoroutineScopeExtractor();
    }
}

