/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "xBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "getMethodName", "", "hasTargetLine", "", "classType", "Lcom/sun/jdi/ReferenceType;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "processClassPrepare", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "kotlin.jvm-debugger.core"})
public final class KotlinLineBreakpoint
extends LineBreakpoint<JavaLineBreakpointProperties> {
    public void processClassPrepare(@Nullable DebugProcess debugProcess, @Nullable ReferenceType classType) {
        XSourcePosition sourcePosition2 = (XSourcePosition)ApplicationUtilsKt.runReadAction((Function0)new Function0<XSourcePosition>(this){
            final /* synthetic */ KotlinLineBreakpoint this$0;

            @Nullable
            public final XSourcePosition invoke() {
                XBreakpoint xBreakpoint = this.this$0.getXBreakpoint();
                return xBreakpoint != null ? xBreakpoint.getSourcePosition() : null;
            }
            {
                this.this$0 = kotlinLineBreakpoint;
                super(0);
            }
        });
        if (classType != null && sourcePosition2 != null && !this.hasTargetLine(classType, sourcePosition2)) {
            return;
        }
        super.processClassPrepare(debugProcess, classType);
    }

    private final boolean hasTargetLine(ReferenceType classType, XSourcePosition sourcePosition2) {
        List list2 = DebuggerUtilsEx.allLineLocations((ReferenceType)classType);
        if (list2 == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"DebuggerUtilsEx.allLineL\u2026classType) ?: return true");
        List allLineLocations = list2;
        if (NoStrataPositionManagerHelperKt.isDexDebug(classType.virtualMachine())) {
            return true;
        }
        VirtualFile virtualFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"sourcePosition.file");
        String string = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcePosition.file.name");
        String fileName = string;
        int lineNumber2 = sourcePosition2.getLine() + 1;
        Iterator iterator = allLineLocations.iterator();
        while (iterator.hasNext()) {
            Location location2;
            Location location3 = location2 = (Location)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location");
            String kotlinFileName = SafeUtilKt.safeSourceName(location3, "Kotlin");
            int kotlinLineNumber = location2.lineNumber("Kotlin");
            if (!(kotlinFileName != null ? Intrinsics.areEqual((Object)kotlinFileName, (Object)fileName) && kotlinLineNumber == lineNumber2 : Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(location2), (Object)fileName) && location2.lineNumber() == lineNumber2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getMethodName() {
        Object object;
        KtElement element3;
        KtElement ktElement;
        SourcePosition sourcePosition2 = this.getSourcePosition();
        if (sourcePosition2 != null && (sourcePosition2 = sourcePosition2.getElementAt()) != null) {
            SourcePosition $this$getNonStrictParentOfType$iv = sourcePosition2;
            boolean $i$f$getNonStrictParentOfType = false;
            ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtElement.class, (boolean)false);
        } else {
            ktElement = element3 = null;
        }
        if (element3 instanceof KtElement && (object = DeclarationUtilKt.containingNonLocalDeclaration(element3)) != null && (object = object.getName()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            return it;
        }
        return super.getMethodName();
    }

    public KotlinLineBreakpoint(@Nullable Project project2, @Nullable XBreakpoint<? extends XBreakpointProperties<?>> xBreakpoint) {
        super(project2, xBreakpoint, false);
    }
}

