/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpointKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "getPsiClass", "Lcom/intellij/psi/PsiClass;", "invalidateMethodData", "", "reload", "updateClassPattern", "updateMethodData", "descriptor", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "kotlin.jvm-debugger.core"})
public final class KotlinFunctionBreakpoint
extends MethodBreakpoint {
    @Nullable
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PositionUtil.getPsiElementAt((Project)this.myProject, KtClassOrObject.class, (SourcePosition)sourcePosition2);
        if (ktClassOrObject == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktClassOrObject, (String)"PositionUtil.getPsiEleme\u2026\n        ) ?: return null");
        KtClassOrObject declaration2 = ktClassOrObject;
        return (PsiClass)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(new Computable(declaration2){
            final /* synthetic */ KtClassOrObject $declaration;

            public final KtLightClass compute() {
                return LightClassUtilsKt.toLightClass((KtClassOrObject)this.$declaration);
            }
            {
                this.$declaration = ktClassOrObject;
            }
        });
    }

    public void reload() {
        MethodBreakpoint.MethodDescriptor methodDescriptor;
        super.reload();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isReadAccessAllowed() && DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        this.invalidateMethodData();
        SourcePosition sourcePosition2 = this.getSourcePosition();
        if (sourcePosition2 != null) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            methodDescriptor = KotlinFunctionBreakpointKt.getMethodDescriptor(sourcePosition2, project2);
        } else {
            methodDescriptor = null;
        }
        MethodBreakpoint.MethodDescriptor descriptor2 = methodDescriptor;
        ProgressIndicatorProvider.checkCanceled();
        this.updateMethodData(descriptor2);
        this.updateClassPattern();
    }

    private final void invalidateMethodData() {
        this.setMethodName(null);
        this.mySignature = null;
    }

    private final void updateMethodData(MethodBreakpoint.MethodDescriptor descriptor2) {
        MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2;
        this.setMethodName(methodDescriptor != null ? methodDescriptor.methodName : null);
        MethodBreakpoint.MethodDescriptor methodDescriptor2 = descriptor2;
        this.mySignature = methodDescriptor2 != null ? methodDescriptor2.methodSignature : null;
        boolean bl = this.myIsStatic = descriptor2 != null && descriptor2.isStatic;
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateClassPattern() {
        ProgressIndicatorProvider.checkCanceled();
        Task.Backgroundable task2 = new Task.Backgroundable(this, this.myProject, KotlinDebuggerCoreBundle.message("function.breakpoint.initialize", new Object[0])){
            final /* synthetic */ KotlinFunctionBreakpoint this$0;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PsiClass psiClass2 = this.this$0.getPsiClass();
                if (psiClass2 != null) {
                    boolean $i$f$runReadAction = false;
                    KotlinFunctionBreakpoint.access$getProperties((KotlinFunctionBreakpoint)this.this$0).myClassPattern = (String)ApplicationManager.getApplication().runReadAction(new Computable(psiClass2){
                        final /* synthetic */ PsiClass $psiClass$inlined;
                        {
                            this.$psiClass$inlined = psiClass2;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)this.$psiClass$inlined.getQualifiedName();
                        }
                    });
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressManager progressManager2 = progressManager;
        boolean $i$f$isDispatchThread = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            boolean $i$f$isUnitTestMode = false;
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            if (!application2.isUnitTestMode()) {
                progressManager2.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
                return;
            }
        }
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        progressManager2.runProcess(new Runnable(task2, progressIndicator){
            final /* synthetic */ updateClassPattern.task.1 $task;
            final /* synthetic */ EmptyProgressIndicator $progressIndicator;

            public final void run() {
                this.$task.run((ProgressIndicator)this.$progressIndicator);
            }
            {
                this.$task = var1_1;
                this.$progressIndicator = emptyProgressIndicator;
            }
        }, (ProgressIndicator)progressIndicator);
    }

    public KotlinFunctionBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<?> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        super(project2, breakpoint2);
    }

    public static final /* synthetic */ JavaMethodBreakpointProperties access$getProperties(KotlinFunctionBreakpoint $this) {
        return (JavaMethodBreakpointProperties)$this.getProperties();
    }
}

