/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u001a\u001e\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\u000b*\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010*\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "getClassName", "", "Lcom/sun/jdi/Location;", "getInlineFunctionAndArgumentVariablesToBordersMap", "", "Lcom/sun/jdi/LocalVariable;", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/Method;", "getInlineFunctionOrArgumentVariables", "Lkotlin/sequences/Sequence;", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManagerKt {
    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionAndArgumentVariablesToBordersMap(@NotNull Method $this$getInlineFunctionAndArgumentVariablesToBordersMap) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionAndArgumentVariablesToBordersMap, (String)"$this$getInlineFunctionAndArgumentVariablesToBordersMap");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(KotlinPositionManagerKt.getInlineFunctionOrArgumentVariables($this$getInlineFunctionAndArgumentVariablesToBordersMap), (Function1)getInlineFunctionAndArgumentVariablesToBordersMap.1.INSTANCE));
    }

    private static final Sequence<LocalVariable> getInlineFunctionOrArgumentVariables(Method $this$getInlineFunctionOrArgumentVariables) {
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionOrArgumentVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), (Function1)getInlineFunctionOrArgumentVariables.1.INSTANCE);
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"$this$getClassName");
        String string = $this$getClassName.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byFqNameWit\u2026e(currentLocationFqName))");
        String string2 = jvmClassName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JvmClassName.byFqNameWit\u2026tionFqName)).internalName");
        return StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $this$findTargetClasses.getVirtualMachineProxy();
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
        }
        catch (ObjectCollectedException e) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            Iterable iterable;
            for (Location location2 : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = location2.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                iterable = targetClasses;
                iterable.add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                ReferenceType referenceType = nested;
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"nested");
                iterable = KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, referenceType, lineAt);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    public static final /* synthetic */ Sequence access$getInlineFunctionOrArgumentVariables(Method $this$access_u24getInlineFunctionOrArgumentVariables) {
        return KotlinPositionManagerKt.getInlineFunctionOrArgumentVariables($this$access_u24getInlineFunctionOrArgumentVariables);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $this$access_u24findTargetClasses, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($this$access_u24findTargetClasses, outerClass, lineAt);
    }
}

