/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.VariablesCollector;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"findAdditionalExpressions", "", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "position", "Lcom/intellij/debugger/SourcePosition;", "getContainingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lcom/intellij/psi/PsiElement;", "getLineRangeForElement", "Lcom/intellij/openapi/util/TextRange;", "containingElement", "doc", "Lcom/intellij/openapi/editor/Document;", "shouldSkipLine", "", "file", "Lcom/intellij/psi/PsiFile;", "line", "", "kotlin.jvm-debugger.core"})
public final class KotlinFrameExtraVariablesProviderKt {
    private static final Set<TextWithImports> findAdditionalExpressions(SourcePosition position) {
        Integer n;
        Document doc;
        PsiFile file2;
        int line;
        block12: {
            block11: {
                line = position.getLine();
                PsiFile psiFile2 = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.file");
                file2 = psiFile2;
                VirtualFile vFile = file2.getVirtualFile();
                Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
                if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
                    return SetsKt.emptySet();
                }
                n = PsiLinesUtilsKt.getLineStartOffset(file2, line);
                if (n == null) break block11;
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                boolean bl = false;
                n = it > 0 ? n2 : null;
                if (n != null) break block12;
            }
            return SetsKt.emptySet();
        }
        int offset2 = n;
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offset) ?: return emptySet()");
        PsiElement elem = psiElement2;
        KtElement ktElement = KotlinFrameExtraVariablesProviderKt.getContainingElement(elem);
        PsiElement containingElement = ktElement != null ? (PsiElement)ktElement : elem;
        TextRange limit = KotlinFrameExtraVariablesProviderKt.getLineRangeForElement(containingElement, doc);
        int n3 = limit.getStartOffset();
        int startLine = Math.max(n3, line);
        while (startLine - 1 > limit.getStartOffset() && KotlinFrameExtraVariablesProviderKt.shouldSkipLine(file2, doc, startLine - 1)) {
            --startLine;
        }
        int n4 = limit.getEndOffset();
        int endLine = Math.min(n4, line);
        while (endLine + 1 < limit.getEndOffset() && KotlinFrameExtraVariablesProviderKt.shouldSkipLine(file2, doc, endLine + 1)) {
            ++endLine;
        }
        Integer n5 = PsiLinesUtilsKt.getLineStartOffset(file2, startLine);
        if (n5 == null) {
            return SetsKt.emptySet();
        }
        int startOffset = n5;
        Integer n6 = PsiLinesUtilsKt.getLineEndOffset(file2, endLine);
        if (n6 == null) {
            return SetsKt.emptySet();
        }
        int endOffset2 = n6;
        if (startOffset >= endOffset2) {
            return SetsKt.emptySet();
        }
        TextRange lineRange = new TextRange(startOffset, endOffset2);
        if (lineRange.isEmpty()) {
            return SetsKt.emptySet();
        }
        LinkedHashSet expressions2 = new LinkedHashSet();
        VariablesCollector variablesCollector = new VariablesCollector(lineRange, expressions2);
        containingElement.accept((PsiElementVisitor)variablesCollector);
        return expressions2;
    }

    private static final KtElement getContainingElement(PsiElement element3) {
        KtElement contElement;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, KtDeclaration.class);
        KtElement ktElement = contElement = ktDeclaration != null ? (KtElement)ktDeclaration : (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element3, KtElement.class);
        if (contElement instanceof KtProperty && ((KtProperty)contElement).isLocal()) {
            PsiElement parent2;
            PsiElement psiElement2 = parent2 = ((KtProperty)contElement).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            return KotlinFrameExtraVariablesProviderKt.getContainingElement(psiElement2);
        }
        if (contElement instanceof KtDeclarationWithBody) {
            return (KtElement)((KtDeclarationWithBody)contElement).getBodyExpression();
        }
        return contElement;
    }

    private static final TextRange getLineRangeForElement(PsiElement containingElement, Document doc) {
        TextRange elemRange;
        TextRange textRange = elemRange = containingElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"elemRange");
        return new TextRange(doc.getLineNumber(textRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
    }

    private static final boolean shouldSkipLine(PsiFile file2, Document doc, int line) {
        PsiElement elemAtOffset;
        int end;
        int start2 = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \n\t");
        if (start2 >= (end = doc.getLineEndOffset(line))) {
            return true;
        }
        PsiElement psiElement2 = elemAtOffset = file2.findElementAt(start2);
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement psiElement3 = CodeInsightUtils.getTopmostElementAtOffset(psiElement2, start2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"CodeInsightUtils.getTopm\u2026et(elemAtOffset!!, start)");
        PsiElement topmostElementAtOffset = psiElement3;
        return !(topmostElementAtOffset instanceof KtDeclaration);
    }

    public static final /* synthetic */ Set access$findAdditionalExpressions(SourcePosition position) {
        return KotlinFrameExtraVariablesProviderKt.findAdditionalExpressions(position);
    }
}

