/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a<\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "analyzedElements", "", "analyzeInlineFunctions", "", "fullResolveContext", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "file", "analyzeOnlyReifiedInlineFunctions", "bindingContext", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin.core"})
public final class InlineAnalysisUtilsKt {
    @NotNull
    public static final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull KtFile file2, boolean analyzeOnlyReifiedInlineFunctions, @Nullable BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context2 = InlineAnalysisUtilsKt.analyzeElementWithInline(resolutionFacadeForFile, (KtElement)file2, analyzedElements, !analyzeOnlyReifiedInlineFunctions, bindingContext2);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file2);
        Iterator iterator = analyzedElements.iterator();
        while (iterator.hasNext()) {
            KtFile containingFile;
            KtElement collectedElement;
            KtElement ktElement = collectedElement = (KtElement)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"collectedElement");
            Intrinsics.checkNotNullExpressionValue((Object)ktElement.getContainingKtFile(), (String)"collectedElement.containingKtFile");
            toProcess.add(containingFile);
        }
        return new Pair((Object)context2, new ArrayList(toProcess));
    }

    public static /* synthetic */ Pair analyzeInlinedFunctions$default(ResolutionFacade resolutionFacade2, KtFile ktFile, boolean bl, BindingContext bindingContext2, int n, Object object) {
        if ((n & 8) != 0) {
            bindingContext2 = null;
        }
        return InlineAnalysisUtilsKt.analyzeInlinedFunctions(resolutionFacade2, ktFile, bl, bindingContext2);
    }

    private static final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade2, KtElement element3, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions, BindingContext fullResolveContext) {
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        Project project3 = project2;
        HashSet declarationsWithBody = new HashSet();
        ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
        CollectionsKt.addIfNotNull((Collection)innerContexts, (Object)fullResolveContext);
        element3.accept((PsiElementVisitor)new KtTreeVisitorVoid(resolutionFacade2, innerContexts, analyzeInlineFunctions, project3, analyzedElements, declarationsWithBody){
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ ArrayList $innerContexts;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $declarationsWithBody;

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, (KtElement)expression2, null, 2, null);
                this.$innerContexts.add(bindingContext2);
                Call call = (Call)bindingContext2.get((ReadOnlySlice)BindingContext.CALL, (Object)expression2);
                if (call == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)call, (String)"bindingContext.get(Bindi\u2026LL, expression) ?: return");
                Call call2 = call;
                ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                this.checkResolveCall(resolvedCall2);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, (KtElement)destructuringDeclaration, null, 2, null);
                this.$innerContexts.add(bindingContext2);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall2);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, (KtElement)expression2, null, 2, null);
                this.$innerContexts.add(bindingContext2);
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall2) {
                if (resolvedCall2 == null) {
                    return;
                }
                CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                CallableDescriptor callableDescriptor = descriptor2;
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor");
                this.isAdditionalResolveNeededForDescriptor(callableDescriptor);
                if (descriptor2 instanceof PropertyDescriptor) {
                    Iterator<E> iterator = ((PropertyDescriptor)descriptor2).getAccessors().iterator();
                    while (iterator.hasNext()) {
                        PropertyAccessorDescriptor accessor;
                        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = (PropertyAccessorDescriptor)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)propertyAccessorDescriptor, (String)"accessor");
                        this.isAdditionalResolveNeededForDescriptor((CallableDescriptor)propertyAccessorDescriptor);
                    }
                }
            }

            private final void isAdditionalResolveNeededForDescriptor(CallableDescriptor descriptor2) {
                if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) || !this.$analyzeInlineFunctions && !InlineAnalysisUtilsKt.access$hasReifiedTypeParameters(descriptor2)) {
                    return;
                }
                PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                if (declaration2 != null && declaration2 instanceof KtDeclarationWithBody && !this.$analyzedElements.contains(declaration2)) {
                    this.$declarationsWithBody.add(declaration2);
                    return;
                }
            }
            {
                this.$resolutionFacade = $captured_local_variable$0;
                this.$innerContexts = $captured_local_variable$1;
                this.$analyzeInlineFunctions = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$analyzedElements = $captured_local_variable$4;
                this.$declarationsWithBody = $captured_local_variable$5;
            }
        });
        analyzedElements.add(element3);
        Collection collection = declarationsWithBody;
        if (!collection.isEmpty()) {
            Iterator iterator = declarationsWithBody.iterator();
            while (iterator.hasNext()) {
                KtDeclarationWithBody inlineFunction;
                KtDeclarationWithBody ktDeclarationWithBody = inlineFunction = (KtDeclarationWithBody)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktDeclarationWithBody, (String)"inlineFunction");
                KtExpression body2 = ktDeclarationWithBody.getBodyExpression();
                if (body2 == null) continue;
                innerContexts.add(InlineAnalysisUtilsKt.analyzeElementWithInline$default(resolutionFacade2, (KtElement)inlineFunction, analyzedElements, analyzeInlineFunctions, null, 16, null));
            }
            analyzedElements.addAll(declarationsWithBody);
        }
        return CompositeBindingContext.Companion.create((List)innerContexts);
    }

    static /* synthetic */ BindingContext analyzeElementWithInline$default(ResolutionFacade resolutionFacade2, KtElement ktElement, Set set2, boolean bl, BindingContext bindingContext2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bindingContext2 = null;
        }
        return InlineAnalysisUtilsKt.analyzeElementWithInline(resolutionFacade2, ktElement, set2, bl, bindingContext2);
    }

    private static final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            List list2 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.typeParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    TypeParameterDescriptor typeParameterDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        return InlineAnalysisUtilsKt.hasReifiedTypeParameters(descriptor2);
    }
}

