/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.impl.BridgeDependenciesResolverKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationFileAttributeCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotFile;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotForFS;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationFileAttributeCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "areDependenciesValid", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "load", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshotForFS;", "virtualFile", "loadDependencies", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "save", "", "value", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "kotlin.core"})
public final class ScriptConfigurationFileAttributeCache
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        PsiFile psiFile2 = ktFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"ktFile.originalFile");
        VirtualFile virtualFile3 = virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = this.load(virtualFile3);
        if (scriptConfigurationSnapshotForFS == null) {
            return false;
        }
        ScriptConfigurationSnapshotForFS fromFs = scriptConfigurationSnapshotForFS;
        context2.saveNewConfiguration(virtualFile2, new ScriptConfigurationSnapshot(fromFs.getInputs(), fromFs.getReports(), new ScriptCompilationConfigurationWrapper.FromCompilationConfiguration(new KtFileScriptSource(ktFile, null, 2, null), ScriptCompilationKt.with(fromFs.getConfiguration(), (Function1<? super ScriptCompilationConfiguration.Builder, Unit>)((Function1)new Function1<ScriptCompilationConfiguration.Builder, Unit>(scriptDefinition){
            final /* synthetic */ ScriptDefinition $scriptDefinition;

            public final void invoke(@NotNull ScriptCompilationConfiguration.Builder $this$with) {
                Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                $this$with.update(ScriptCompilationKt.getHostConfiguration($this$with), (Function1)new Function1<ScriptingHostConfiguration, ScriptingHostConfiguration>(this){
                    final /* synthetic */ loadDependencies.1 this$0;

                    @Nullable
                    public final ScriptingHostConfiguration invoke(@Nullable ScriptingHostConfiguration it) {
                        return HostConfigurationKt.withDefaultsFrom(it, this.this$0.$scriptDefinition.getHostConfiguration());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$scriptDefinition = scriptDefinition;
                super(1);
            }
        })))));
        CachedConfigurationInputs cachedConfigurationInputs = fromFs.getInputs();
        Project project2 = ktFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"ktFile.project");
        return cachedConfigurationInputs.isUpToDate(project2, virtualFile2, ktFile);
    }

    private final ScriptConfigurationSnapshotForFS load(VirtualFile virtualFile2) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = ScriptConfigurationSnapshotFile.Companion.get(this.project, virtualFile2);
        if (scriptConfigurationSnapshotForFS == null) {
            return null;
        }
        ScriptConfigurationSnapshotForFS configurationSnapshot = scriptConfigurationSnapshotForFS;
        ScriptUtilsKt.scriptingDebugLog(virtualFile2, (Function0<String>)((Function0)new Function0<String>(configurationSnapshot){
            final /* synthetic */ ScriptConfigurationSnapshotForFS $configurationSnapshot;

            @NotNull
            public final String invoke() {
                return "configuration from fileAttributes = " + this.$configurationSnapshot;
            }
            {
                this.$configurationSnapshot = scriptConfigurationSnapshotForFS;
                super(0);
            }
        }));
        ScriptCompilationConfiguration scriptCompilationConfiguration2 = configurationSnapshot.getConfiguration();
        if (scriptCompilationConfiguration2 == null) {
            return null;
        }
        ScriptCompilationConfiguration configuration2 = scriptCompilationConfiguration2;
        if (!this.areDependenciesValid(virtualFile2, configuration2)) {
            this.save(virtualFile2, null);
            return null;
        }
        return configurationSnapshot;
    }

    private final boolean areDependenciesValid(VirtualFile file2, ScriptCompilationConfiguration configuration2) {
        boolean bl;
        block5: {
            Iterable $this$all$iv = BridgeDependenciesResolverKt.toClassPathOrEmpty(configuration2.get(ScriptCompilationKt.getDependencies(ScriptCompilationConfiguration.Companion)));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    Path path2;
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    Path path3 = it.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        bl2 = true;
                    } else {
                        ScriptUtilsKt.scriptingDebugLog(file2, (Function0<String>)((Function0)new Function0<String>(path3){
                            final /* synthetic */ Path $path;

                            @NotNull
                            public final String invoke() {
                                Path path2 = this.$path;
                                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                                Path path3 = path2;
                                return "classpath root saved to file attribute doesn't exist: " + ((Object)path3).toString();
                            }
                            {
                                this.$path = path2;
                                super(0);
                            }
                        }));
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void save(@NotNull VirtualFile file2, @Nullable ScriptConfigurationSnapshot value2) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptConfigurationSnapshotFile.Companion companion = ScriptConfigurationSnapshotFile.Companion;
        Project project2 = this.project;
        VirtualFile virtualFile2 = file2;
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = value2;
        if (scriptConfigurationSnapshot != null) {
            void it;
            ScriptConfigurationSnapshot scriptConfigurationSnapshot2;
            ScriptConfigurationSnapshot scriptConfigurationSnapshot3 = scriptConfigurationSnapshot2 = scriptConfigurationSnapshot;
            VirtualFile virtualFile3 = virtualFile2;
            Project project3 = project2;
            ScriptConfigurationSnapshotFile.Companion companion2 = companion;
            boolean bl = false;
            ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = it.getConfiguration();
            ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS2 = new ScriptConfigurationSnapshotForFS(it.getInputs(), it.getReports(), scriptCompilationConfigurationWrapper != null ? scriptCompilationConfigurationWrapper.getConfiguration() : null);
            companion = companion2;
            project2 = project3;
            virtualFile2 = virtualFile3;
            scriptConfigurationSnapshotForFS = scriptConfigurationSnapshotForFS2;
        } else {
            scriptConfigurationSnapshotForFS = null;
        }
        companion.set(project2, virtualFile2, scriptConfigurationSnapshotForFS);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptConfigurationFileAttributeCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean shouldRunInBackground(@NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        return ScriptConfigurationLoader.DefaultImpls.shouldRunInBackground(this, scriptDefinition);
    }

    @Override
    public boolean interceptBackgroundLoading(@NotNull VirtualFile file2, boolean isFirstLoad, @NotNull Function0<Unit> doLoad) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(doLoad, (String)"doLoad");
        return ScriptConfigurationLoader.DefaultImpls.interceptBackgroundLoading(this, file2, isFirstLoad, doLoad);
    }

    @Override
    public void hideInterceptedNotification(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptConfigurationLoader.DefaultImpls.hideInterceptedNotification(this, file2);
    }
}

