/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.configuration.notifications.SuppressKotlinCodeStyleComponent;
import org.jetbrains.kotlin.idea.configuration.notifications.SuppressKotlinCodeStyleState;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\r\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\r\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\t"}, d2={"applyCodeStyleAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "applyKotlinCodeStyleSetting", "", "project", "Lcom/intellij/openapi/project/Project;", "dontAskAgainAction", "notifyKotlinStyleUpdateIfNeeded", "kotlin.idea"})
public final class NewCodeStyleNotificationKt {
    public static final void notifyKotlinStyleUpdateIfNeeded(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
        if (Intrinsics.areEqual((Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults(codeStyleSettings), (Object)"KOTLIN_OFFICIAL")) {
            return;
        }
        if (((SuppressKotlinCodeStyleState)SuppressKotlinCodeStyleComponent.Companion.getInstance(project2).getState()).getDisableForAll()) {
            return;
        }
        if (Intrinsics.areEqual((Object)((Boolean)project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT)), (Object)Boolean.TRUE)) {
            NewCodeStyleNotificationKt.applyKotlinCodeStyleSetting(project2);
            return;
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Update Kotlin code style").createNotification(KotlinBundle.message("configuration.kotlin.code.style", new Object[0]), KotlinBundle.htmlMessage("configuration.notification.update.code.style.to.official", new Object[0]), NotificationType.WARNING).setSuggestionType(true).addAction((AnAction)NewCodeStyleNotificationKt.applyCodeStyleAction()).addAction((AnAction)NewCodeStyleNotificationKt.dontAskAgainAction()).setImportant(true).setIcon(KotlinIcons.SMALL_LOGO).notify(project2);
    }

    private static final NotificationAction dontAskAgainAction() {
        NotificationAction notificationAction = NotificationAction.createExpiring((String)IdeCoreBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]), (BiConsumer)dontAskAgainAction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"NotificationAction.creat\u2026 = true\n        }\n    }\n}");
        return notificationAction;
    }

    private static final NotificationAction applyCodeStyleAction() {
        NotificationAction notificationAction = NotificationAction.createExpiring((String)KotlinBundle.message("configuration.apply.new.code.style", new Object[0]), (BiConsumer)applyCodeStyleAction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"NotificationAction.creat\u2026StyleSetting(project) }\n}");
        return notificationAction;
    }

    private static final void applyKotlinCodeStyleSetting(Project project2) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(project2){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project2;
            }

            public final T compute() {
                boolean bl = false;
                ProjectCodeStyleImporter.INSTANCE.apply(this.$project$inlined, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                return (T)Unit.INSTANCE;
            }
        });
    }

    public static final /* synthetic */ void access$applyKotlinCodeStyleSetting(Project project2) {
        NewCodeStyleNotificationKt.applyKotlinCodeStyleSetting(project2);
    }
}

