/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import kotlin.KotlinVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.utils.DescriptionAware;

class JpsVersionItem
implements DescriptionAware {
    @Nullable
    private final IdeKotlinVersion myVersion;
    @NlsSafe
    @Nullable
    private final String myText;
    final boolean myEnabled;

    private JpsVersionItem(@NlsSafe @Nullable IdeKotlinVersion version2, boolean enabled2, @Nullable String text2) {
        this.myVersion = version2;
        this.myEnabled = enabled2;
        this.myText = text2;
        assert (this.myVersion != null || this.myText != null);
    }

    JpsVersionItem(@NotNull IdeKotlinVersion version2) {
        if (version2 == null) {
            JpsVersionItem.$$$reportNull$$$0(0);
        }
        this(version2, true, null);
    }

    static JpsVersionItem createLabel(@NotNull @Nls String text2) {
        if (text2 == null) {
            JpsVersionItem.$$$reportNull$$$0(1);
        }
        return new JpsVersionItem(null, false, text2);
    }

    static JpsVersionItem createFromRawVersion(@NotNull @Nls String rawVersion) {
        IdeKotlinVersion ideKotlinVersion;
        if (rawVersion == null) {
            JpsVersionItem.$$$reportNull$$$0(2);
        }
        return new JpsVersionItem(ideKotlinVersion, true, (ideKotlinVersion = IdeKotlinVersion.opt(rawVersion)) != null ? null : rawVersion);
    }

    @NotNull
    public String getDescription() {
        if (this.myVersion == null) {
            String string = Objects.requireNonNull(this.myText);
            if (string == null) {
                JpsVersionItem.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myVersion.equals(KotlinJpsPluginSettings.getBundledVersion())) {
            String string = KotlinBundle.message("configuration.text.bundled.0.jps.version", this.myVersion);
            if (string == null) {
                JpsVersionItem.$$$reportNull$$$0(4);
            }
            return string;
        }
        KotlinVersion kotlinVersion2 = this.myVersion.getKotlinVersion();
        if (kotlinVersion2.compareTo(KotlinJpsPluginSettings.getJpsMinimumSupportedVersion()) < 0 || kotlinVersion2.compareTo(KotlinJpsPluginSettings.getJpsMaximumSupportedVersion()) > 0) {
            String string = KotlinBundle.message("configuration.text.0.unsupported.jps.version", this.myVersion);
            if (string == null) {
                JpsVersionItem.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myVersion.toString();
        if (string == null) {
            JpsVersionItem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public IdeKotlinVersion getVersion() {
        return this.myVersion;
    }

    @NotNull
    public String getRawVersion() {
        String string = this.myVersion != null ? this.myVersion.getRawVersion() : Objects.requireNonNull(this.myText);
        if (string == null) {
            JpsVersionItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsVersionItem item = (JpsVersionItem)o;
        return Objects.equals(this.myVersion, item.myVersion) && Objects.equals(this.myText, item.myText);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawVersion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/JpsVersionItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/JpsVersionItem";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromRawVersion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

