/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.GetSourceModuleDependenciesKt;
import org.jetbrains.kotlin.idea.caches.project.HmppSourceModuleDependencyFilter;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.NonHmppSourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\b\u001a2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"orderEntryToModuleInfo", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "forProduction", "", "acceptAsDependency", "filterSourceModuleDependencies", "", "Lcom/intellij/openapi/module/Module;", "debugString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "dependencies", "getSourceModuleDependencies", "includeTransitiveDependencies", "resolveDependenciesFromOrderEntries", "kotlin.core"})
public final class GetSourceModuleDependenciesKt {
    @NotNull
    public static final List<IdeaModuleInfo> getSourceModuleDependencies(@NotNull Module $this$getSourceModuleDependencies, boolean forProduction, @NotNull TargetPlatform platform2, boolean includeTransitiveDependencies) {
        StringBuilder stringBuilder;
        StringBuilder debugString;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceModuleDependencies, (String)"$this$getSourceModuleDependencies");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        StringBuilder stringBuilder2 = debugString = IdeaModuleInfosKt.getLOG().isDebugEnabled() ? new StringBuilder() : null;
        if (stringBuilder2 != null) {
            StringBuilder stringBuilder3 = stringBuilder2;
            String string = "Building idea model dependencies for module " + $this$getSourceModuleDependencies + ", platform=" + platform2 + ", forProduction=" + forProduction;
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4.append('\n');
            stringBuilder = stringBuilder5;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        Set<IdeaModuleInfo> allIdeaModuleInfoDependencies = GetSourceModuleDependenciesKt.resolveDependenciesFromOrderEntries($this$getSourceModuleDependencies, debugString, forProduction, includeTransitiveDependencies);
        Set<IdeaModuleInfo> supportedModuleInfoDependencies = GetSourceModuleDependenciesKt.filterSourceModuleDependencies($this$getSourceModuleDependencies, debugString, platform2, allIdeaModuleInfoDependencies);
        StringBuilder stringBuilder6 = debugString;
        IdeaModuleInfosKt.getLOG().debug(stringBuilder6 != null ? stringBuilder6.toString() : null);
        return CollectionsKt.toList((Iterable)supportedModuleInfoDependencies);
    }

    public static /* synthetic */ List getSourceModuleDependencies$default(Module module2, boolean bl, TargetPlatform targetPlatform, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return GetSourceModuleDependenciesKt.getSourceModuleDependencies(module2, bl, targetPlatform, bl2);
    }

    private static final Set<IdeaModuleInfo> resolveDependenciesFromOrderEntries(Module $this$resolveDependenciesFromOrderEntries, StringBuilder debugString, boolean forProduction, boolean includeTransitiveDependencies) {
        StringBuilder stringBuilder;
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)$this$resolveDependenciesFromOrderEntries).orderEntries().compileOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"ModuleRootManager.getIns\u2026erEntries().compileOnly()");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (includeTransitiveDependencies) {
            dependencyEnumerator.recursively().exportedOnly();
        }
        if (forProduction && BuildSystemTypeKt.getBuildSystemType($this$resolveDependenciesFromOrderEntries) == BuildSystemType.JPS) {
            dependencyEnumerator.productionOnly();
        }
        StringBuilder stringBuilder2 = debugString;
        if (stringBuilder2 != null) {
            stringBuilder2.append("    IDEA dependencies: [");
        }
        dependencyEnumerator.forEach(new Processor($this$resolveDependenciesFromOrderEntries, debugString, forProduction, result2){
            final /* synthetic */ Module $this_resolveDependenciesFromOrderEntries;
            final /* synthetic */ StringBuilder $debugString;
            final /* synthetic */ boolean $forProduction;
            final /* synthetic */ LinkedHashSet $result;

            public final boolean process(OrderEntry orderEntry) {
                block2: {
                    block1: {
                        StringBuilder stringBuilder = this.$debugString;
                        if (stringBuilder != null) {
                            OrderEntry orderEntry2 = orderEntry;
                            Intrinsics.checkNotNullExpressionValue((Object)orderEntry2, (String)"orderEntry");
                            stringBuilder.append(orderEntry2.getPresentableName() + " ");
                        }
                        OrderEntry orderEntry3 = orderEntry;
                        Intrinsics.checkNotNullExpressionValue((Object)orderEntry3, (String)"orderEntry");
                        if (!GetSourceModuleDependenciesKt.access$acceptAsDependency(orderEntry3, this.$forProduction)) break block1;
                        Project project2 = this.$this_resolveDependenciesFromOrderEntries.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        this.$result.addAll(GetSourceModuleDependenciesKt.access$orderEntryToModuleInfo(project2, orderEntry, this.$forProduction));
                        StringBuilder stringBuilder2 = this.$debugString;
                        if (stringBuilder2 == null) break block2;
                        stringBuilder2.append("OK; ");
                        break block2;
                    }
                    StringBuilder stringBuilder = this.$debugString;
                    if (stringBuilder == null) break block2;
                    stringBuilder.append("SKIP; ");
                }
                return true;
            }
            {
                this.$this_resolveDependenciesFromOrderEntries = module2;
                this.$debugString = stringBuilder;
                this.$forProduction = bl;
                this.$result = linkedHashSet;
            }
        });
        StringBuilder stringBuilder3 = debugString;
        if (stringBuilder3 != null) {
            StringBuilder stringBuilder4 = stringBuilder3;
            String string = "]";
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            stringBuilder = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        return CollectionsKt.toSet((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<IdeaModuleInfo> filterSourceModuleDependencies(Module $this$filterSourceModuleDependencies, StringBuilder debugString, TargetPlatform platform2, Set<? extends IdeaModuleInfo> dependencies2) {
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        SourceModuleDependenciesFilter dependencyFilter = PlatformKt.isHMPPEnabled($this$filterSourceModuleDependencies) ? (SourceModuleDependenciesFilter)new HmppSourceModuleDependencyFilter(platform2) : (SourceModuleDependenciesFilter)new NonHmppSourceModuleDependenciesFilter(platform2);
        Iterable $this$filter$iv = dependencies2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdeaModuleInfo dependency = (IdeaModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!dependencyFilter.isSupportedDependency(dependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set supportedDependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        StringBuilder stringBuilder2 = debugString;
        if (stringBuilder2 != null) {
            StringBuilder stringBuilder3 = stringBuilder2;
            Object object = filterSourceModuleDependencies.1.INSTANCE;
            iterable = null;
            int n = 0;
            CharSequence charSequence = ";";
            CharSequence charSequence2 = "]";
            CharSequence charSequence3 = "[";
            object = "    Corrected result (Supported dependencies): " + CollectionsKt.joinToString$default((Iterable)supportedDependencies, (CharSequence)charSequence, (CharSequence)charSequence3, (CharSequence)charSequence2, (int)n, (CharSequence)((Object)iterable), (Function1)object, (int)24, null);
            StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4.append('\n');
            stringBuilder = stringBuilder5;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        return supportedDependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean acceptAsDependency(OrderEntry $this$acceptAsDependency, boolean forProduction) {
        if (!($this$acceptAsDependency instanceof ExportableOrderEntry)) return true;
        if (!forProduction) return true;
        if ($this$acceptAsDependency instanceof ModuleOrderEntry) {
            if (((ModuleOrderEntry)$this$acceptAsDependency).isProductionOnTestDependency()) return true;
        }
        DependencyScope dependencyScope = ((ExportableOrderEntry)$this$acceptAsDependency).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"scope");
        if (!dependencyScope.isForProductionCompile()) return false;
        return true;
    }

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project2, OrderEntry orderEntry, boolean forProduction) {
        List<Object> list2;
        var $fun$toInfos$1 = new Function1<Module, List<? extends ModuleSourceInfo>>(forProduction){
            final /* synthetic */ boolean $forProduction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $this$toInfos) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$toInfos, (String)"$this$toInfos");
                Iterable $this$filter$iv = IdeaModuleInfosKt.correspondingModuleInfos($this$toInfos);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.$forProduction || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$forProduction = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module2 = orderEntry.getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"orderEntry.getOwnerModule()");
            list2 = $fun$toInfos$1.invoke(module2);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module3 = ((ModuleOrderEntry)orderEntry).getModule();
            if (module3 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"orderEntry.module ?: return emptyList()");
            Module module4 = module3;
            list2 = forProduction && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)IdeaModuleInfosKt.testSourceInfo(module4)) : $fun$toInfos$1.invoke(module4);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library2 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"orderEntry.library ?: return listOf()");
            Library library3 = library2;
            list2 = IdeaModuleInfosKt.createLibraryInfo(project2, library3);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk2 = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk2 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"orderEntry.jdk ?: return listOf()");
            Sdk sdk3 = sdk2;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(project2, sdk3));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    public static final /* synthetic */ boolean access$acceptAsDependency(OrderEntry $this$access_u24acceptAsDependency, boolean forProduction) {
        return GetSourceModuleDependenciesKt.acceptAsDependency($this$access_u24acceptAsDependency, forProduction);
    }

    public static final /* synthetic */ List access$orderEntryToModuleInfo(Project project2, OrderEntry orderEntry, boolean forProduction) {
        return GetSourceModuleDependenciesKt.orderEntryToModuleInfo(project2, orderEntry, forProduction);
    }
}

