/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.util.IonStreamUtils;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.FilePatternSet;
import org.jetbrains.plugins.gradle.model.FilePatternSetImpl;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class ExternalProjectSerializationService
implements SerializationService<ExternalProject> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(ExternalProject project, Class<? extends ExternalProject> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            ExternalProjectSerializationService.writeProject(writer, this.myWriteContext, project);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalProject read(byte[] object, Class<? extends ExternalProject> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            DefaultExternalProject defaultExternalProject = ExternalProjectSerializationService.readProject(reader, this.myReadContext);
            return defaultExternalProject;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends ExternalProject> getModelClass() {
        return ExternalProject.class;
    }

    private static void writeProject(final IonWriter writer, final WriteContext context, final ExternalProject project) throws IOException {
        context.getProjectsCollector().add(project, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "id", project.getId());
                    ToolingStreamApiUtils.writeString(writer, "name", project.getName());
                    ToolingStreamApiUtils.writeString(writer, "qName", project.getQName());
                    ToolingStreamApiUtils.writeString(writer, "description", project.getDescription());
                    ToolingStreamApiUtils.writeString(writer, "group", project.getGroup());
                    ToolingStreamApiUtils.writeString(writer, "version", project.getVersion());
                    ToolingStreamApiUtils.writeString(writer, "sourceCompatibility", project.getSourceCompatibility());
                    ToolingStreamApiUtils.writeString(writer, "targetCompatibility", project.getTargetCompatibility());
                    ToolingStreamApiUtils.writeString(writer, "projectDir", project.getProjectDir().getPath());
                    ToolingStreamApiUtils.writeString(writer, "buildDir", project.getBuildDir().getPath());
                    ToolingStreamApiUtils.writeFile(writer, "buildFile", project.getBuildFile());
                    ExternalProjectSerializationService.writeTasks(writer, project.getTasks());
                    ExternalProjectSerializationService.writeSourceSets(writer, context, project.getSourceSets());
                    ToolingStreamApiUtils.writeFiles(writer, "artifacts", project.getArtifacts());
                    ExternalProjectSerializationService.writeArtifactsByConfiguration(writer, project.getArtifactsByConfiguration());
                    ExternalProjectSerializationService.writeChildProjects(writer, context, project.getChildProjects());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeChildProjects(IonWriter writer, WriteContext context, Map<String, ? extends ExternalProject> projects) throws IOException {
        writer.setFieldName("childProjects");
        writer.stepIn(IonType.LIST);
        for (ExternalProject externalProject : projects.values()) {
            ExternalProjectSerializationService.writeProject(writer, context, externalProject);
        }
        writer.stepOut();
    }

    private static void writeSourceSets(IonWriter writer, WriteContext context, Map<String, ? extends ExternalSourceSet> sets) throws IOException {
        writer.setFieldName("sourceSets");
        writer.stepIn(IonType.LIST);
        for (ExternalSourceSet externalSourceSet : sets.values()) {
            ExternalProjectSerializationService.writeSourceSet(writer, context, externalSourceSet);
        }
        writer.stepOut();
    }

    private static void writeSourceSet(IonWriter writer, WriteContext context, ExternalSourceSet sourceSet) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "name", sourceSet.getName());
        ToolingStreamApiUtils.writeString(writer, "sourceCompatibility", sourceSet.getSourceCompatibility());
        ToolingStreamApiUtils.writeString(writer, "targetCompatibility", sourceSet.getTargetCompatibility());
        ToolingStreamApiUtils.writeBoolean(writer, "isPreview", sourceSet.isPreview());
        ToolingStreamApiUtils.writeFiles(writer, "artifacts", sourceSet.getArtifacts());
        ExternalProjectSerializationService.writeDependencies(writer, context, sourceSet.getDependencies());
        ExternalProjectSerializationService.writeSourceDirectorySets(writer, sourceSet.getSources());
        writer.stepOut();
    }

    private static void writeSourceDirectorySets(IonWriter writer, Map<? extends IExternalSystemSourceType, ? extends ExternalSourceDirectorySet> sources) throws IOException {
        writer.setFieldName("sources");
        writer.stepIn(IonType.LIST);
        for (Map.Entry<? extends IExternalSystemSourceType, ? extends ExternalSourceDirectorySet> entry : sources.entrySet()) {
            ExternalProjectSerializationService.writeSourceDirectorySet(writer, entry.getKey(), entry.getValue());
        }
        writer.stepOut();
    }

    private static void writeSourceDirectorySet(IonWriter writer, IExternalSystemSourceType sourceType, ExternalSourceDirectorySet directorySet) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "sourceType", ExternalSystemSourceType.from((IExternalSystemSourceType)sourceType).name());
        ToolingStreamApiUtils.writeString(writer, "name", directorySet.getName());
        ToolingStreamApiUtils.writeFiles(writer, "srcDirs", directorySet.getSrcDirs());
        ToolingStreamApiUtils.writeFiles(writer, "gradleOutputDirs", directorySet.getGradleOutputDirs());
        ToolingStreamApiUtils.writeFile(writer, "outputDir", directorySet.getOutputDir());
        writer.setFieldName("inheritedCompilerOutput");
        writer.writeBool(directorySet.isCompilerOutputPathInherited());
        ExternalProjectSerializationService.writePatterns(writer, directorySet.getPatterns());
        ExternalProjectSerializationService.writeFilters(writer, directorySet.getFilters());
        writer.stepOut();
    }

    private static void writeFilters(IonWriter writer, List<? extends ExternalFilter> filters) throws IOException {
        writer.setFieldName("filters");
        writer.stepIn(IonType.LIST);
        for (ExternalFilter externalFilter : filters) {
            ExternalProjectSerializationService.writeFilter(writer, externalFilter);
        }
        writer.stepOut();
    }

    private static void writeFilter(IonWriter writer, ExternalFilter filter) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "filterType", filter.getFilterType());
        ToolingStreamApiUtils.writeString(writer, "propertiesAsJsonMap", filter.getPropertiesAsJsonMap());
        writer.stepOut();
    }

    private static void writePatterns(IonWriter writer, FilePatternSet patterns) throws IOException {
        writer.setFieldName("patterns");
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName("includes");
        IonStreamUtils.writeStringList((IonWriter)writer, (String[])patterns.getIncludes().toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        writer.setFieldName("excludes");
        IonStreamUtils.writeStringList((IonWriter)writer, (String[])patterns.getExcludes().toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        writer.stepOut();
    }

    private static void writeDependencies(IonWriter writer, WriteContext context, Collection<ExternalDependency> dependencies) throws IOException {
        writer.setFieldName("dependencies");
        writer.stepIn(IonType.LIST);
        for (ExternalDependency dependency : dependencies) {
            ExternalProjectSerializationService.writeDependency(writer, context, dependency);
        }
        writer.stepOut();
    }

    static void writeDependency(IonWriter writer, WriteContext context, ExternalDependency dependency) throws IOException {
        if (dependency instanceof ExternalLibraryDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalLibraryDependency)dependency);
        } else if (dependency instanceof ExternalMultiLibraryDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalMultiLibraryDependency)dependency);
        } else if (dependency instanceof ExternalProjectDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalProjectDependency)dependency);
        } else if (dependency instanceof FileCollectionDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (FileCollectionDependency)dependency);
        } else if (dependency instanceof UnresolvedExternalDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (UnresolvedExternalDependency)dependency);
        }
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalLibraryDependency dependency) throws IOException {
        context.getDependenciesCollector().add((ExternalDependency)dependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalLibraryDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFile(writer, "file", dependency.getFile());
                    ToolingStreamApiUtils.writeFile(writer, "source", dependency.getSource());
                    ToolingStreamApiUtils.writeFile(writer, "javadoc", dependency.getJavadoc());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalMultiLibraryDependency dependency) throws IOException {
        context.getDependenciesCollector().add((ExternalDependency)dependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalMultiLibraryDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFiles(writer, "files", dependency.getFiles());
                    ToolingStreamApiUtils.writeFiles(writer, "sources", dependency.getSources());
                    ToolingStreamApiUtils.writeFiles(writer, "javadocs", dependency.getJavadoc());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalProjectDependency dependency) throws IOException {
        context.getDependenciesCollector().add((ExternalDependency)dependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalProjectDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeString(writer, "projectPath", dependency.getProjectPath());
                    ToolingStreamApiUtils.writeString(writer, "configurationName", dependency.getConfigurationName());
                    ToolingStreamApiUtils.writeFiles(writer, "projectDependencyArtifacts", dependency.getProjectDependencyArtifacts());
                    ToolingStreamApiUtils.writeFiles(writer, "projectDependencyArtifactsSources", dependency.getProjectDependencyArtifactsSources());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final FileCollectionDependency dependency) throws IOException {
        context.getDependenciesCollector().add((ExternalDependency)dependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(FileCollectionDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFiles(writer, "files", dependency.getFiles());
                    if (dependency instanceof DefaultFileCollectionDependency) {
                        ToolingStreamApiUtils.writeBoolean(writer, "excludedFromIndexing", ((DefaultFileCollectionDependency)dependency).isExcludedFromIndexing());
                    }
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final UnresolvedExternalDependency dependency) throws IOException {
        context.getDependenciesCollector().add((ExternalDependency)dependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(UnresolvedExternalDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeString(writer, "failureMessage", dependency.getFailureMessage());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyCommonFields(IonWriter writer, WriteContext context, ExternalDependency dependency) throws IOException {
        ExternalDependencyId id = dependency.getId();
        writer.setFieldName("id");
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "group", id.getGroup());
        ToolingStreamApiUtils.writeString(writer, "name", id.getName());
        ToolingStreamApiUtils.writeString(writer, "version", id.getVersion());
        ToolingStreamApiUtils.writeString(writer, "packaging", id.getPackaging());
        ToolingStreamApiUtils.writeString(writer, "classifier", id.getClassifier());
        writer.stepOut();
        ToolingStreamApiUtils.writeString(writer, "scope", dependency.getScope());
        ToolingStreamApiUtils.writeString(writer, "selectionReason", dependency.getSelectionReason());
        writer.setFieldName("classpathOrder");
        writer.writeInt((long)dependency.getClasspathOrder());
        writer.setFieldName("exported");
        writer.writeBool(dependency.getExported());
        ExternalProjectSerializationService.writeDependencies(writer, context, dependency.getDependencies());
    }

    private static void writeTasks(IonWriter writer, Map<String, ? extends ExternalTask> tasks) throws IOException {
        writer.setFieldName("tasks");
        writer.stepIn(IonType.LIST);
        for (ExternalTask externalTask : tasks.values()) {
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeString(writer, "name", externalTask.getName());
            ToolingStreamApiUtils.writeString(writer, "qName", externalTask.getQName());
            ToolingStreamApiUtils.writeString(writer, "description", externalTask.getDescription());
            ToolingStreamApiUtils.writeString(writer, "group", externalTask.getGroup());
            ToolingStreamApiUtils.writeString(writer, "type", externalTask.getType());
            writer.setFieldName("isTest");
            writer.writeBool(externalTask.isTest());
            writer.stepOut();
        }
        writer.stepOut();
    }

    private static void writeArtifactsByConfiguration(final IonWriter writer, Map<String, Set<File>> configuration) throws IOException {
        ToolingStreamApiUtils.writeMap(writer, "artifactsByConfiguration", configuration, new ThrowableConsumer<String, IOException>(){

            public void consume(String s) throws IOException {
                writer.writeString(s);
            }
        }, new ThrowableConsumer<Set<File>, IOException>(){

            public void consume(Set<File> files) throws IOException {
                ToolingStreamApiUtils.writeFiles(writer, "value", files);
            }
        });
    }

    @Nullable
    private static DefaultExternalProject readProject(final @NotNull IonReader reader, final @NotNull ReadContext context) {
        if (reader == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(1);
        }
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalProject project = (DefaultExternalProject)context.getProjectsMap().computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<DefaultExternalProject>(){

            public DefaultExternalProject newInstance() {
                return new DefaultExternalProject();
            }

            public void fill(DefaultExternalProject externalProject) {
                File buildFile;
                File buildDir;
                externalProject.setExternalSystemId("GRADLE");
                externalProject.setId(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "id")));
                externalProject.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name")));
                externalProject.setQName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "qName")));
                externalProject.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                externalProject.setGroup(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "group")));
                externalProject.setVersion(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "version")));
                externalProject.setSourceCompatibility(ToolingStreamApiUtils.readString(reader, "sourceCompatibility"));
                externalProject.setTargetCompatibility(ToolingStreamApiUtils.readString(reader, "targetCompatibility"));
                File projectDir = ToolingStreamApiUtils.readFile(reader, "projectDir");
                if (projectDir != null) {
                    externalProject.setProjectDir(projectDir);
                }
                if ((buildDir = ToolingStreamApiUtils.readFile(reader, "buildDir")) != null) {
                    externalProject.setBuildDir(buildDir);
                }
                if ((buildFile = ToolingStreamApiUtils.readFile(reader, "buildFile")) != null) {
                    externalProject.setBuildFile(buildFile);
                }
                ExternalProjectSerializationService.readTasks(reader, externalProject);
                ExternalProjectSerializationService.readSourceSets(reader, context, externalProject);
                externalProject.setArtifacts(ToolingStreamApiUtils.readFiles(reader));
                externalProject.setArtifactsByConfiguration(ToolingStreamApiUtils.readStringToFileSetMap(reader));
                externalProject.setChildProjects(ExternalProjectSerializationService.readProjects(reader, context));
            }
        });
        reader.stepOut();
        return project;
    }

    private static Map<String, DefaultExternalProject> readProjects(@NotNull IonReader reader, @NotNull ReadContext context) {
        DefaultExternalProject project;
        if (reader == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(3);
        }
        TreeMap<String, DefaultExternalProject> map = new TreeMap<String, DefaultExternalProject>();
        reader.next();
        reader.stepIn();
        while ((project = ExternalProjectSerializationService.readProject(reader, context)) != null) {
            map.put(project.getName(), project);
        }
        reader.stepOut();
        return map;
    }

    private static void readTasks(IonReader reader, DefaultExternalProject project) {
        DefaultExternalTask task;
        reader.next();
        reader.stepIn();
        HashMap<String, DefaultExternalTask> tasks = new HashMap<String, DefaultExternalTask>();
        while ((task = ExternalProjectSerializationService.readTask(reader)) != null) {
            tasks.put(task.getName(), task);
        }
        project.setTasks(tasks);
        reader.stepOut();
    }

    @Nullable
    private static DefaultExternalTask readTask(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalTask task = new DefaultExternalTask();
        task.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name")));
        task.setQName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "qName")));
        task.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
        task.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
        task.setType(ToolingStreamApiUtils.readString(reader, "type"));
        task.setTest(ToolingStreamApiUtils.readBoolean(reader, "isTest"));
        reader.stepOut();
        return task;
    }

    private static void readSourceSets(IonReader reader, ReadContext context, DefaultExternalProject project) {
        DefaultExternalSourceSet sourceSet;
        reader.next();
        reader.stepIn();
        HashMap<String, DefaultExternalSourceSet> sourceSets = new HashMap<String, DefaultExternalSourceSet>();
        while ((sourceSet = ExternalProjectSerializationService.readSourceSet(reader, context)) != null) {
            sourceSets.put(sourceSet.getName(), sourceSet);
        }
        project.setSourceSets(sourceSets);
        reader.stepOut();
    }

    @Nullable
    private static DefaultExternalSourceSet readSourceSet(IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalSourceSet sourceSet = new DefaultExternalSourceSet();
        sourceSet.setName(ToolingStreamApiUtils.readString(reader, "name"));
        sourceSet.setSourceCompatibility(ToolingStreamApiUtils.readString(reader, "sourceCompatibility"));
        sourceSet.setTargetCompatibility(ToolingStreamApiUtils.readString(reader, "targetCompatibility"));
        sourceSet.setPreview(ToolingStreamApiUtils.readBoolean(reader, "isPreview"));
        sourceSet.setArtifacts(ToolingStreamApiUtils.readFiles(reader));
        sourceSet.getDependencies().addAll(ExternalProjectSerializationService.readDependencies(reader, context));
        sourceSet.setSources(ExternalProjectSerializationService.readSourceDirectorySets(reader));
        reader.stepOut();
        return sourceSet;
    }

    private static Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> readSourceDirectorySets(IonReader reader) {
        Map.Entry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> entry;
        reader.next();
        reader.stepIn();
        HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> map = new HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>();
        while ((entry = ExternalProjectSerializationService.readSourceDirectorySet(reader)) != null) {
            map.put(entry.getKey(), entry.getValue());
        }
        reader.stepOut();
        return map;
    }

    @Nullable
    private static Map.Entry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> readSourceDirectorySet(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalSystemSourceType sourceType = ExternalSystemSourceType.valueOf((String)ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "sourceType")));
        DefaultExternalSourceDirectorySet directorySet = new DefaultExternalSourceDirectorySet();
        directorySet.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name")));
        directorySet.setSrcDirs(ToolingStreamApiUtils.readFilesSet(reader));
        directorySet.getGradleOutputDirs().addAll(ToolingStreamApiUtils.readFiles(reader));
        File outputDir = ToolingStreamApiUtils.readFile(reader, "outputDir");
        if (outputDir != null) {
            directorySet.setOutputDir(outputDir);
        }
        directorySet.setInheritedCompilerOutput(ToolingStreamApiUtils.readBoolean(reader, "inheritedCompilerOutput"));
        FilePatternSet patternSet = ExternalProjectSerializationService.readFilePattern(reader);
        directorySet.setExcludes(patternSet.getExcludes());
        directorySet.setIncludes(patternSet.getIncludes());
        directorySet.setFilters(ExternalProjectSerializationService.readFilters(reader));
        reader.stepOut();
        return new AbstractMap.SimpleEntry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>(sourceType, directorySet);
    }

    private static List<DefaultExternalFilter> readFilters(IonReader reader) {
        DefaultExternalFilter filter;
        reader.next();
        reader.stepIn();
        ArrayList<DefaultExternalFilter> list = new ArrayList<DefaultExternalFilter>();
        while ((filter = ExternalProjectSerializationService.readFilter(reader)) != null) {
            list.add(filter);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultExternalFilter readFilter(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        DefaultExternalFilter filter = new DefaultExternalFilter();
        reader.stepIn();
        filter.setFilterType(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "filterType")));
        filter.setPropertiesAsJsonMap(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "propertiesAsJsonMap")));
        reader.stepOut();
        return filter;
    }

    private static FilePatternSet readFilePattern(IonReader reader) {
        reader.next();
        reader.stepIn();
        FilePatternSetImpl patternSet = new FilePatternSetImpl();
        patternSet.setIncludes(ToolingStreamApiUtils.readStringSet(reader));
        patternSet.setExcludes(ToolingStreamApiUtils.readStringSet(reader));
        reader.stepOut();
        return patternSet;
    }

    private static Collection<? extends ExternalDependency> readDependencies(IonReader reader, ReadContext context) {
        ExternalDependency dependency;
        ArrayList<ExternalDependency> dependencies = new ArrayList<ExternalDependency>();
        reader.next();
        reader.stepIn();
        while ((dependency = ExternalProjectSerializationService.readDependency(reader, context)) != null) {
            dependencies.add(dependency);
        }
        reader.stepOut();
        return dependencies;
    }

    static ExternalDependency readDependency(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalDependency dependency = (ExternalDependency)context.getDependenciesMap().computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<AbstractExternalDependency>(){

            public AbstractExternalDependency newInstance() {
                String type = ToolingStreamApiUtils.readString(reader, "_type");
                if (ExternalLibraryDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalLibraryDependency();
                }
                if (ExternalMultiLibraryDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalMultiLibraryDependency();
                }
                if (ExternalProjectDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalProjectDependency();
                }
                if (FileCollectionDependency.class.getSimpleName().equals(type)) {
                    return new DefaultFileCollectionDependency();
                }
                if (UnresolvedExternalDependency.class.getSimpleName().equals(type)) {
                    return new DefaultUnresolvedExternalDependency();
                }
                throw new RuntimeException("Unsupported dependency");
            }

            public void fill(AbstractExternalDependency externalDependency) {
                ExternalProjectSerializationService.readDependencyCommonFields(reader, context, externalDependency);
                if (externalDependency instanceof DefaultExternalLibraryDependency) {
                    DefaultExternalLibraryDependency libraryDependency = (DefaultExternalLibraryDependency)externalDependency;
                    libraryDependency.setFile(ToolingStreamApiUtils.readFile(reader, "file"));
                    libraryDependency.setSource(ToolingStreamApiUtils.readFile(reader, "source"));
                    libraryDependency.setJavadoc(ToolingStreamApiUtils.readFile(reader, "javadoc"));
                } else if (externalDependency instanceof DefaultExternalMultiLibraryDependency) {
                    DefaultExternalMultiLibraryDependency multiLibraryDependency = (DefaultExternalMultiLibraryDependency)externalDependency;
                    multiLibraryDependency.getFiles().addAll(ToolingStreamApiUtils.readFiles(reader));
                    multiLibraryDependency.getSources().addAll(ToolingStreamApiUtils.readFiles(reader));
                    multiLibraryDependency.getJavadoc().addAll(ToolingStreamApiUtils.readFiles(reader));
                } else if (externalDependency instanceof DefaultExternalProjectDependency) {
                    DefaultExternalProjectDependency projectDependency = (DefaultExternalProjectDependency)externalDependency;
                    projectDependency.setProjectPath(ToolingStreamApiUtils.readString(reader, "projectPath"));
                    projectDependency.setConfigurationName(ToolingStreamApiUtils.readString(reader, "configurationName"));
                    projectDependency.setProjectDependencyArtifacts(ToolingStreamApiUtils.readFiles(reader));
                    projectDependency.setProjectDependencyArtifactsSources(ToolingStreamApiUtils.readFiles(reader));
                } else if (externalDependency instanceof DefaultFileCollectionDependency) {
                    DefaultFileCollectionDependency fileCollectionDependency = (DefaultFileCollectionDependency)externalDependency;
                    fileCollectionDependency.getFiles().addAll(ToolingStreamApiUtils.readFiles(reader));
                    fileCollectionDependency.setExcludedFromIndexing(ToolingStreamApiUtils.readBoolean(reader, "excludedFromIndexing"));
                } else if (externalDependency instanceof DefaultUnresolvedExternalDependency) {
                    DefaultUnresolvedExternalDependency unresolvedExternalDependency = (DefaultUnresolvedExternalDependency)externalDependency;
                    unresolvedExternalDependency.setFailureMessage(ToolingStreamApiUtils.readString(reader, "failureMessage"));
                } else {
                    throw new RuntimeException("Unsupported dependency type: " + externalDependency.getClass().getName());
                }
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static void readDependencyCommonFields(IonReader reader, ReadContext context, AbstractExternalDependency dependency) {
        ExternalProjectSerializationService.readDependencyId(reader, dependency);
        dependency.setScope(ToolingStreamApiUtils.readString(reader, "scope"));
        dependency.setSelectionReason(ToolingStreamApiUtils.readString(reader, "selectionReason"));
        dependency.setClasspathOrder(ToolingStreamApiUtils.readInt(reader, "classpathOrder"));
        dependency.setExported(ToolingStreamApiUtils.readBoolean(reader, "exported"));
        dependency.getDependencies().addAll(ExternalProjectSerializationService.readDependencies(reader, context));
    }

    private static void readDependencyId(IonReader reader, AbstractExternalDependency dependency) {
        DefaultExternalDependencyId id = (DefaultExternalDependencyId)dependency.getId();
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "id");
        reader.stepIn();
        id.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
        id.setName(ToolingStreamApiUtils.readString(reader, "name"));
        id.setVersion(ToolingStreamApiUtils.readString(reader, "version"));
        id.setPackaging(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "packaging")));
        id.setClassifier(ToolingStreamApiUtils.readString(reader, "classifier"));
        reader.stepOut();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ExternalProjectSerializationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readProjects";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WriteContext {
        private final ObjectCollector<ExternalProject, IOException> myProjectsCollector = new ObjectCollector();
        private final ObjectCollector<ExternalDependency, IOException> myDependenciesCollector = new ObjectCollector();

        public ObjectCollector<ExternalProject, IOException> getProjectsCollector() {
            return this.myProjectsCollector;
        }

        public ObjectCollector<ExternalDependency, IOException> getDependenciesCollector() {
            return this.myDependenciesCollector;
        }
    }

    public static class ReadContext {
        private final IntObjectMap<DefaultExternalProject> myProjectsMap = new IntObjectMap();
        private final IntObjectMap<AbstractExternalDependency> myDependenciesMap = new IntObjectMap();

        public IntObjectMap<DefaultExternalProject> getProjectsMap() {
            return this.myProjectsMap;
        }

        public IntObjectMap<AbstractExternalDependency> getDependenciesMap() {
            return this.myDependenciesMap;
        }
    }
}

