/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.JVMTIThreadState;
import com.jetbrains.sa.jdi.JvmUtils;
import com.jetbrains.sa.jdi.MonitorInfoImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.StackFrameImpl;
import com.jetbrains.sa.jdi.ThreadGroupReferenceImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.utilities.Assert;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements JVMTIThreadState {
    private final JavaThread myJavaThread;
    private ArrayList<StackFrameImpl> frames;
    private List<ObjectReferenceImpl> ownedMonitors;
    private List<MonitorInfoImpl> ownedMonitorsInfo;
    private ObjectReferenceImpl currentContendingMonitor;

    ThreadReferenceImpl(ReferenceTypeImpl type, Instance oRef) {
        super(type, (Oop)oRef);
        this.myJavaThread = OopUtilities.threadOopGetJavaThread((Oop)oRef);
    }

    JavaThread getJavaThread() {
        return this.myJavaThread;
    }

    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    public String name() {
        return OopUtilities.threadOopGetName((Oop)this.ref());
    }

    public int suspendCount() {
        return 1;
    }

    public int status() {
        int state = OopUtilities.threadOopGetThreadStatus((Oop)this.ref());
        if ((state & 1) == 0) {
            if ((state & 2) != 0) {
                return 0;
            }
            return 5;
        }
        if ((state & 0x40) != 0) {
            return 2;
        }
        if ((state & 0x400) != 0) {
            return 3;
        }
        if ((state & 0x80) != 0) {
            return 4;
        }
        if ((state & 4) != 0) {
            return 1;
        }
        return -1;
    }

    public ThreadGroupReferenceImpl threadGroup() {
        return this.vm().threadGroupMirror((Instance)OopUtilities.threadOopGetThreadGroup((Oop)this.ref()));
    }

    public int frameCount() throws IncompatibleThreadStateException {
        this.privateFrames(0, -1);
        return this.frames.size();
    }

    public List<StackFrameImpl> frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    public StackFrameImpl frame(int index) throws IncompatibleThreadStateException {
        return this.privateFrames(index, 1).get(0);
    }

    public List<StackFrameImpl> privateFrames(int start, int length) throws IncompatibleThreadStateException {
        List<StackFrameImpl> retVal;
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.frames == null) {
            this.frames = new ArrayList(10);
            JavaVFrame myvf = this.myJavaThread.getLastJavaVFrameDbg();
            int id = 0;
            while (myvf != null) {
                StackFrameImpl myFrame = new StackFrameImpl(this, myvf, id++);
                this.frames.add(myFrame);
                myvf = JvmUtils.getFrameJavaSender(myvf);
            }
        }
        if (this.frames.size() == 0) {
            return Collections.emptyList();
        }
        if (start == 0 && length == -1) {
            retVal = this.frames;
        } else {
            int toIndex = length == -1 ? this.frames.size() : start + length;
            retVal = this.frames.subList(start, toIndex);
        }
        return Collections.unmodifiableList(retVal);
    }

    public List<ObjectReferenceImpl> ownedMonitors() throws IncompatibleThreadStateException {
        if (!this.vm().canGetOwnedMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.ownedMonitors != null) {
            return this.ownedMonitors;
        }
        this.ownedMonitorsWithStackDepth();
        for (MonitorInfoImpl monitorInfo : this.ownedMonitorsInfo) {
            this.ownedMonitors.add(monitorInfo.monitor());
        }
        return this.ownedMonitors;
    }

    public List<MonitorInfoImpl> ownedMonitorsAndFrames() throws IncompatibleThreadStateException {
        if (!this.vm().canGetMonitorFrameInfo()) {
            throw new UnsupportedOperationException("target does not support getting Monitor Frame Info");
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        if (this.ownedMonitorsInfo != null) {
            return this.ownedMonitorsInfo;
        }
        this.ownedMonitorsWithStackDepth();
        return this.ownedMonitorsInfo;
    }

    private void ownedMonitorsWithStackDepth() {
        this.ownedMonitorsInfo = new ArrayList<MonitorInfoImpl>();
        ArrayList<OopHandle> lockedObjects = new ArrayList<OopHandle>();
        ArrayList<Integer> stackDepth = new ArrayList<Integer>();
        ObjectMonitor waitingMonitor = this.myJavaThread.getCurrentWaitingMonitor();
        ObjectMonitor pendingMonitor = this.myJavaThread.getCurrentPendingMonitor();
        OopHandle waitingObj = null;
        if (waitingMonitor != null) {
            waitingObj = waitingMonitor.object();
        }
        OopHandle pendingObj = null;
        if (pendingMonitor != null) {
            pendingObj = pendingMonitor.object();
        }
        JavaVFrame frame = this.myJavaThread.getLastJavaVFrameDbg();
        int depth = 0;
        while (frame != null) {
            for (Object frameMonitor : JvmUtils.getFrameMonitors(frame)) {
                OopHandle obj;
                MonitorInfo mi = (MonitorInfo)frameMonitor;
                if (mi.eliminated() && frame.isCompiledFrame() || (obj = mi.owner()) == null || obj.equals(waitingObj) || obj.equals(pendingObj)) continue;
                boolean found = false;
                for (OopHandle lockedObject : lockedObjects) {
                    if (!obj.equals(lockedObject)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lockedObjects.add(obj);
                stackDepth.add(depth);
            }
            frame = JvmUtils.getFrameJavaSender(frame);
            ++depth;
        }
        ObjectHeap heap = this.vm().saObjectHeap();
        Iterator stk = stackDepth.iterator();
        for (OopHandle lockedObject : lockedObjects) {
            this.ownedMonitorsInfo.add(new MonitorInfoImpl(this.vm().objectMirror(lockedObject), this, (Integer)stk.next()));
        }
    }

    public ObjectReferenceImpl currentContendedMonitor() throws IncompatibleThreadStateException {
        if (!this.vm().canGetCurrentContendedMonitor()) {
            throw new UnsupportedOperationException();
        }
        if (this.myJavaThread == null) {
            throw new IncompatibleThreadStateException();
        }
        ObjectMonitor mon = this.myJavaThread.getCurrentWaitingMonitor();
        if (mon == null) {
            mon = this.myJavaThread.getCurrentPendingMonitor();
            if (mon != null) {
                OopHandle handle = mon.object();
                return this.vm().objectMirror(handle);
            }
            return null;
        }
        OopHandle handle = mon.object();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((handle != null ? 1 : 0) != 0, (String)"Object.wait() should have an object");
        }
        return this.vm().objectMirror(handle);
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 116;
    }
}

