/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ManualVariance;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.VarianceConflictDiagnosticData;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.EnrichedProjectionKind;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001eJ\u001c\u0010\"\u001a\u00020\u0012*\u00020#2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002J#\u0010&\u001a\u0004\u0018\u00010\u0012*\u00020'2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010(\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010)J\"\u0010&\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010(\u001a\u00020%H\u0002J\f\u0010.\u001a\u00020%*\u00020/H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/VarianceCheckerCore;", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "diagnosticSink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "manualVariance", "Lorg/jetbrains/kotlin/resolve/ManualVariance;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/resolve/ManualVariance;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkCallableDeclaration", "", "trace", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkClassHeader", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkClasses", "checkMember", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkMembers", "isIrrelevant", "recordPrivateToThisIfNeeded", "checkTypeParameters", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "Lorg/jetbrains/kotlin/types/Variance;", "checkTypePosition", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lcom/intellij/psi/PsiElement;", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "varianceWithManual", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Companion", "frontend"})
public final class VarianceCheckerCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingContext context;
    @NotNull
    private final DiagnosticSink diagnosticSink;
    @Nullable
    private final ManualVariance manualVariance;
    @Nullable
    private final LanguageVersionSettings languageVersionSettings;

    public VarianceCheckerCore(@NotNull BindingContext context, @NotNull DiagnosticSink diagnosticSink, @Nullable ManualVariance manualVariance, @Nullable LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)diagnosticSink, (String)"diagnosticSink");
        this.context = context;
        this.diagnosticSink = diagnosticSink;
        this.manualVariance = manualVariance;
        this.languageVersionSettings = languageVersionSettings;
    }

    public /* synthetic */ VarianceCheckerCore(BindingContext bindingContext, DiagnosticSink diagnosticSink, ManualVariance manualVariance, LanguageVersionSettings languageVersionSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            manualVariance = null;
        }
        if ((n & 8) != 0) {
            languageVersionSettings = null;
        }
        this(bindingContext, diagnosticSink, manualVariance, languageVersionSettings);
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map = c.getDeclaredClasses();
        Intrinsics.checkNotNull(map);
        for (KtClassOrObject classOrObject : map.keySet()) {
            if (!(classOrObject instanceof KtClass)) continue;
            this.checkClassHeader((KtClass)classOrObject);
        }
    }

    public final boolean checkClassHeader(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        boolean noError = true;
        for (KtSuperTypeListEntry specifier : klass.getSuperTypeListEntries()) {
            KtTypeReference ktTypeReference = specifier.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, this.context, Variance.OUT_VARIANCE) : null);
        }
        return noError & this.checkTypeParameters((KtTypeParameterListOwner)klass, this.context, Variance.OUT_VARIANCE);
    }

    private final void checkMembers(TopDownAnalysisContext c) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> map = c.getMembers();
        Intrinsics.checkNotNullExpressionValue(map, (String)"c.members");
        for (Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry : map.entrySet()) {
            KtCallableDeclaration declaration = entry.getKey();
            CallableMemberDescriptor descriptor2 = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
            this.checkMember(declaration, descriptor2);
        }
    }

    public final boolean checkMember(@NotNull KtCallableDeclaration member2, @NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DescriptorVisibilities.isPrivate(descriptor2.getVisibility()) || this.checkCallableDeclaration(this.context, member2, descriptor2);
    }

    private final Variance varianceWithManual(TypeParameterDescriptor $this$varianceWithManual) {
        Variance variance;
        if (this.manualVariance != null && Intrinsics.areEqual((Object)$this$varianceWithManual.getOriginal(), (Object)this.manualVariance.getDescriptor())) {
            variance = this.manualVariance.getVariance();
        } else {
            Variance variance2 = $this$varianceWithManual.getVariance();
            variance = variance2;
            Intrinsics.checkNotNullExpressionValue((Object)variance2, (String)"variance");
        }
        return variance;
    }

    public final void recordPrivateToThisIfNeeded(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.isIrrelevant(descriptor2) || !Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return;
        }
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration psiElement2 = ktCallableDeclaration;
        if (!this.checkCallableDeclaration(this.context, psiElement2, descriptor2)) {
            VarianceCheckerCore.Companion.recordPrivateToThis(descriptor2);
        }
    }

    private final boolean checkCallableDeclaration(BindingContext trace, KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        if (this.isIrrelevant(descriptor2)) {
            return true;
        }
        boolean noError = true;
        noError &= this.checkTypeParameters((KtTypeParameterListOwner)declaration, trace, Variance.IN_VARIANCE);
        KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
        noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, Variance.IN_VARIANCE) : null);
        for (KtParameter parameter : declaration.getValueParameters()) {
            KtTypeReference ktTypeReference2 = parameter.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference2 != null ? this.checkTypePosition(ktTypeReference2, trace, Variance.IN_VARIANCE) : null);
        }
        Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration, trace);
        noError = VarianceCheckerCore.Companion.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition)) : null);
        return noError;
    }

    private final boolean checkTypeParameters(KtTypeParameterListOwner $this$checkTypeParameters, BindingContext trace, Variance typePosition) {
        boolean noError = true;
        for (KtTypeParameter typeParameter : $this$checkTypeParameters.getTypeParameters()) {
            KtTypeReference ktTypeReference = typeParameter.getExtendsBound();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        for (KtTypeConstraint typeConstraint : $this$checkTypeParameters.getTypeConstraints()) {
            KtTypeReference ktTypeReference = typeConstraint.getBoundTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        return noError;
    }

    private final Boolean checkTypePosition(KtTypeReference $this$checkTypePosition, BindingContext trace, Variance position) {
        TypeBinding<KtTypeElement> typeBinding = TypeBindingKt.createTypeBinding($this$checkTypePosition, trace);
        return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position)) : null;
    }

    private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $this$checkTypePosition, Variance position) {
        return this.checkTypePosition($this$checkTypePosition, $this$checkTypePosition.getType(), position);
    }

    private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $this$checkTypePosition, KotlinType containingType, Variance position) {
        ClassifierDescriptor classifierDescriptor = $this$checkTypePosition.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Variance declarationVariance = this.varianceWithManual((TypeParameterDescriptor)classifierDescriptor);
            if (!declarationVariance.allowsPosition(position) && !$this$checkTypePosition.getType().getAnnotations().hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
                VarianceConflictDiagnosticData varianceConflictDiagnosticData = new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position);
                if ($this$checkTypePosition.isArgumentFromQualifier()) {
                    LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
                    if (languageVersionSettings == null) {
                        languageVersionSettings = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
                    }
                    this.diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on(languageVersionSettings, $this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                } else if ($this$checkTypePosition.isInAbbreviation()) {
                    this.diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE.on($this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                } else {
                    this.diagnosticSink.report(((DiagnosticFactory1)((Object)Errors.TYPE_VARIANCE_CONFLICT.getErrorFactory())).on($this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                }
            }
            return declarationVariance.allowsPosition(position);
        }
        boolean noError = true;
        Iterator<TypeArgumentBinding<? extends PsiElement>> iterator2 = $this$checkTypePosition.getArguments().iterator();
        while (iterator2.hasNext()) {
            Variance newPosition;
            Variance variance;
            TypeArgumentBinding<? extends PsiElement> argument2;
            TypeArgumentBinding<? extends PsiElement> typeArgumentBinding = argument2 = iterator2.next();
            if ((typeArgumentBinding != null ? typeArgumentBinding.getTypeParameter() : null) == null || argument2.getProjection().isStarProjection()) continue;
            TypeParameterDescriptor typeParameterDescriptor = argument2.getTypeParameter();
            Intrinsics.checkNotNull((Object)typeParameterDescriptor);
            EnrichedProjectionKind enrichedProjectionKind = TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argument2.getProjection());
            Intrinsics.checkNotNull((Object)enrichedProjectionKind);
            switch (WhenMappings.$EnumSwitchMapping$0[enrichedProjectionKind.ordinal()]) {
                case 1: {
                    variance = position;
                    break;
                }
                case 2: {
                    variance = position.opposite();
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                case 4: {
                    variance = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((newPosition = variance) == null) continue;
            noError &= this.checkTypePosition(argument2.getBinding(), containingType, newPosition);
        }
        return noError;
    }

    private final boolean isIrrelevant(CallableDescriptor descriptor2) {
        boolean bl;
        block4: {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return true;
            }
            ClassDescriptor containingClass = classDescriptor;
            List<TypeParameterDescriptor> list2 = containingClass.getTypeConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"containingClass.typeConstructor.parameters");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (this.varianceWithManual(it) == Variance.INVARIANT) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\b*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0082\u0004\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/VarianceCheckerCore$Companion;", "", "()V", "recordPrivateToThis", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "and", "", "other", "(ZLjava/lang/Boolean;)Z", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (callableMemberDescriptor instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
            } else if (callableMemberDescriptor instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptorImpl)descriptor2).getAccessors()) {
                    Intrinsics.checkNotNull((Object)accessor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    ((PropertyAccessorDescriptorImpl)accessor).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean and(boolean $this$and, Boolean other) {
            return other == null ? $this$and : $this$and & other;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnrichedProjectionKind.values().length];
            nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

