/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineFunctionHashProvider;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00f8\u0001\u0000J5\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00050\u00052\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00f8\u0001\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder;", "", "hashProvider", "Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashProvider;", "flatHashes", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashProvider;Ljava/util/Map;)V", "inlineFunctionCallGraph", "", "", "buildHashes", "dirtyFiles", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "buildInlineGraph", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "computedHashed", "GraphBuilder", "InlineFunctionHashProcessor", "backend.js"})
public final class InlineFunctionHashBuilder {
    @NotNull
    private final InlineFunctionHashProvider hashProvider;
    @NotNull
    private final Map<IrFunction, ICHash> flatHashes;
    @NotNull
    private final Map<IrFunction, Set<IrFunction>> inlineFunctionCallGraph;

    public InlineFunctionHashBuilder(@NotNull InlineFunctionHashProvider hashProvider2, @NotNull Map<IrFunction, ICHash> flatHashes) {
        Intrinsics.checkNotNullParameter((Object)hashProvider2, (String)"hashProvider");
        Intrinsics.checkNotNullParameter(flatHashes, (String)"flatHashes");
        this.hashProvider = hashProvider2;
        this.flatHashes = flatHashes;
        this.inlineFunctionCallGraph = new LinkedHashMap();
    }

    @NotNull
    public final Map<IrFunction, ICHash> buildHashes(@NotNull Collection<? extends IrFile> dirtyFiles) {
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile it = (IrFile)element$iv;
            boolean bl = false;
            it.acceptChildren((IrElementVisitor)new GraphBuilder(), (Object)new LinkedHashSet());
        }
        return new InlineFunctionHashProcessor().process();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<IrFile, Map<IdSignature, ICHash>> buildInlineGraph(@NotNull Map<IrFunction, ICHash> computedHashed) {
        void $this$associateTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(computedHashed, (String)"computedHashed");
        Iterable $this$groupBy$iv = this.inlineFunctionCallGraph.entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-InlineFunctionHashBuilder$buildInlineGraph$perFileInlineGraph$32 = false;
            IrFile key$iv$iv = IrUtilsKt.getFile((IrDeclaration)((IrDeclaration)it2.getKey()));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Map.Entry $i$a$-groupBy-InlineFunctionHashBuilder$buildInlineGraph$perFileInlineGraph$32 = (Map.Entry)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            list2.add((Set)it.getValue());
        }
        Map perFileInlineGraph = destination$iv$iv;
        Iterable $this$associate$iv = perFileInlineGraph.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Map usedInlineFunctions = new LinkedHashMap();
            Iterable $this$forEach$iv = (Iterable)it.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set edges = (Set)element$iv;
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = edges;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    long l;
                    IdSignature signature;
                    IrFunction callee = (IrFunction)element$iv2;
                    boolean bl3 = false;
                    if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)callee))) continue;
                    IdSignature idSignature = signature = callee.getSymbol().getSignature();
                    boolean bl4 = idSignature != null ? idSignature.getVisibleCrossFile() : false;
                    if (!bl4) continue;
                    ICHash iCHash = computedHashed.get(callee);
                    if (iCHash != null) {
                        l = iCHash.unbox-impl();
                    } else {
                        ICHash iCHash2 = this.hashProvider.hashForExternalFunction-Z1Gnr_Y(callee);
                        if (iCHash2 != null) {
                            l = iCHash2.unbox-impl();
                        } else {
                            throw new IllegalStateException(("Internal error: No hash found for " + RenderIrElementKt.render((IrElement)((IrElement)callee))).toString());
                        }
                    }
                    long calleeHash = l;
                    ICHash iCHash3 = ICHash.box-impl(calleeHash);
                    usedInlineFunctions.put(signature, iCHash3);
                }
            }
            Pair pair = TuplesKt.to(it.getKey(), (Object)usedInlineFunctions);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder$GraphBuilder;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder;)V", "inlineFunctionCallDepth", "", "getInlineFunctionCallDepth", "()I", "setInlineFunctionCallDepth", "(I)V", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.js"})
    private final class GraphBuilder
    implements IrElementVisitor<Unit, Set<IrFunction>> {
        private int inlineFunctionCallDepth;

        public final int getInlineFunctionCallDepth() {
            return this.inlineFunctionCallDepth;
        }

        public final void setInlineFunctionCallDepth(int n) {
            this.inlineFunctionCallDepth = n;
        }

        public void visitElement(@NotNull IrElement element, @NotNull Set<IrFunction> data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            element.acceptChildren((IrElementVisitor)this, data);
        }

        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Set<IrFunction> data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Set newGraph = new LinkedHashSet();
            InlineFunctionHashBuilder.this.inlineFunctionCallGraph.put(declaration, newGraph);
            declaration.acceptChildren((IrElementVisitor)this, (Object)newGraph);
        }

        public void visitCall(@NotNull IrCall expression2, @NotNull Set<IrFunction> data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (callee.isInline()) {
                if (!callee.isFakeOverride()) {
                    ((Collection)data).add(callee);
                }
                ++this.inlineFunctionCallDepth;
            }
            expression2.acceptChildren((IrElementVisitor)this, data);
            if (callee.isInline()) {
                --this.inlineFunctionCallDepth;
                if (this.inlineFunctionCallDepth < 0) {
                    throw new IllegalStateException("Internal error: inline function calls depth inconsistency".toString());
                }
            }
        }

        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Set<IrFunction> data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            IrFunction reference = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            if (this.inlineFunctionCallDepth > 0 && reference.isInline() && !IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)reference))) {
                ((Collection)data).add(reference);
            }
            expression2.acceptChildren((IrElementVisitor)this, data);
        }

        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer((IrElementVisitor)this, (IrAnonymousInitializer)declaration, data);
        }

        public void visitBlock(@NotNull IrBlock expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBlock((IrElementVisitor)this, (IrBlock)expression2, data);
        }

        public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBlockBody((IrElementVisitor)this, (IrBlockBody)body2, data);
        }

        public void visitBody(@NotNull IrBody body2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBody((IrElementVisitor)this, (IrBody)body2, data);
        }

        public void visitBranch(@NotNull IrBranch branch, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBranch((IrElementVisitor)this, (IrBranch)branch, data);
        }

        public void visitBreak(@NotNull IrBreak jump, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBreak((IrElementVisitor)this, (IrBreak)jump, data);
        }

        public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitBreakContinue((IrElementVisitor)this, (IrBreakContinue)jump, data);
        }

        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitCallableReference((IrElementVisitor)this, expression2, data);
        }

        public void visitCatch(@NotNull IrCatch aCatch, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitCatch((IrElementVisitor)this, (IrCatch)aCatch, data);
        }

        public void visitClass(@NotNull IrClass declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitClass((IrElementVisitor)this, (IrClass)declaration, data);
        }

        public void visitClassReference(@NotNull IrClassReference expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitClassReference((IrElementVisitor)this, (IrClassReference)expression2, data);
        }

        public void visitComposite(@NotNull IrComposite expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitComposite((IrElementVisitor)this, (IrComposite)expression2, data);
        }

        public void visitConst(@NotNull IrConst<?> expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConst((IrElementVisitor)this, expression2, data);
        }

        public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstantArray((IrElementVisitor)this, (IrConstantArray)expression2, data);
        }

        public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstantObject((IrElementVisitor)this, (IrConstantObject)expression2, data);
        }

        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive((IrElementVisitor)this, (IrConstantPrimitive)expression2, data);
        }

        public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstantValue((IrElementVisitor)this, (IrConstantValue)expression2, data);
        }

        public void visitConstructor(@NotNull IrConstructor declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstructor((IrElementVisitor)this, (IrConstructor)declaration, data);
        }

        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitConstructorCall((IrElementVisitor)this, (IrConstructorCall)expression2, data);
        }

        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitContainerExpression((IrElementVisitor)this, (IrContainerExpression)expression2, data);
        }

        public void visitContinue(@NotNull IrContinue jump, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitContinue((IrElementVisitor)this, (IrContinue)jump, data);
        }

        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDeclaration((IrElementVisitor)this, (IrDeclarationBase)declaration, data);
        }

        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference((IrElementVisitor)this, (IrDeclarationReference)expression2, data);
        }

        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitor)this, (IrDelegatingConstructorCall)expression2, data);
        }

        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop((IrElementVisitor)this, (IrDoWhileLoop)loop, data);
        }

        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression((IrElementVisitor)this, (IrDynamicExpression)expression2, data);
        }

        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression((IrElementVisitor)this, (IrDynamicMemberExpression)expression2, data);
        }

        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitor)this, (IrDynamicOperatorExpression)expression2, data);
        }

        public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitElseBranch((IrElementVisitor)this, (IrElseBranch)branch, data);
        }

        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall((IrElementVisitor)this, (IrEnumConstructorCall)expression2, data);
        }

        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitEnumEntry((IrElementVisitor)this, (IrEnumEntry)declaration, data);
        }

        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression((IrElementVisitor)this, (IrErrorCallExpression)expression2, data);
        }

        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration((IrElementVisitor)this, (IrErrorDeclaration)declaration, data);
        }

        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitErrorExpression((IrElementVisitor)this, (IrErrorExpression)expression2, data);
        }

        public void visitExpression(@NotNull IrExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitExpression((IrElementVisitor)this, (IrExpression)expression2, data);
        }

        public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitExpressionBody((IrElementVisitor)this, (IrExpressionBody)body2, data);
        }

        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment((IrElementVisitor)this, (IrExternalPackageFragment)declaration, data);
        }

        public void visitField(@NotNull IrField declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitField((IrElementVisitor)this, (IrField)declaration, data);
        }

        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitFieldAccess((IrElementVisitor)this, (IrFieldAccessExpression)expression2, data);
        }

        public void visitFile(@NotNull IrFile declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitFile((IrElementVisitor)this, (IrFile)declaration, data);
        }

        public void visitFunction(@NotNull IrFunction declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitFunction((IrElementVisitor)this, (IrFunction)declaration, data);
        }

        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitFunctionAccess((IrElementVisitor)this, (IrFunctionAccessExpression)expression2, data);
        }

        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitFunctionExpression((IrElementVisitor)this, (IrFunctionExpression)expression2, data);
        }

        public void visitGetClass(@NotNull IrGetClass expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitGetClass((IrElementVisitor)this, (IrGetClass)expression2, data);
        }

        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue((IrElementVisitor)this, (IrGetEnumValue)expression2, data);
        }

        public void visitGetField(@NotNull IrGetField expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitGetField((IrElementVisitor)this, (IrGetField)expression2, data);
        }

        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue((IrElementVisitor)this, (IrGetObjectValue)expression2, data);
        }

        public void visitGetValue(@NotNull IrGetValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitGetValue((IrElementVisitor)this, (IrGetValue)expression2, data);
        }

        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall((IrElementVisitor)this, (IrInstanceInitializerCall)expression2, data);
        }

        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitor)this, (IrLocalDelegatedProperty)declaration, data);
        }

        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitor)this, (IrLocalDelegatedPropertyReference)expression2, data);
        }

        public void visitLoop(@NotNull IrLoop loop, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitLoop((IrElementVisitor)this, (IrLoop)loop, data);
        }

        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitMemberAccess((IrElementVisitor)this, expression2, data);
        }

        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitModuleFragment((IrElementVisitor)this, (IrModuleFragment)declaration, data);
        }

        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitPackageFragment((IrElementVisitor)this, (IrPackageFragment)declaration, data);
        }

        public void visitProperty(@NotNull IrProperty declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitProperty((IrElementVisitor)this, (IrProperty)declaration, data);
        }

        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitPropertyReference((IrElementVisitor)this, (IrPropertyReference)expression2, data);
        }

        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference((IrElementVisitor)this, (IrRawFunctionReference)expression2, data);
        }

        public void visitReturn(@NotNull IrReturn expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitReturn((IrElementVisitor)this, (IrReturn)expression2, data);
        }

        public void visitScript(@NotNull IrScript declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitScript((IrElementVisitor)this, (IrScript)declaration, data);
        }

        public void visitSetField(@NotNull IrSetField expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSetField((IrElementVisitor)this, (IrSetField)expression2, data);
        }

        public void visitSetValue(@NotNull IrSetValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSetValue((IrElementVisitor)this, (IrSetValue)expression2, data);
        }

        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSingletonReference((IrElementVisitor)this, (IrGetSingletonValue)expression2, data);
        }

        public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSpreadElement((IrElementVisitor)this, (IrSpreadElement)spread, data);
        }

        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation((IrElementVisitor)this, (IrStringConcatenation)expression2, data);
        }

        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression((IrElementVisitor)this, (IrSuspendableExpression)expression2, data);
        }

        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint((IrElementVisitor)this, (IrSuspensionPoint)expression2, data);
        }

        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody((IrElementVisitor)this, (IrSyntheticBody)body2, data);
        }

        public void visitThrow(@NotNull IrThrow expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitThrow((IrElementVisitor)this, (IrThrow)expression2, data);
        }

        public void visitTry(@NotNull IrTry aTry, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitTry((IrElementVisitor)this, (IrTry)aTry, data);
        }

        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitTypeAlias((IrElementVisitor)this, (IrTypeAlias)declaration, data);
        }

        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitTypeOperator((IrElementVisitor)this, (IrTypeOperatorCall)expression2, data);
        }

        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitTypeParameter((IrElementVisitor)this, (IrTypeParameter)declaration, data);
        }

        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitValueAccess((IrElementVisitor)this, (IrValueAccessExpression)expression2, data);
        }

        public void visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitValueParameter((IrElementVisitor)this, (IrValueParameter)declaration, data);
        }

        public void visitVararg(@NotNull IrVararg expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitVararg((IrElementVisitor)this, (IrVararg)expression2, data);
        }

        public void visitVariable(@NotNull IrVariable declaration, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitVariable((IrElementVisitor)this, (IrVariable)declaration, data);
        }

        public void visitWhen(@NotNull IrWhen expression2, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitWhen((IrElementVisitor)this, (IrWhen)expression2, data);
        }

        public void visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull Set<IrFunction> data) {
            IrElementVisitor.DefaultImpls.visitWhileLoop((IrElementVisitor)this, (IrWhileLoop)loop, data);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\n\u00f8\u0001\u0000J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u000eR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder$InlineFunctionHashProcessor;", "", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/InlineFunctionHashBuilder;)V", "computedHashes", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "processingFunctions", "", "process", "", "processCallee", "callee", "processCallee-TVZkk9w", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)J", "processInlineFunction", "f", "processInlineFunction-TVZkk9w", "backend.js"})
    private final class InlineFunctionHashProcessor {
        @NotNull
        private final Map<IrFunction, ICHash> computedHashes = new LinkedHashMap();
        @NotNull
        private final Set<IrFunction> processingFunctions = new LinkedHashSet();

        /*
         * WARNING - void declaration
         */
        private final long processInlineFunction-TVZkk9w(IrFunction f) {
            Object object;
            void $this$getOrPut$iv;
            Map<IrFunction, ICHash> map = this.computedHashes;
            InlineFunctionHashBuilder inlineFunctionHashBuilder = InlineFunctionHashBuilder.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(f);
            if (value$iv == null) {
                long flatHash;
                boolean bl = false;
                if (!this.processingFunctions.add(f)) {
                    throw new IllegalStateException(("Inline circle through function " + RenderIrElementKt.render((IrElement)((IrElement)f)) + " detected").toString());
                }
                Set set = (Set)inlineFunctionHashBuilder.inlineFunctionCallGraph.get(f);
                if (set == null) {
                    throw new IllegalStateException(("Internal error: Inline function is missed in inline graph " + RenderIrElementKt.render((IrElement)((IrElement)f))).toString());
                }
                Set callees = set;
                ICHash iCHash = (ICHash)inlineFunctionHashBuilder.flatHashes.get(f);
                if (iCHash == null) {
                    throw new IllegalStateException(("Internal error: No flat hash for " + RenderIrElementKt.render((IrElement)((IrElement)f))).toString());
                }
                long functionInlineHash = flatHash = iCHash.unbox-impl();
                for (IrFunction callee : callees) {
                    functionInlineHash = ICHash.combineWith-egXBrMc(functionInlineHash, this.processCallee-TVZkk9w(callee));
                }
                this.processingFunctions.remove(f);
                ICHash answer$iv = ICHash.box-impl(functionInlineHash);
                $this$getOrPut$iv.put(f, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((ICHash)object).unbox-impl();
        }

        private final long processCallee-TVZkk9w(IrFunction callee) {
            if (InlineFunctionHashBuilder.this.flatHashes.containsKey(callee)) {
                return this.processInlineFunction-TVZkk9w(callee);
            }
            ICHash iCHash = InlineFunctionHashBuilder.this.hashProvider.hashForExternalFunction-Z1Gnr_Y(callee);
            if (iCHash == null) {
                throw new IllegalStateException(("Internal error: No hash found for " + RenderIrElementKt.render((IrElement)((IrElement)callee))).toString());
            }
            return iCHash.unbox-impl();
        }

        @NotNull
        public final Map<IrFunction, ICHash> process() {
            for (Map.Entry entry : InlineFunctionHashBuilder.this.inlineFunctionCallGraph.entrySet()) {
                IrFunction f = (IrFunction)entry.getKey();
                Set callees = (Set)entry.getValue();
                if (f.isInline()) {
                    this.processInlineFunction-TVZkk9w(f);
                    continue;
                }
                Iterable $this$forEach$iv = callees;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrFunction p0 = (IrFunction)element$iv;
                    boolean bl = false;
                    this.processCallee-TVZkk9w(p0);
                }
            }
            return this.computedHashes;
        }
    }
}

