/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.Difference;
import org.jetbrains.kotlin.incremental.DifferenceCalculator;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForClass;
import org.jetbrains.kotlin.incremental.ProtoCompareGenerated;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/DifferenceCalculatorForClass;", "Lorg/jetbrains/kotlin/incremental/DifferenceCalculator;", "oldData", "Lorg/jetbrains/kotlin/incremental/ClassProtoData;", "newData", "(Lorg/jetbrains/kotlin/incremental/ClassProtoData;Lorg/jetbrains/kotlin/incremental/ClassProtoData;)V", "compareObject", "Lorg/jetbrains/kotlin/incremental/ProtoCompareGenerated;", "getCompareObject", "()Lorg/jetbrains/kotlin/incremental/ProtoCompareGenerated;", "difference", "Lorg/jetbrains/kotlin/incremental/Difference;", "kotlin-build-common"})
public final class DifferenceCalculatorForClass
extends DifferenceCalculator {
    @NotNull
    private final ClassProtoData oldData;
    @NotNull
    private final ClassProtoData newData;
    @NotNull
    private final ProtoCompareGenerated compareObject;

    public DifferenceCalculatorForClass(@NotNull ClassProtoData oldData, @NotNull ClassProtoData newData) {
        Intrinsics.checkNotNullParameter((Object)oldData, (String)"oldData");
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        this.oldData = oldData;
        this.newData = newData;
        this.compareObject = new ProtoCompareGenerated(this.oldData.getNameResolver(), this.newData.getNameResolver(), ProtoDifferenceUtilsKt.getTypeTableOrNull(this.oldData.getProto()), ProtoDifferenceUtilsKt.getTypeTableOrNull(this.newData.getProto()));
    }

    @Override
    @NotNull
    protected ProtoCompareGenerated getCompareObject() {
        return this.compareObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Difference difference() {
        ClassProtoData classProtoData = this.oldData;
        ProtoBuf.Class oldProto = classProtoData.component1();
        NameResolver oldNameResolver = classProtoData.component2();
        ClassProtoData classProtoData2 = this.newData;
        ProtoBuf.Class newProto = classProtoData2.component1();
        NameResolver newNameResolver = classProtoData2.component2();
        EnumSet<ProtoCompareGenerated.ProtoBufClassKind> diff = this.getCompareObject().difference(oldProto, newProto);
        boolean isClassAffected = false;
        boolean areSubclassesAffected = false;
        HashSet changedSupertypes = new HashSet();
        HashSet<String> names2 = new HashSet<String>();
        boolean classIsSealed = ProtoDifferenceUtilsKt.access$isSealed(newProto) && ProtoDifferenceUtilsKt.access$isSealed(oldProto);
        Iterator iterator2 = diff.iterator();
        while (iterator2.hasNext()) {
            Object object;
            ProtoCompareGenerated.ProtoBufClassKind kind;
            ProtoCompareGenerated.ProtoBufClassKind protoBufClassKind = kind = (ProtoCompareGenerated.ProtoBufClassKind)((Object)iterator2.next());
            Intrinsics.checkNotNull((Object)((Object)protoBufClassKind));
            switch (WhenMappings.$EnumSwitchMapping$0[protoBufClassKind.ordinal()]) {
                case 1: {
                    if (oldProto.hasCompanionObjectName()) {
                        DifferenceCalculatorForClass.difference$oldToNames(oldProto.getCompanionObjectName(), names2, oldNameResolver);
                    }
                    if (newProto.hasCompanionObjectName()) {
                        DifferenceCalculatorForClass.difference$newToNames(newProto.getCompanionObjectName(), names2, newNameResolver);
                    }
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    if (classIsSealed) {
                        isClassAffected = true;
                    }
                    List list2 = oldProto.getNestedClassNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"oldProto.nestedClassNameList");
                    List list3 = newProto.getNestedClassNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"newProto.nestedClassNameList");
                    object = names2.addAll(this.calcDifferenceForNames(list2, list3));
                    break;
                }
                case 3: {
                    Collection<String> differentNonPrivateConstructors2 = DifferenceCalculatorForClass.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)((Function1)difference.unused.differentNonPrivateConstructors.1.INSTANCE));
                    isClassAffected = isClassAffected || !differentNonPrivateConstructors2.isEmpty();
                    object = Unit.INSTANCE;
                    break;
                }
                case 4: {
                    object = names2.addAll(DifferenceCalculatorForClass.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)((Function1)difference.unused.1.INSTANCE)));
                    break;
                }
                case 5: {
                    object = names2.addAll(DifferenceCalculatorForClass.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)((Function1)difference.unused.2.INSTANCE)));
                    break;
                }
                case 6: {
                    object = names2.addAll(DifferenceCalculatorForClass.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)((Function1)difference.unused.3.INSTANCE)));
                    break;
                }
                case 7: {
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 8: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 9: 
                case 10: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 15: 
                case 16: {
                    void $this$mapTo$iv$iv;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    List list4 = oldProto.getSupertypeList();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"oldProto.supertypeList");
                    Iterable $this$map$iv = list4;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(NameResolverUtilKt.getClassId((NameResolver)oldNameResolver, (int)it.getClassName()).asSingleFqName());
                    }
                    List oldSupertypes = (List)destination$iv$iv;
                    List list5 = newProto.getSupertypeList();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"newProto.supertypeList");
                    Iterable $this$map$iv2 = list5;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ProtoBuf.Type bl = (ProtoBuf.Type)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(NameResolverUtilKt.getClassId((NameResolver)newNameResolver, (int)it.getClassName()).asSingleFqName());
                    }
                    List newSupertypes = (List)destination$iv$iv2;
                    Set changed = CollectionsKt.subtract((Iterable)CollectionsKt.union((Iterable)oldSupertypes, (Iterable)newSupertypes), (Iterable)CollectionsKt.intersect((Iterable)oldSupertypes, (Iterable)newSupertypes));
                    object = changedSupertypes.addAll(changed);
                    break;
                }
                case 17: 
                case 18: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 19: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 20: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 21: {
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 22: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 23: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 24: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 31: 
                case 32: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Unit unit = object;
        }
        return new Difference(isClassAffected, areSubclassesAffected, (Set<String>)names2, changedSupertypes);
    }

    private static final boolean difference$oldToNames(int $this$difference_u24oldToNames, HashSet<String> names2, NameResolver oldNameResolver) {
        return names2.add(oldNameResolver.getString($this$difference_u24oldToNames));
    }

    private static final boolean difference$newToNames(int $this$difference_u24newToNames, HashSet<String> names2, NameResolver newNameResolver) {
        return names2.add(newNameResolver.getString($this$difference_u24newToNames));
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> difference$calcDifferenceForNonPrivateMembers(ProtoBuf.Class oldProto, ProtoBuf.Class newProto, DifferenceCalculatorForClass this$0, Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>> members) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Iterable $this$filterNot$iv = (Iterable)members.invoke((Object)oldProto);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            MessageLite it = (MessageLite)element$iv$iv;
            boolean bl = false;
            if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List oldMembers = (List)destination$iv$iv;
        Iterable $this$filterNot$iv2 = (Iterable)members.invoke((Object)newProto);
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MessageLite it = (MessageLite)element$iv$iv;
            boolean bl = false;
            if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newMembers = (List)destination$iv$iv2;
        return this$0.calcDifferenceForMembers(oldMembers, newMembers);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoCompareGenerated.ProtoBufClassKind.values().length];
            nArray[ProtoCompareGenerated.ProtoBufClassKind.COMPANION_OBJECT_NAME.ordinal()] = 1;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.NESTED_CLASS_NAME_LIST.ordinal()] = 2;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.CONSTRUCTOR_LIST.ordinal()] = 3;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.FUNCTION_LIST.ordinal()] = 4;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.PROPERTY_LIST.ordinal()] = 5;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.TYPE_ALIAS_LIST.ordinal()] = 6;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.ENUM_ENTRY_LIST.ordinal()] = 7;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.SEALED_SUBCLASS_FQ_NAME_LIST.ordinal()] = 8;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.VERSION_REQUIREMENT_LIST.ordinal()] = 9;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.VERSION_REQUIREMENT_TABLE.ordinal()] = 10;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.FLAGS.ordinal()] = 11;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.FQ_NAME.ordinal()] = 12;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.TYPE_PARAMETER_LIST.ordinal()] = 13;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JS_EXT_CLASS_ANNOTATION_LIST.ordinal()] = 14;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.SUPERTYPE_LIST.ordinal()] = 15;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.SUPERTYPE_ID_LIST.ordinal()] = 16;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JVM_EXT_CLASS_MODULE_NAME.ordinal()] = 17;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JS_EXT_CLASS_CONTAINING_FILE_ID.ordinal()] = 18;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JVM_EXT_CLASS_LOCAL_VARIABLE_LIST.ordinal()] = 19;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JAVA_EXT_IS_PACKAGE_PRIVATE_CLASS.ordinal()] = 20;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.BUILT_INS_EXT_CLASS_ANNOTATION_LIST.ordinal()] = 21;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JVM_EXT_ANONYMOUS_OBJECT_ORIGIN_NAME.ordinal()] = 22;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.KLIB_EXT_CLASS_ANNOTATION_LIST.ordinal()] = 23;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.JVM_EXT_JVM_CLASS_FLAGS.ordinal()] = 24;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.INLINE_CLASS_UNDERLYING_PROPERTY_NAME.ordinal()] = 25;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.INLINE_CLASS_UNDERLYING_TYPE.ordinal()] = 26;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.INLINE_CLASS_UNDERLYING_TYPE_ID.ordinal()] = 27;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.MULTI_FIELD_VALUE_CLASS_UNDERLYING_NAME_LIST.ordinal()] = 28;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.MULTI_FIELD_VALUE_CLASS_UNDERLYING_TYPE_LIST.ordinal()] = 29;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.MULTI_FIELD_VALUE_CLASS_UNDERLYING_TYPE_ID_LIST.ordinal()] = 30;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.CONTEXT_RECEIVER_TYPE_LIST.ordinal()] = 31;
            nArray[ProtoCompareGenerated.ProtoBufClassKind.CONTEXT_RECEIVER_TYPE_ID_LIST.ordinal()] = 32;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

