/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0017\u001a\u00020\u0014*\u00020\u0014\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\r*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\"\u0015\u0010\u0012\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\"\u0015\u0010\u0013\u001a\u00020\u0007*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"fullValueParameterList", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFullValueParameterList", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/util/List;", "hasMangledParameters", "", "getHasMangledParameters", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "hasMangledReturnType", "getHasMangledReturnType", "inlineClassFieldName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassFieldName", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/name/Name;", "isInlineClassFieldGetter", "isMultiFieldValueClassFieldGetter", "requiresMangling", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getRequiresMangling", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "unboxInlineClass", "backend.jvm"})
public final class InlineClassAbiKt {
    @NotNull
    public static final IrType unboxInlineClass(@NotNull IrType $this$unboxInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$unboxInlineClass, (String)"<this>");
        IrType irType = InlineClassAbi.INSTANCE.unboxType($this$unboxInlineClass);
        if (irType == null) {
            irType = $this$unboxInlineClass;
        }
        return irType;
    }

    public static final boolean getRequiresMangling(@NotNull IrType $this$requiresMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$requiresMangling, (String)"<this>");
        IrClass irClass = JvmIrTypeUtilsKt.getErasedUpperBound($this$requiresMangling);
        return IrDeclarationsKt.isSingleFieldValueClass((IrClass)irClass) && !Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)irClass)), (Object)StandardNames.RESULT_FQ_NAME);
    }

    @NotNull
    public static final List<IrValueParameter> getFullValueParameterList(@NotNull IrFunction $this$fullValueParameterList) {
        Intrinsics.checkNotNullParameter((Object)$this$fullValueParameterList, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)$this$fullValueParameterList.getExtensionReceiverParameter()), (Iterable)$this$fullValueParameterList.getValueParameters());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasMangledParameters(@NotNull IrFunction $this$hasMangledParameters) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasMangledParameters, (String)"<this>");
        if ($this$hasMangledParameters.getDispatchReceiverParameter() != null) {
            if (IrDeclarationsKt.isSingleFieldValueClass((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$hasMangledParameters)))) return true;
        }
        Iterable $this$any$iv = InlineClassAbiKt.getFullValueParameterList($this$hasMangledParameters);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                if (!InlineClassAbiKt.getRequiresMangling(it.getType())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!($this$hasMangledParameters instanceof IrConstructor)) return false;
        if (!IrDeclarationsKt.isSingleFieldValueClass((IrClass)AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)$this$hasMangledParameters)))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasMangledReturnType(@NotNull IrFunction $this$hasMangledReturnType) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMangledReturnType, (String)"<this>");
        if (!JvmIrTypeUtilsKt.isInlineClassType($this$hasMangledReturnType.getReturnType())) return false;
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)$this$hasMangledReturnType));
        if (irClass == null) return true;
        if (!IrUtilsKt.isFileClass((IrDeclaration)((IrDeclaration)irClass))) return true;
        return false;
    }

    @NotNull
    public static final Name getInlineClassFieldName(@NotNull IrClass $this$inlineClassFieldName) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineClassFieldName, (String)"<this>");
        InlineClassRepresentation inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation((IrClass)$this$inlineClassFieldName);
        if (inlineClassRepresentation == null) {
            throw new IllegalStateException(("Not an inline class: " + RenderIrElementKt.render((IrElement)((IrElement)$this$inlineClassFieldName))).toString());
        }
        return inlineClassRepresentation.getUnderlyingPropertyName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineClassFieldGetter(@NotNull IrFunction $this$isInlineClassFieldGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassFieldGetter, (String)"<this>");
        IrDeclarationParent irDeclarationParent = $this$isInlineClassFieldGetter.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass = (IrClass)irDeclarationParent;
        if (irClass == null) return false;
        if (!IrDeclarationsKt.isSingleFieldValueClass((IrClass)irClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!($this$isInlineClassFieldGetter instanceof IrSimpleFunction)) return false;
        if ($this$isInlineClassFieldGetter.getExtensionReceiverParameter() != null) return false;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$isInlineClassFieldGetter).getCorrespondingPropertySymbol();
        if (irPropertySymbol == null) return false;
        IrPropertySymbol it = irPropertySymbol;
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)((IrProperty)it.getOwner()).getGetter(), (Object)$this$isInlineClassFieldGetter)) return false;
        if (!Intrinsics.areEqual((Object)((IrProperty)it.getOwner()).getName(), (Object)InlineClassAbiKt.getInlineClassFieldName(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$isInlineClassFieldGetter))))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMultiFieldValueClassFieldGetter(@NotNull IrFunction $this$isMultiFieldValueClassFieldGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClassFieldGetter, (String)"<this>");
        IrDeclarationParent irDeclarationParent = $this$isMultiFieldValueClassFieldGetter.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass = (IrClass)irDeclarationParent;
        if (irClass == null) return false;
        if (!IrDeclarationsKt.isMultiFieldValueClass((IrClass)irClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!($this$isMultiFieldValueClassFieldGetter instanceof IrSimpleFunction)) return false;
        if ($this$isMultiFieldValueClassFieldGetter.getExtensionReceiverParameter() != null) return false;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$isMultiFieldValueClassFieldGetter).getCorrespondingPropertySymbol();
        if (irPropertySymbol == null) return false;
        IrPropertySymbol it = irPropertySymbol;
        boolean bl2 = false;
        MultiFieldValueClassRepresentation multiFieldValueClassRepresentation = IrDeclarationsKt.getMultiFieldValueClassRepresentation((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$isMultiFieldValueClassFieldGetter)));
        if (multiFieldValueClassRepresentation == null) {
            throw new IllegalStateException(("Multi-field value class must have multiFieldValueClassRepresentation: " + RenderIrElementKt.render((IrElement)((IrElement)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$isMultiFieldValueClassFieldGetter))))).toString());
        }
        MultiFieldValueClassRepresentation multiFieldValueClassRepresentation2 = multiFieldValueClassRepresentation;
        if (!Intrinsics.areEqual((Object)((IrProperty)it.getOwner()).getGetter(), (Object)$this$isMultiFieldValueClassFieldGetter)) return false;
        if (!multiFieldValueClassRepresentation2.containsPropertyWithName(((IrProperty)it.getOwner()).getName())) return false;
        return true;
    }
}

