/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common.experimental;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/SecurityData;", "", "privateKey", "Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "token", "", "(Ljava/security/PrivateKey;Ljava/security/PublicKey;[B)V", "getPrivateKey", "()Ljava/security/PrivateKey;", "getPublicKey", "()Ljava/security/PublicKey;", "getToken", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "daemon-common-new"})
public final class SecurityData {
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final PublicKey publicKey;
    @NotNull
    private final byte[] token;

    public SecurityData(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey, @NotNull byte[] token) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.token = token;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final byte[] getToken() {
        return this.token;
    }

    @NotNull
    public final PrivateKey component1() {
        return this.privateKey;
    }

    @NotNull
    public final PublicKey component2() {
        return this.publicKey;
    }

    @NotNull
    public final byte[] component3() {
        return this.token;
    }

    @NotNull
    public final SecurityData copy(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey, @NotNull byte[] token) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return new SecurityData(privateKey, publicKey, token);
    }

    public static /* synthetic */ SecurityData copy$default(SecurityData securityData, PrivateKey privateKey, PublicKey publicKey, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            privateKey = securityData.privateKey;
        }
        if ((n & 2) != 0) {
            publicKey = securityData.publicKey;
        }
        if ((n & 4) != 0) {
            byArray = securityData.token;
        }
        return securityData.copy(privateKey, publicKey, byArray);
    }

    @NotNull
    public String toString() {
        return "SecurityData(privateKey=" + this.privateKey + ", publicKey=" + this.publicKey + ", token=" + Arrays.toString(this.token) + ')';
    }

    public int hashCode() {
        int result2 = this.privateKey.hashCode();
        result2 = result2 * 31 + this.publicKey.hashCode();
        result2 = result2 * 31 + Arrays.hashCode(this.token);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SecurityData)) {
            return false;
        }
        SecurityData securityData = (SecurityData)other;
        if (!Intrinsics.areEqual((Object)this.privateKey, (Object)securityData.privateKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.publicKey, (Object)securityData.publicKey)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.token, (Object)securityData.token);
    }
}

