/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularMapHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class SingularGuavaTableHandler
extends SingularMapHandler {
    private static final String COM_GOOGLE_COMMON_COLLECT_TABLE = "com.google.common.collect.Table";
    private static final String LOMBOK_ROW_KEY = "rowKey";
    private static final String LOMBOK_COLUMN_KEY = "columnKey";
    private static final String LOMBOK_VALUE = "value";
    private final boolean sortedCollection;

    SingularGuavaTableHandler(String guavaQualifiedName, boolean sortedCollection) {
        super(guavaQualifiedName);
        this.sortedCollection = sortedCollection;
    }

    @Override
    public Collection<PsiField> renderBuilderFields(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(0);
        }
        PsiType builderFieldKeyType = this.getBuilderFieldType(info.getFieldType(), info.getProject());
        return Collections.singleton(new LombokLightFieldBuilder(info.getManager(), info.getFieldName(), builderFieldKeyType).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
    }

    @Override
    @NotNull
    protected PsiType getBuilderFieldType(@NotNull PsiType psiFieldType, @NotNull Project project) {
        if (psiFieldType == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(2);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiType rowKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 0);
        PsiType columnKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 1);
        PsiType valueType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 2);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, this.collectionQualifiedName + ".Builder", rowKeyType, columnKeyType, valueType);
        if (psiType == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @Override
    protected void addOneMethodParameter(@NotNull LombokLightMethodBuilder methodBuilder, @NotNull PsiType psiFieldType, @NotNull String singularName) {
        if (methodBuilder == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(4);
        }
        if (psiFieldType == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(5);
        }
        if (singularName == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(6);
        }
        PsiManager psiManager = methodBuilder.getManager();
        PsiType rowKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 0);
        PsiType columnKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 1);
        PsiType valueType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 2);
        methodBuilder.withParameter(LOMBOK_ROW_KEY, rowKeyType);
        methodBuilder.withParameter(LOMBOK_COLUMN_KEY, columnKeyType);
        methodBuilder.withParameter(LOMBOK_VALUE, valueType);
    }

    @Override
    protected void addAllMethodParameter(@NotNull LombokLightMethodBuilder methodBuilder, @NotNull PsiType psiFieldType, @NotNull String singularName) {
        if (methodBuilder == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(7);
        }
        if (psiFieldType == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(8);
        }
        if (singularName == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(9);
        }
        PsiManager psiManager = methodBuilder.getManager();
        PsiType rowKeyType = PsiTypeUtil.extractAllElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 0);
        PsiType columnKeyType = PsiTypeUtil.extractAllElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 1);
        PsiType valueType = PsiTypeUtil.extractAllElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 2);
        PsiType collectionType = PsiTypeUtil.createCollectionType(psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, rowKeyType, columnKeyType, valueType);
        methodBuilder.withParameter(singularName, collectionType);
    }

    @Override
    protected String getClearMethodBody(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(10);
        }
        String codeBlockFormat = "this.{0} = null;\nreturn {1};";
        return MessageFormat.format("this.{0} = null;\nreturn {1};", info.getFieldName(), info.getBuilderChainResult());
    }

    @Override
    protected String getOneMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(11);
        }
        if (info == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(12);
        }
        String codeBlockTemplate = "if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.put(rowKey, columnKey, value);\nreturn {4};";
        return MessageFormat.format("if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.put(rowKey, columnKey, value);\nreturn {4};", info.getFieldName(), singularName, this.collectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    protected String getAllMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(13);
        }
        if (info == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(14);
        }
        String codeBlockTemplate = "if (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.putAll({0});\nreturn {3};";
        return MessageFormat.format("if (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.putAll({0});\nreturn {3};", singularName, this.collectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    protected String renderBuildCode(@NotNull PsiVariable psiVariable, @NotNull String fieldName, @NotNull String builderVariable) {
        if (psiVariable == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(15);
        }
        if (fieldName == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(16);
        }
        if (builderVariable == null) {
            SingularGuavaTableHandler.$$$reportNull$$$0(17);
        }
        PsiManager psiManager = psiVariable.getManager();
        PsiType psiFieldType = psiVariable.getType();
        PsiType rowKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 0);
        PsiType columnKeyType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 1);
        PsiType valueType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager, COM_GOOGLE_COMMON_COLLECT_TABLE, 2);
        return MessageFormat.format("{4}<{1}, {2}, {3}> {0} = {5}.{0} == null ? {4}.<{1}, {2}, {3}>of() : {5}.{0}.build();\n", fieldName, rowKeyType.getCanonicalText(false), columnKeyType.getCanonicalText(false), valueType.getCanonicalText(false), this.collectionQualifiedName, builderVariable);
    }

    @Override
    protected String getEmptyCollectionCall() {
        return this.collectionQualifiedName + ".builder()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFieldType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaTableHandler";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBuilder";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singularName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaTableHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderBuilderFields";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFieldType";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addOneMethodParameter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllMethodParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClearMethodBody";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOneMethodBody";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodBody";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "renderBuildCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

