/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GetterFieldProcessor
extends AbstractFieldProcessor {
    public GetterFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Getter");
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(1);
        }
        if (target == null) {
            GetterFieldProcessor.$$$reportNull$$$0(2);
        }
        String methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation);
        PsiClass psiClass = psiField.getContainingClass();
        if (null != methodVisibility && null != psiClass) {
            target.add((PsiElement)this.createGetterMethod(psiField, psiClass, methodVisibility));
        }
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        String methodVisibility;
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            GetterFieldProcessor.$$$reportNull$$$0(5);
        }
        boolean result = null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
        boolean lazy = this.isLazyGetter(psiAnnotation);
        if (null == methodVisibility && lazy) {
            builder.addWarning(LombokBundle.message("inspection.message.lazy.does.not.work.with.access.level.none", new Object[0]));
        }
        if (result && lazy) {
            if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("private")) {
                builder.addError(LombokBundle.message("inspection.message.lazy.requires.field.to.be.private.final", new Object[0]), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "private", true, false), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", true, false));
                result = false;
            }
            if (!psiField.hasInitializer()) {
                builder.addError(LombokBundle.message("inspection.message.lazy.requires.field.initialization", new Object[0]));
                result = false;
            }
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onMethod");
        if (result) {
            result = this.validateExistingMethods(psiField, builder, true);
        }
        if (result) {
            result = GetterFieldProcessor.validateAccessorPrefix(psiField, builder);
        }
        return result;
    }

    private boolean isLazyGetter(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(6);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "lazy", false);
    }

    private static boolean validateAccessorPrefix(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            GetterFieldProcessor.$$$reportNull$$$0(8);
        }
        boolean result = true;
        if (AccessorsInfo.build(psiField).isPrefixUnDefinedOrNotStartsWith(psiField.getName())) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.getter.for.this.field", new Object[0]));
            result = false;
        }
        return result;
    }

    @NotNull
    public PsiMethod createGetterMethod(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull String methodModifier) {
        boolean isStatic;
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            GetterFieldProcessor.$$$reportNull$$$0(10);
        }
        if (methodModifier == null) {
            GetterFieldProcessor.$$$reportNull$$$0(11);
        }
        String methodName = LombokUtils.getGetterName(psiField);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), methodName).withMethodReturnType(psiField.getType()).withContainingClass(psiClass).withNavigationElement((PsiElement)psiField);
        if (StringUtil.isNotEmpty((String)methodModifier)) {
            methodBuilder.withModifier(methodModifier);
        }
        if (isStatic = psiField.hasModifierProperty("static")) {
            methodBuilder.withModifier("static");
        }
        String blockText = String.format("return %s.%s;", isStatic ? psiClass.getName() : "this", psiField.getName());
        methodBuilder.withBodyText(blockText);
        LombokLightModifierList modifierList = methodBuilder.getModifierList();
        GetterFieldProcessor.copyCopyableAnnotations(psiField, modifierList, LombokCopyableAnnotations.BASE_COPYABLE);
        PsiAnnotation fieldGetterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.Getter");
        GetterFieldProcessor.copyOnXAnnotations(fieldGetterAnnotation, (PsiModifierList)modifierList, "onMethod");
        if (psiField.isDeprecated()) {
            modifierList.addAnnotation("java.lang.Deprecated");
        }
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            GetterFieldProcessor.$$$reportNull$$$0(12);
        }
        return lombokLightMethodBuilder;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            GetterFieldProcessor.$$$reportNull$$$0(13);
        }
        if (psiAnnotation == null) {
            GetterFieldProcessor.$$$reportNull$$$0(14);
        }
        return LombokPsiElementUsage.READ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/GetterFieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/GetterFieldProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetterMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLazyGetter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateAccessorPrefix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGetterMethod";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

