/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class LombokInspection
extends LombokJavaInspectionBase {
    private final ValProcessor valProcessor = new ValProcessor();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokInspection.$$$reportNull$$$0(0);
        }
        return new LombokElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/LombokInspection", "createVisitor"));
    }

    private class LombokElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            LombokInspection.this.valProcessor.verifyVariable(variable, this.holder);
        }

        public void visitParameter(PsiParameter parameter) {
            super.visitParameter(parameter);
            LombokInspection.this.valProcessor.verifyParameter(parameter, this.holder);
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            HashSet<LombokProblem> problems = new HashSet<LombokProblem>();
            for (Processor inspector : LombokProcessorManager.getProcessors(annotation)) {
                problems.addAll(inspector.verifyAnnotation(annotation));
            }
            for (LombokProblem problem : problems) {
                this.holder.registerProblem((PsiElement)annotation, problem.getMessage(), problem.getHighlightType(), problem.getQuickFixes());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
            JavaResolveResult[] results;
            JavaResolveResult resolveResult;
            PsiElement resolved;
            super.visitMethodCallExpression(methodCall);
            PsiExpressionList list = methodCall.getArgumentList();
            PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
            boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
            int parameterCount = list.getExpressions().length;
            if (isThisOrSuper && parameterCount == 0 && (resolved = (resolveResult = (results = referenceToMethod.multiResolve(true)).length == 1 ? results[0] : JavaResolveResult.EMPTY).getElement()) instanceof LombokLightMethodBuilder && ((LombokLightMethodBuilder)resolved).getParameterList().getParameters().length != 0) {
                this.holder.registerProblem((PsiElement)methodCall, LombokBundle.message("inspection.message.default.constructor.doesn.t.exist", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }
}

