/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiUtilCore;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class LombokFieldFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            LombokFieldFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiField)) return false;
        if (DumbService.isDumb((Project)element.getProject())) return false;
        PsiField psiField = (PsiField)element;
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass == null) return false;
        if (Arrays.stream(containingClass.getMethods()).anyMatch(LombokLightMethodBuilder.class::isInstance)) return true;
        if (!Arrays.stream(containingClass.getInnerClasses()).anyMatch(LombokLightClassBuilder.class::isInstance)) return false;
        return true;
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            LombokFieldFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        return new FindUsagesHandler(element){

            @NotNull
            public PsiElement[] getSecondaryElements() {
                PsiField psiField = (PsiField)this.getPsiElement();
                PsiClass containingClass = psiField.getContainingClass();
                if (containingClass != null) {
                    ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                    this.processClass(containingClass, psiField, elements);
                    Arrays.stream(containingClass.getInnerClasses()).forEach(psiClass -> this.processClass((PsiClass)psiClass, psiField, (Collection<PsiElement>)elements));
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements);
                    if (psiElementArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElementArray;
                }
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(1);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            private void processClass(PsiClass containingClass, PsiField refPsiField, Collection<PsiElement> collector) {
                this.processClassMethods(containingClass, refPsiField, collector);
                this.processClassFields(containingClass, refPsiField, collector);
            }

            private void processClassFields(PsiClass containingClass, PsiField refPsiField, Collection<PsiElement> collector) {
                Arrays.stream(containingClass.getFields()).filter(LombokLightFieldBuilder.class::isInstance).filter(psiField -> psiField.getNavigationElement() == refPsiField).forEach(collector::add);
            }

            private void processClassMethods(PsiClass containingClass, PsiField refPsiField, Collection<PsiElement> collector) {
                Arrays.stream(containingClass.getMethods()).filter(LombokLightMethodBuilder.class::isInstance).filter(psiMethod -> psiMethod.getNavigationElement() == refPsiField).forEach(collector::add);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/plushnikov/intellij/plugin/extension/LombokFieldFindUsagesHandlerFactory$1", "getSecondaryElements"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "de/plushnikov/intellij/plugin/extension/LombokFieldFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

