/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.jetbrains.annotations.NotNull;

public abstract class XPathAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            XPathAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            XPathAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(this.isEnabled(event, true));
        if ("MainToolbar".equals(event.getPlace())) {
            this.updateToolbar(event);
        } else if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
            this.updateMainMenu(event);
        } else if ("EditorPopup".equals(event.getPlace())) {
            presentation.setVisible(presentation.isEnabled());
        }
    }

    protected void updateMainMenu(AnActionEvent event) {
        boolean b = XPathAppComponent.getInstance().getConfig().SHOW_IN_MAIN_MENU;
        event.getPresentation().setVisible(b && this.isEnabled(event, false));
    }

    protected void updateToolbar(AnActionEvent event) {
        event.getPresentation().setVisible(XPathAppComponent.getInstance().getConfig().SHOW_IN_TOOLBAR);
    }

    protected boolean isEnabled(AnActionEvent event, boolean checkAvailable) {
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        PsiDocumentManager cem = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = cem.getPsiFile(editor.getDocument());
        if (!(psiFile instanceof XmlFile) || psiFile.getLanguage() == StdFileTypes.DTD.getLanguage()) {
            return false;
        }
        return !checkAvailable || this.isEnabledAt((XmlFile)psiFile, editor.getCaretModel().getOffset());
    }

    protected abstract boolean isEnabledAt(XmlFile var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xpathView/XPathAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xpathView/XPathAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

