/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.util.BaseMatcher;
import org.jetbrains.annotations.Nullable;

public abstract class IncludeAwareMatcher
extends BaseMatcher {
    protected final XmlDocument myDocument;

    public IncludeAwareMatcher(XmlDocument document) {
        this.myDocument = document;
    }

    @Override
    @Nullable
    public XmlTag getRoot() {
        return this.myDocument.getRootTag();
    }

    @Override
    @Nullable
    public final ResolveUtil.Matcher.Result match(XmlTag element) {
        if (XsltSupport.isIncludeOrImport(element)) {
            XmlAttribute href = element.getAttribute("href", null);
            if (href != null) {
                PsiFile file;
                PsiFile psiFile = element.getContainingFile();
                assert (psiFile != null);
                PsiFile f = psiFile.getOriginalFile();
                if (f == psiFile || f.getVirtualFile() == null) {
                    f = this.myDocument.getContainingFile();
                }
                if ((file = ResolveUtil.resolveFile(href, f)) instanceof XmlFile) {
                    return ResolveUtil.Matcher.Result.create(this.changeDocument(((XmlFile)file).getDocument()));
                }
            }
        } else {
            return this.matchImpl(element);
        }
        return null;
    }

    @Nullable
    protected ResolveUtil.Matcher.Result matchImpl(XmlTag element) {
        if (this.matches(element)) {
            return ResolveUtil.Matcher.Result.create(this.transform(element));
        }
        return null;
    }

    protected abstract ResolveUtil.Matcher changeDocument(XmlDocument var1);
}

