/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import com.android.tools.pixelprobe.BlendMode;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.color.Colors;
import com.android.tools.pixelprobe.decoder.psd.PsdFile;
import com.android.tools.pixelprobe.util.Bytes;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PsdUtils {
    static final float CENTIMETER_TO_INCH = 0.39370078f;
    static final float MILLIMETER_TO_INCH = 0.03937008f;
    private static final Pattern PATH_PATTERN = Pattern.compile("([a-zA-Z0-9]+)\\[([0-9]+)\\]");
    private static final Map<String, BlendMode> blendModes = new HashMap<String, BlendMode>();
    private static final Set<String> adjustmentLayers;

    private PsdUtils() {
    }

    static <T> T get(PsdFile.Descriptor descriptor, String path) {
        String[] elements;
        Object result = null;
        PsdFile.Descriptor currentDescriptor = descriptor;
        for (String element : elements = path.split("\\.")) {
            Object data;
            PsdFile.DescriptorItem item;
            int index = -1;
            Matcher matcher = PATH_PATTERN.matcher(element);
            if (matcher.matches()) {
                element = matcher.group(1);
                index = Integer.parseInt(matcher.group(2));
            }
            if ((item = currentDescriptor.items.get(element)) == null || (data = item.value.data) == null) break;
            if (data instanceof PsdFile.DescriptorItem.ValueList) {
                if (index >= 0) {
                    data = ((PsdFile.DescriptorItem.ValueList)data).items.get((int)index).data;
                }
            } else if (data instanceof PsdFile.DescriptorItem.Reference && index >= 0) {
                data = ((PsdFile.DescriptorItem.Reference)data).items.get((int)index).data;
            }
            if (data instanceof PsdFile.Descriptor) {
                currentDescriptor = (PsdFile.Descriptor)data;
                result = currentDescriptor;
                continue;
            }
            result = data instanceof PsdFile.FixedString || data instanceof PsdFile.UnicodeString || data instanceof PsdFile.DescriptorItem.Enumerated ? data.toString() : (data instanceof PsdFile.FixedByteArray ? (Object)((PsdFile.FixedByteArray)data).value : data);
        }
        return (T)result;
    }

    static float getFloat(PsdFile.Descriptor descriptor, String path) {
        return ((Double)PsdUtils.get(descriptor, path)).floatValue();
    }

    static float getFloat(PsdFile.Descriptor descriptor, String path, float defaultValue) {
        Double v = (Double)PsdUtils.get(descriptor, path);
        return v == null ? defaultValue : v.floatValue();
    }

    static float getUnitFloat(PsdFile.Descriptor descriptor, String path, float resolution) {
        return (float)PsdUtils.resolveUnit((PsdFile.DescriptorItem.UnitDouble)PsdUtils.get(descriptor, path), resolution);
    }

    static double resolveUnit(PsdFile.DescriptorItem.UnitDouble unitDouble, float resolution) {
        if ("#Pxl".equals(unitDouble.unit)) {
            return unitDouble.value;
        }
        if ("#Pnt".equals(unitDouble.unit)) {
            return unitDouble.value * (double)resolution / 72.0;
        }
        if ("RrIn".equals(unitDouble.unit)) {
            return unitDouble.value * (double)resolution;
        }
        if ("#Mlm".equals(unitDouble.unit)) {
            return unitDouble.value * 0.03937007859349251 * (double)resolution;
        }
        if ("RrCm".equals(unitDouble.unit)) {
            return unitDouble.value * 0.3937007784843445 * (double)resolution;
        }
        if ("#Prc".equals(unitDouble.unit)) {
            return unitDouble.value / 100.0;
        }
        if ("#Ang".equals(unitDouble.unit)) {
            return unitDouble.value / 360.0;
        }
        return unitDouble.value;
    }

    static boolean getBoolean(PsdFile.Descriptor descriptor, String path) {
        Object value = PsdUtils.get(descriptor, path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return true;
        }
        return "true".equalsIgnoreCase(String.valueOf(value));
    }

    static BlendMode getBlendMode(String mode) {
        BlendMode blendMode = blendModes.get(mode);
        return blendMode != null ? blendMode : BlendMode.NORMAL;
    }

    static Set<String> getAdjustmentLayerKeys() {
        return adjustmentLayers;
    }

    static ColorSpace createColorSpace(PsdFile.ColorProfileBlock block) {
        if (block == null) {
            return null;
        }
        ICC_Profile iccProfile = ICC_Profile.getInstance(block.icc);
        return new ICC_ColorSpace(iccProfile);
    }

    static <T> T get(PsdFile.ImageResources resources, int id) {
        PsdFile.ImageResourceBlock block = resources.blocks.get(id);
        return (T)(block == null ? null : block.data);
    }

    static Color getColor(PsdFile.Descriptor descriptor) {
        return PsdUtils.getColor(descriptor, 1.0f);
    }

    static Color getColor(PsdFile.Descriptor descriptor, float alpha) {
        String colorType;
        PsdFile.Descriptor color = (PsdFile.Descriptor)PsdUtils.get(descriptor, "Clr ");
        if (color == null) {
            return Color.BLACK;
        }
        switch (colorType = color.classId.toString()) {
            case "RGBC": {
                return PsdUtils.colorFromRgb(color, alpha);
            }
            case "HSBC": {
                return PsdUtils.colorFromHsb(color, alpha);
            }
            case "CMYC": {
                return PsdUtils.colorFromCmyk(color, alpha);
            }
            case "LbCl": {
                return PsdUtils.colorFromLab(color, alpha);
            }
            case "Grsc": {
                return PsdUtils.colorFromGray(color, alpha);
            }
        }
        if (alpha == 1.0f) {
            return Color.BLACK;
        }
        return new Color(0.0f, 0.0f, 0.0f, alpha);
    }

    private static Color colorFromRgb(PsdFile.Descriptor color, float alpha) {
        return new Color(PsdUtils.getFloat(color, "Rd  ") / 255.0f, PsdUtils.getFloat(color, "Grn ") / 255.0f, PsdUtils.getFloat(color, "Bl  ") / 255.0f, alpha);
    }

    private static Color colorFromHsb(PsdFile.Descriptor color, float alpha) {
        float[] rgb = Colors.hsbToRgb(PsdUtils.getUnitFloat(color, "H   ", 0.0f), PsdUtils.getFloat(color, "Strt") / 100.0f, PsdUtils.getFloat(color, "Brgh") / 100.0f);
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    private static Color colorFromCmyk(PsdFile.Descriptor color, float alpha) {
        float[] rgb = Colors.getCmykColorSpace().toRGB(new float[]{PsdUtils.getFloat(color, "Cyn "), PsdUtils.getFloat(color, "Mgnt"), PsdUtils.getFloat(color, "Ylw "), PsdUtils.getFloat(color, "Blck")});
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    private static Color colorFromLab(PsdFile.Descriptor color, float alpha) {
        float[] rgb = Colors.getLabColorSpace().toRGB(new float[]{PsdUtils.getFloat(color, "Lmnc"), PsdUtils.getFloat(color, "A   "), PsdUtils.getFloat(color, "B   ")});
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    private static Color colorFromGray(PsdFile.Descriptor color, float alpha) {
        float gray = Colors.linearRgbToRgb(PsdUtils.getFloat(color, "Gry ") / 255.0f);
        return new Color(gray, gray, gray, alpha);
    }

    static void createPaths(PsdFile.ShapeMask mask, ShapeInfo.Builder shapeInfo, AffineTransform transform) {
        Path2D.Float path = null;
        ShapeInfo.PathOp op = ShapeInfo.PathOp.ADD;
        ShapeInfo.PathType type = ShapeInfo.PathType.UNKNOWN;
        PsdFile.PathRecord.BezierKnot firstKnot = null;
        PsdFile.PathRecord.BezierKnot lastKnot = null;
        int moveCount = 0;
        for (PsdFile.PathRecord record : mask.pathRecords) {
            switch (record.selector) {
                case 0: 
                case 3: {
                    if (type == ShapeInfo.PathType.CLOSED) {
                        PsdUtils.addToPath(path, firstKnot, lastKnot);
                        path.closePath();
                    }
                    PsdFile.PathRecord.SubPath subPath = (PsdFile.PathRecord.SubPath)record.data;
                    if (subPath.tag != 0) {
                        if (path != null) {
                            path.transform(transform);
                            if (moveCount > 1) {
                                type = ShapeInfo.PathType.UNKNOWN;
                            }
                            shapeInfo.addPath(new ShapeInfo.Path.Builder().path(path).op(op).type(type).build());
                        }
                        op = PsdUtils.getPathOp(subPath.op);
                        path = new Path2D.Float(0, subPath.knotCount);
                        moveCount = 0;
                    } else if (path == null) {
                        op = ShapeInfo.PathOp.ADD;
                        path = new Path2D.Float(0, subPath.knotCount);
                        moveCount = 0;
                    }
                    type = record.selector == 3 ? ShapeInfo.PathType.OPEN : ShapeInfo.PathType.CLOSED;
                    lastKnot = null;
                    firstKnot = null;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    if (path == null) break;
                    PsdFile.PathRecord.BezierKnot knot = (PsdFile.PathRecord.BezierKnot)record.data;
                    if (lastKnot == null) {
                        path.moveTo(Bytes.fixed8_24ToFloat(knot.anchorX), Bytes.fixed8_24ToFloat(knot.anchorY));
                        firstKnot = knot;
                        ++moveCount;
                    } else {
                        PsdUtils.addToPath(path, knot, lastKnot);
                    }
                    lastKnot = knot;
                }
            }
        }
        if (type == ShapeInfo.PathType.CLOSED) {
            PsdUtils.addToPath(path, firstKnot, lastKnot);
            path.closePath();
        }
        if (path != null) {
            path.transform(transform);
            if (moveCount > 1) {
                type = ShapeInfo.PathType.UNKNOWN;
            }
            shapeInfo.addPath(new ShapeInfo.Path.Builder().path(path).op(op).type(type).build());
        }
    }

    private static ShapeInfo.PathOp getPathOp(int op) {
        switch (op) {
            case 0: {
                return ShapeInfo.PathOp.EXCLUSIVE_OR;
            }
            case 1: {
                return ShapeInfo.PathOp.ADD;
            }
            case 2: {
                return ShapeInfo.PathOp.SUBTRACT;
            }
            case 3: {
                return ShapeInfo.PathOp.INTERSECT;
            }
        }
        return ShapeInfo.PathOp.ADD;
    }

    private static void addToPath(Path2D.Float path, PsdFile.PathRecord.BezierKnot toKnot, PsdFile.PathRecord.BezierKnot lastKnot) {
        float fromX = Bytes.fixed8_24ToFloat(lastKnot.anchorX);
        float fromY = Bytes.fixed8_24ToFloat(lastKnot.anchorY);
        float exitX = Bytes.fixed8_24ToFloat(lastKnot.controlExitX);
        float exitY = Bytes.fixed8_24ToFloat(lastKnot.controlExitY);
        float enterX = Bytes.fixed8_24ToFloat(toKnot.controlEnterX);
        float enterY = Bytes.fixed8_24ToFloat(toKnot.controlEnterY);
        float toX = Bytes.fixed8_24ToFloat(toKnot.anchorX);
        float toY = Bytes.fixed8_24ToFloat(toKnot.anchorY);
        if (exitX == fromX && exitY == fromY && enterX == toX && enterY == toY) {
            path.lineTo(toX, toY);
        } else {
            path.curveTo(exitX, exitY, enterX, enterY, toX, toY);
        }
    }

    static {
        blendModes.put("pass", BlendMode.PASS_THROUGH);
        blendModes.put("norm", BlendMode.NORMAL);
        blendModes.put("diss", BlendMode.DISSOLVE);
        blendModes.put("dark", BlendMode.DARKEN);
        blendModes.put("mul ", BlendMode.MULTIPLY);
        blendModes.put("idiv", BlendMode.COLOR_BURN);
        blendModes.put("lbrn", BlendMode.LINEAR_BURN);
        blendModes.put("dkCl", BlendMode.DARKER_COLOR);
        blendModes.put("lite", BlendMode.LIGHTEN);
        blendModes.put("scrn", BlendMode.SCREEN);
        blendModes.put("div ", BlendMode.COLOR_DODGE);
        blendModes.put("lddg", BlendMode.LINEAR_DODGE);
        blendModes.put("lgCl", BlendMode.LIGHTER_COLOR);
        blendModes.put("over", BlendMode.OVERLAY);
        blendModes.put("sLit", BlendMode.SOFT_LIGHT);
        blendModes.put("hLit", BlendMode.HARD_LIGHT);
        blendModes.put("vLit", BlendMode.VIVID_LIGHT);
        blendModes.put("lLit", BlendMode.LINEAR_LIGHT);
        blendModes.put("pLit", BlendMode.PIN_LIGHT);
        blendModes.put("hMix", BlendMode.HARD_MIX);
        blendModes.put("diff", BlendMode.DIFFERENCE);
        blendModes.put("smud", BlendMode.EXCLUSION);
        blendModes.put("fsub", BlendMode.SUBTRACT);
        blendModes.put("fdiv", BlendMode.DIVIDE);
        blendModes.put("hue ", BlendMode.HUE);
        blendModes.put("sat ", BlendMode.SATURATION);
        blendModes.put("colr", BlendMode.COLOR);
        blendModes.put("lum ", BlendMode.LUMINOSITY);
        blendModes.put("Nrml", BlendMode.NORMAL);
        blendModes.put("Dslv", BlendMode.DISSOLVE);
        blendModes.put("Drkn", BlendMode.DARKEN);
        blendModes.put("Mltp", BlendMode.MULTIPLY);
        blendModes.put("CBrn", BlendMode.COLOR_BURN);
        blendModes.put("linearBurn", BlendMode.LINEAR_BURN);
        blendModes.put("darkerColor", BlendMode.DARKER_COLOR);
        blendModes.put("Lghn", BlendMode.LIGHTEN);
        blendModes.put("Scrn", BlendMode.SCREEN);
        blendModes.put("CDdg", BlendMode.COLOR_DODGE);
        blendModes.put("linearDodge", BlendMode.LINEAR_DODGE);
        blendModes.put("lighterColor", BlendMode.LIGHTER_COLOR);
        blendModes.put("Ovrl", BlendMode.OVERLAY);
        blendModes.put("SftL", BlendMode.SOFT_LIGHT);
        blendModes.put("HrdL", BlendMode.HARD_LIGHT);
        blendModes.put("vividLight", BlendMode.VIVID_LIGHT);
        blendModes.put("linearLight", BlendMode.LINEAR_LIGHT);
        blendModes.put("pinLight", BlendMode.PIN_LIGHT);
        blendModes.put("hardMix", BlendMode.HARD_MIX);
        blendModes.put("Dfrn", BlendMode.DIFFERENCE);
        blendModes.put("Xclu", BlendMode.EXCLUSION);
        blendModes.put("blendSubtraction", BlendMode.SUBTRACT);
        blendModes.put("blendDivide", BlendMode.DIVIDE);
        blendModes.put("H   ", BlendMode.HUE);
        blendModes.put("Strt", BlendMode.SATURATION);
        blendModes.put("Clr ", BlendMode.COLOR);
        blendModes.put("Lmns", BlendMode.LUMINOSITY);
        adjustmentLayers = new HashSet<String>(20);
        adjustmentLayers.add("SoCo");
        adjustmentLayers.add("GdFl");
        adjustmentLayers.add("PtFl");
        adjustmentLayers.add("brit");
        adjustmentLayers.add("levl");
        adjustmentLayers.add("curv");
        adjustmentLayers.add("expA");
        adjustmentLayers.add("vibA");
        adjustmentLayers.add("hue ");
        adjustmentLayers.add("hue2");
        adjustmentLayers.add("blnc");
        adjustmentLayers.add("blwh");
        adjustmentLayers.add("phfl");
        adjustmentLayers.add("mixr");
        adjustmentLayers.add("clrL");
        adjustmentLayers.add("nvrt");
        adjustmentLayers.add("post");
        adjustmentLayers.add("thrs");
        adjustmentLayers.add("grdm");
        adjustmentLayers.add("selc");
    }
}

