/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder;

import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.util.Bytes;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NodeList;

final class PngDecoder
extends Decoder {
    private static final byte[] PNG_HEADER = Bytes.fromHexString("89504e470d0a1a0a");
    private static final float METERS_TO_INCHES = 39.3701f;

    PngDecoder() {
        super("png");
    }

    @Override
    public boolean accept(InputStream in) {
        try {
            byte[] data = new byte[PNG_HEADER.length];
            int read = in.read(data);
            if (read == PNG_HEADER.length) {
                return Arrays.equals(data, PNG_HEADER);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void decodeMetadata(Image.Builder builder, IIOMetadata metadata) {
        IIOMetadataNode colorProfile;
        String compression;
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        NodeList list = root.getElementsByTagName("IHDR");
        if (list.getLength() > 0) {
            IIOMetadataNode header = (IIOMetadataNode)list.item(0);
            try {
                builder.depth(Integer.parseInt(header.getAttribute("bitDepth")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            builder.colorMode(PngDecoder.toColorMode(header.getAttribute("colorType")));
        }
        if ((list = root.getElementsByTagName("pHYs")).getLength() > 0) {
            IIOMetadataNode phys = (IIOMetadataNode)list.item(0);
            try {
                int ppuX = Integer.parseInt(phys.getAttribute("pixelsPerUnitXAxis"));
                int ppuY = Integer.parseInt(phys.getAttribute("pixelsPerUnitXAxis"));
                String unit = phys.getAttribute("unitSpecifier");
                if ("meter".equalsIgnoreCase(unit)) {
                    builder.resolution((float)ppuX / 39.3701f, (float)ppuY / 39.3701f);
                } else {
                    builder.resolution(ppuX, ppuY);
                }
            }
            catch (NumberFormatException ppuX) {
                // empty catch block
            }
        }
        if ((list = root.getElementsByTagName("iCCP")).getLength() > 0 && "deflate".equalsIgnoreCase(compression = (colorProfile = (IIOMetadataNode)list.item(0)).getAttribute("compressionMethod"))) {
            byte[] data = (byte[])colorProfile.getUserObject();
            try (InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(data));){
                ICC_Profile iccProfile = ICC_Profile.getInstance(in);
                builder.colorSpace(new ICC_ColorSpace(iccProfile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static ColorMode toColorMode(String colorType) {
        switch (colorType) {
            case "Grayscale": {
                return ColorMode.GRAYSCALE;
            }
            case "RGB": {
                return ColorMode.RGB;
            }
            case "Palette": {
                return ColorMode.INDEXED;
            }
            case "GrayAlpha": {
                return ColorMode.GRAYSCALE;
            }
            case "RGBAlpha": {
                return ColorMode.RGB;
            }
        }
        return ColorMode.RGB;
    }
}

