/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.util.Lists;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class TextInfo {
    private final String text;
    private final AffineTransform transform;
    private final Rectangle2D.Double bounds;
    private final List<StyleRun> styleRuns;
    private final List<ParagraphRun> paragraphRuns;

    TextInfo(Builder builder) {
        this.text = builder.text;
        this.transform = builder.transform;
        this.bounds = builder.bounds;
        this.styleRuns = Lists.immutableCopy(builder.styleRuns);
        this.paragraphRuns = Lists.immutableCopy(builder.paragraphRuns);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public String getText() {
        return this.text;
    }

    public List<StyleRun> getStyleRuns() {
        return this.styleRuns;
    }

    public List<ParagraphRun> getParagraphRuns() {
        return this.paragraphRuns;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public String toString() {
        return this.text;
    }

    public static final class Builder {
        String text = "";
        final AffineTransform transform = new AffineTransform();
        final Rectangle2D.Double bounds = new Rectangle2D.Double();
        final List<StyleRun> styleRuns = new ArrayList<StyleRun>();
        final List<ParagraphRun> paragraphRuns = new ArrayList<ParagraphRun>();

        public Builder transform(AffineTransform transform) {
            this.transform.setTransform(transform);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder bounds(double left, double top, double right, double bottom) {
            this.bounds.setRect(left, top, right - left, bottom - top);
            return this;
        }

        public Builder addStyleRun(StyleRun run) {
            this.styleRuns.add(run);
            return this;
        }

        public Builder addParagraphRun(ParagraphRun run) {
            this.paragraphRuns.add(run);
            return this;
        }

        public TextInfo build() {
            return new TextInfo(this);
        }
    }

    public static final class ParagraphRun
    extends Run {
        private final Alignment alignment;

        ParagraphRun(Builder builder) {
            super(builder.start, builder.end);
            this.alignment = builder.alignment;
        }

        public Alignment getAlignment() {
            return this.alignment;
        }

        public static final class Builder {
            final int start;
            final int end;
            private Alignment alignment = Alignment.LEFT;

            public Builder(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public Builder alignment(Alignment alignment) {
                this.alignment = alignment;
                return this;
            }

            public ParagraphRun build() {
                return new ParagraphRun(this);
            }
        }
    }

    public static final class StyleRun
    extends Run {
        private final String font;
        private final float fontSize;
        private final Paint paint;
        private final float tracking;

        StyleRun(Builder builder) {
            super(builder.start, builder.end);
            this.font = builder.font;
            this.fontSize = builder.fontSize;
            this.paint = builder.paint;
            this.tracking = builder.tracking;
        }

        public String getFont() {
            return this.font;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public Paint getPaint() {
            return this.paint;
        }

        public float getTracking() {
            return this.tracking;
        }

        public static final class Builder {
            final int start;
            final int end;
            String font = "arial";
            float fontSize = 12.0f;
            Paint paint = Color.BLACK;
            float tracking = 0.0f;

            public Builder(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public Builder font(String font) {
                this.font = font;
                return this;
            }

            public Builder fontSize(float fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public Builder paint(Paint paint) {
                this.paint = paint;
                return this;
            }

            public Builder tracking(float tracking) {
                this.tracking = tracking;
                return this;
            }

            public StyleRun build() {
                return new StyleRun(this);
            }
        }
    }

    public static abstract class Run {
        private int start;
        private int end;
        private int length;

        Run(int start, int end) {
            this.start = start;
            this.end = end;
            this.length = end - start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY;

    }
}

